/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_se_FI extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Gaska-Afrihk\u00e1 \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskva d\u00e1lve\u00e1igi",
               "",
               "Moskva geasse\u00e1igi",
               "",
               "Moskva \u00e1igi",
               "",
            };
        final String[] Japan = new String[] {
               "Jap\u00e1na d\u00e1lve\u00e1igi",
               "",
               "Jap\u00e1na geasse\u00e1igi",
               "",
               "Jap\u00e1na \u00e1igi",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistana d\u00e1lve\u00e1igi",
               "",
               "Pakistana geasse\u00e1igi",
               "",
               "Pakistana \u00e1igi",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipeia d\u00e1lve\u00e1igi",
               "",
               "Taipeia geasse\u00e1igi",
               "",
               "Taipeia \u00e1igi",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovda d\u00e1lve\u00e1igi",
               "",
               "Hovda geasse\u00e1igi",
               "",
               "Hovda \u00e1igi",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadana d\u00e1lve\u00e1igi",
               "",
               "Magadana geasse\u00e1igi",
               "",
               "Magadana \u00e1igi",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Gaska-Austr\u00e1lia oarjjabeali d\u00e1lve\u00e1igi",
               "",
               "Gaska-Austr\u00e1lia oarjjabeali geasse\u00e1igi",
               "",
               "Gaska-Austr\u00e1lia oarjjabeali \u00e1igi",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Gaska-Eurohp\u00e1 d\u00e1lve\u00e1igi",
               "CET",
               "Gaska-Eurohp\u00e1 geasse\u00e1igi",
               "CEST",
               "Gaska-Eurohp\u00e1 \u00e1igi",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Sahalina d\u00e1lve\u00e1igi",
               "",
               "Sahalina geasse\u00e1igi",
               "",
               "Sahalina \u00e1igi",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paraguaya d\u00e1lve\u00e1igi",
               "",
               "Paraguaya geasse\u00e1igi",
               "",
               "Paraguaya \u00e1igi",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malesia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinerejuvvon oktasa\u0161 \u00e1igi",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "d\u00e1lve\u00e1igi nuortan",
               "",
               "geasse\u00e1igi nuortan",
               "",
               "\u00e1igi nuortan",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe d\u00e1lve\u00e1igi",
               "",
               "Lord Howe geasse\u00e1igi",
               "",
               "Lord Howe \u00e1igi",
               "",
            };
        final String[] New_Zealand = new String[] {
               "O\u0111\u0111a-Sel\u00e1nda d\u00e1lve\u00e1igi",
               "",
               "O\u0111\u0111a-Sel\u00e1nda geasse\u00e1igi",
               "",
               "O\u0111\u0111a-Sel\u00e1nda \u00e1igi",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "India\u00e1bi \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakucka d\u00e1lve\u00e1igi",
               "",
               "Jakucka geasse\u00e1igi",
               "",
               "Jakucka \u00e1igi",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritiusa d\u00e1lve\u00e1igi",
               "",
               "Mauritiusa geasse\u00e1igi",
               "",
               "Mauritiusa \u00e1igi",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Nuorta-Afrihk\u00e1 \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "Nuorta-Timora \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonsulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosraea \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallsulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Nuorta-Eurohpa d\u00e1lve\u00e1igi",
               "EET",
               "Nuorta-Eurohpa geasse\u00e1igi",
               "EEST",
               "Nuorta-Eurohpa \u00e1igi",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlanda d\u00e1lve\u00e1igi",
               "",
               "Newfoundlanda geasse\u00e1igi",
               "",
               "Newfoundlanda \u00e1igi",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganisthana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Konga d\u00e1lve\u00e1igi",
               "",
               "Hong Konga geasse\u00e1igi",
               "",
               "Hong Konga \u00e1igi",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "Oarje-Argentina d\u00e1lve\u00e1igi",
               "",
               "Oarje-Argentina geasse\u00e1igi",
               "",
               "Oarje-Argentina \u00e1igi",
               "",
            };
        final String[] Atlantic = new String[] {
               "atl\u00e1ntala\u0161 d\u00e1lve\u00e1igi",
               "",
               "atl\u00e1ntala\u0161 geasse\u00e1igi",
               "",
               "atl\u00e1ntala\u0161 \u00e1igi",
               "",
            };
        final String[] Ponape = new String[] {
               "Ponape \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelo d\u00e1lve\u00e1igi",
               "",
               "St. Pierre & Miquelo geasse\u00e1igi",
               "",
               "St. Pierre & Miquelo \u00e1igi",
               "",
            };
        final String[] Indochina = new String[] {
               "Indokiinn\u00e1 \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburga d\u00e1lve\u00e1igi",
               "",
               "Jekaterinburga geasse\u00e1igi",
               "",
               "Jekaterinburga \u00e1igi",
               "",
            };
        final String[] Maldives = new String[] {
               "Malediivvaid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israela d\u00e1lve\u00e1igi",
               "",
               "Israela geasse\u00e1igi",
               "",
               "Israela \u00e1igi",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Gaska-Indonesia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis- ja Futuna \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Lulli-Afrihk\u00e1 d\u00e1lve\u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Syowa \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Linesulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistana d\u00e1lve\u00e1igi",
               "",
               "Usbekistana geasse\u00e1igi",
               "",
               "Usbekistana \u00e1igi",
               "",
            };
        final String[] Omsk = new String[] {
               "Omska d\u00e1lve\u00e1igi",
               "",
               "Omska geasse\u00e1igi",
               "",
               "Omska \u00e1igi",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychellaid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguaya d\u00e1lve\u00e1igi",
               "",
               "Uruguaya geasse\u00e1igi",
               "",
               "Uruguaya \u00e1igi",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepala \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan-Batora d\u00e1lve\u00e1igi",
               "",
               "Ulan-Batora geasse\u00e1igi",
               "",
               "Ulan-Batora \u00e1igi",
               "",
            };
        final String[] America_Central = new String[] {
               "d\u00e1b\u00e1la\u0161 d\u00e1lve\u00e1igi",
               "",
               "d\u00e1b\u00e1la\u0161 geasse\u00e1igi",
               "",
               "d\u00e1b\u00e1la\u0161\u00e1igi",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuka \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Niue = new String[] {
               "Niuea \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wakesullo \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandsulluid d\u00e1lve\u00e1igi",
               "",
               "Falklandsulluid geasse\u00e1igi",
               "",
               "Falklandsulluid \u00e1igi",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu d\u00e1lve\u00e1igi",
               "",
               "Vanuatu geasse\u00e1igi",
               "",
               "Vanuatu \u00e1igi",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirska d\u00e1lve\u00e1igi",
               "",
               "Novosibirska geasse\u00e1igi",
               "",
               "Novosibirska \u00e1igi",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapore d\u00e1lve\u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Azoraid d\u00e1lve\u00e1igi",
               "",
               "Azoraid geasse\u00e1igi",
               "",
               "Azoraid \u00e1igi",
               "",
            };
        final String[] Apia = new String[] {
               "Apia d\u00e1lve\u00e1igi",
               "",
               "Apia geasse\u00e1igi",
               "",
               "Apia \u00e1igi",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Nauru \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarska d\u00e1lve\u00e1igi",
               "",
               "Krasnojarska geasse\u00e1igi",
               "",
               "Krasnojarska \u00e1igi",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Oarje-Kasakstana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmara \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Juovlasullo \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazona d\u00e1lve\u00e1igi",
               "",
               "Amazona geasse\u00e1igi",
               "",
               "Amazona \u00e1igi",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Nuorta-Kasakstana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Fiji d\u00e1lve\u00e1igi",
               "",
               "Fiji geasse\u00e1igi",
               "",
               "Fiji \u00e1igi",
               "",
            };
        final String[] Reunion = new String[] {
               "Reuniona \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Kokossulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chathama d\u00e1lve\u00e1igi",
               "",
               "Chathama geasse\u00e1igi",
               "",
               "Chathama \u00e1igi",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostoka \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina d\u00e1lve\u00e1igi",
               "",
               "Argentina geasse\u00e1igi",
               "",
               "Argentina \u00e1igi",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiera \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagosa \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "MacQuarie sullo \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-aleuhtala\u0161 d\u00e1lve\u00e1igi",
               "",
               "Hawaii-aleuhtala\u0161 geasse\u00e1igi",
               "",
               "Hawaii-aleuhtala\u0161 \u00e1igi",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Gaska-Austr\u00e1lia d\u00e1lve\u00e1igi",
               "",
               "Gaska-Austr\u00e1lia geasse\u00e1igi",
               "",
               "Gaska-Austr\u00e1lia \u00e1igi",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Jaskes\u00e1bi d\u00e1lve\u00e1igi",
               "",
               "Jaskes\u00e1bi geasse\u00e1igi",
               "",
               "Jaskes\u00e1bi \u00e1igi",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixsulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistana d\u00e1lve\u00e1igi",
               "",
               "Turkmenistana geasse\u00e1igi",
               "",
               "Turkmenistana \u00e1igi",
               "",
            };
        final String[] Europe_Western = new String[] {
               "Oarje-Eurohp\u00e1 d\u00e1lve\u00e1igi",
               "WET",
               "Oarje-Eurohp\u00e1 geasse\u00e1igi",
               "WEST",
               "Oarje-Eurohp\u00e1 \u00e1igi",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Verde d\u00e1lve\u00e1igi",
               "",
               "Kap Verde geasse\u00e1igi",
               "",
               "Kap Verde \u00e1igi",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolksullo \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairnsulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa d\u00e1lve\u00e1igi",
               "",
               "Samoa geasse\u00e1igi",
               "",
               "Samoa \u00e1igi",
               "",
            };
        final String[] Palau = new String[] {
               "Palaua \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbai\u017eana d\u00e1lve\u00e1igi",
               "",
               "Aserbai\u017eana geasse\u00e1igi",
               "",
               "Aserbai\u017eana \u00e1igi",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsona \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksiko J\u00e1skes\u00e1bi d\u00e1lve\u00e1igi",
               "",
               "Meksiko J\u00e1skes\u00e1bi geasse\u00e1igi",
               "",
               "Meksiko J\u00e1skes\u00e1bi \u00e1igi",
               "",
            };
        final String[] Davis = new String[] {
               "Davisa \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Cuba d\u00e1lve\u00e1igi",
               "",
               "Cuba geasse\u00e1igi",
               "",
               "Cuba \u00e1igi",
               "",
            };
        final String[] Africa_Western = new String[] {
               "Oarje-Afrihk\u00e1 d\u00e1lve\u00e1igi",
               "",
               "Oarje-Afrihk\u00e1 geasse\u00e1igi",
               "",
               "Oarje-Afrihk\u00e1 \u00e1igi",
               "",
            };
        final String[] GMT = new String[] {
               "Greenwicha \u00e1igi",
               "GMT",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Filippiinnaid d\u00e1lve\u00e1igi",
               "",
               "Filippiinnaid geasse\u00e1igi",
               "",
               "Filippiinnaid \u00e1igi",
               "",
            };
        final String[] French_Southern = new String[] {
               "Frankriikka lulli & ant\u00e1rktisa \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Lulli-Georgia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "O\u0111\u0111a-Kaledonia d\u00e1lve\u00e1igi",
               "",
               "O\u0111\u0111a-Kaledonia geasse\u00e1igi",
               "",
               "O\u0111\u0111a-Kaledonia \u00e1igi",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalama \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Irana d\u00e1lve\u00e1igi",
               "",
               "Irana geasse\u00e1igi",
               "",
               "Irana \u00e1igi",
               "",
            };
        final String[] Easter = new String[] {
               "Beass\u00e1\u0161sullo d\u00e1lve\u00e1igi",
               "",
               "Beass\u00e1\u0161sullo geasse\u00e1igi",
               "",
               "Beass\u00e1\u0161sullo \u00e1igi",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Oarjedavvi-Meksiko d\u00e1lve\u00e1igi",
               "",
               "Oarjedavvi-Meksiko geasse\u00e1igi",
               "",
               "Oarjedavvi-Meksiko \u00e1igi",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ta\u017eikistana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga d\u00e1lve\u00e1igi",
               "",
               "Tonga geasse\u00e1igi",
               "",
               "Tonga \u00e1igi",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesha d\u00e1lve\u00e1igi",
               "",
               "Bangladesha geasse\u00e1igi",
               "",
               "Bangladesha \u00e1igi",
               "",
            };
        final String[] Peru = new String[] {
               "Peru d\u00e1lve\u00e1igi",
               "",
               "Peru geasse\u00e1igi",
               "",
               "Peru \u00e1igi",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Oarje-Ruon\u00e1eatnama d\u00e1lve\u00e1igi",
               "",
               "Oarje-Ruon\u00e1eatnama geasse\u00e1igi",
               "",
               "Oarje-Ruon\u00e1eatnama \u00e1igi",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadora \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Nuorta-Ruon\u00e1eatnama d\u00e1lve\u00e1igi",
               "",
               "Nuorta-Ruon\u00e1eatnama geasse\u00e1igi",
               "",
               "Nuorta-Ruon\u00e1eatnama \u00e1igi",
               "",
            };
        final String[] Gulf = new String[] {
               "Golfa d\u00e1lve\u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Nuorta-Indonesia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Korea d\u00e1lve\u00e1igi",
               "",
               "Korea geasse\u00e1igi",
               "",
               "Korea \u00e1igi",
               "",
            };
        final String[] Australia_Western = new String[] {
               "Oarje-Austr\u00e1lia d\u00e1lve\u00e1igi",
               "",
               "Oarje-Austr\u00e1lia geasse\u00e1igi",
               "",
               "Oarje-Austr\u00e1lia \u00e1igi",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "Oarje-Indonesia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Nuorta-Austr\u00e1lia d\u00e1lve\u00e1igi",
               "",
               "Nuorta-Austr\u00e1lia geasse\u00e1igi",
               "",
               "Nuorta-Austr\u00e1lia \u00e1igi",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frankriikka Guyana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Colombia d\u00e1lve\u00e1igi",
               "",
               "Colombia geasse\u00e1igi",
               "",
               "Colombia \u00e1igi",
               "",
            };
        final String[] Chile = new String[] {
               "Chile d\u00e1lve\u00e1igi",
               "",
               "Chile geasse\u00e1igi",
               "",
               "Chile \u00e1igi",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbertsulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "d\u00e1lveduottar\u00e1igi",
               "",
               "geasseduottar\u00e1igi",
               "",
               "duottar\u00e1igi",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesasiid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ar\u00e1bia d\u00e1lve\u00e1igi",
               "",
               "Ar\u00e1bia geasse\u00e1igi",
               "",
               "Ar\u00e1bia \u00e1igi",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska d\u00e1lve\u00e1igi",
               "",
               "Alaska geasse\u00e1igi",
               "",
               "Alaska \u00e1igi",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostoka d\u00e1lve\u00e1igi",
               "",
               "Vladivostoka geasse\u00e1igi",
               "",
               "Vladivostoka \u00e1igi",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u010camorro d\u00e1lve\u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkucka d\u00e1lve\u00e1igi",
               "",
               "Irkucka geasse\u00e1igi",
               "",
               "Irkucka \u00e1igi",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgia d\u00e1lve\u00e1igi",
               "",
               "Georgia geasse\u00e1igi",
               "",
               "Georgia \u00e1igi",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelaua \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua O\u0111\u0111a-Guinea \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha d\u00e1lve\u00e1igi",
               "",
               "Fernando de Noronha geasse\u00e1igi",
               "",
               "Fernando de Noronha \u00e1igi",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Choibolsana d\u00e1lve\u00e1igi",
               "",
               "Choibolsana geasse\u00e1igi",
               "",
               "Choibolsana \u00e1igi",
               "",
            };
        final String[] Brasilia = new String[] {
               "Brasilia d\u00e1lve\u00e1igi",
               "",
               "Brasilia geasse\u00e1igi",
               "",
               "Brasilia \u00e1igi",
               "",
            };
        final String[] China = new String[] {
               "Kiinn\u00e1 d\u00e1lve\u00e1igi",
               "",
               "Kiinn\u00e1 geasse\u00e1igi",
               "",
               "Kiinn\u00e1 \u00e1igi",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenia d\u00e1lve\u00e1igi",
               "",
               "Armenia geasse\u00e1igi",
               "",
               "Armenia \u00e1igi",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Pyongyanga \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India d\u00e1lve\u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Cooksulloid d\u00e1lve\u00e1igi",
               "",
               "Cooksulloid geasi beallemuttu \u00e1igi",
               "",
               "Cooksulloid \u00e1igi",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Asia/Irkutsk", "Irkuck" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "timezone.excity.Pacific/Marquesas", "Marquesasat" },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "timezone.excity.America/Danmarkshavn", "D\u00e1nm\u00e1rkkuh\u00e1mman" },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Brihtala\u0161 geasse\u00e1igi",
                    "",
                    "",
                    "",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Davvi-Dakota" },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "JST", Japan },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Jakuck" },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "BET", Brasilia },
            { "America/Araguaina", Brasilia },
            { "ACT", Australia_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Atlantic/Canary", "Kan\u00e1ria" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Etc/GMT", GMT },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "timezone.excity.Europe/Warsaw", "Warsawa" },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.Asia/Novokuznetsk", "Novokusneck" },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/North_Dakota/Center", "Guovdd\u00e1\u0161, Davvi-Dakota" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.Atlantic/South_Georgia", "Lulli-Georgia" },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "CNT", Newfoundland },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Davvi-Dakota" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Athena" },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "NET", Armenia },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "K\u00f8benhavn" },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Etc/Unknown", "Dovdameahttun g\u00e1vpot" },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "America/Ciudad_Juarez", America_Mountain },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.Asia/Damascus", "Damaskos" },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "SystemV/MST7", America_Mountain },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "PLT", Pakistan },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "CST", America_Central },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Irl\u00e1nddala\u0161 d\u00e1lve\u00e1igi",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "SystemV/CST6", America_Central },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "timezone.excity.Europe/Luxembourg", "Luxenburg" },
            { "America/North_Dakota/Center", America_Central },
            { "PNT", America_Mountain },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "BST", Bangladesh },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Europe/Isle_of_Man", "Mansuolu" },
            { "Pacific/Saipan", Chamorro },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Central },
            { "America/Ojinaga", America_Central },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "timezone.excity.Europe/Helsinki", "Helsset" },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "PRT", Atlantic },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "PST", America_Pacific },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Brihtala\u0161 geasse\u00e1igi",
                    "",
                    "",
                    "",
                }
            },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan-Bator" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "NST", New_Zealand },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azorat" },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Indian/Christmas", "Juovlasuolu" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "CAT", Africa_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.Indian/Cocos", "Kokos" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC", ETC_UTC },
            { "SystemV/AST4ADT", Atlantic },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.Europe/Brussels", "Br\u00fcssel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.Indian/Maldives", "Malediivvat" },
        };
        return data;
    }
}
