/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_hy = "armenskt";
        final String metaValue_bn = "bangla";
        final String metaValue_el = "grikskt";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraiskt";
        final String metaValue_ja = "japanskt";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreanskt";
        final String metaValue_ml = "malayalam";
        final String metaValue_or = "odia";
        final String metaValue_ta = "tamilskt";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailendskt";
        final String metaValue_bo = "tibetskt";
        final Object[][] data = new Object[][] {
            { "001", "heimur" },
            { "002", "Afrika" },
            { "003", "Nor\u00f0uramerika" },
            { "005", "Su\u00f0uramerika" },
            { "009", "Osiania" },
            { "011", "Vesturafrika" },
            { "013", "Mi\u00f0amerika" },
            { "014", "Eysturafrika" },
            { "015", "Nor\u00f0urafrika" },
            { "017", "Mi\u00f0afrika" },
            { "018", "sunnari partur av Afrika" },
            { "019", "Amerika" },
            { "021", "Amerika nor\u00f0anfyri Meksiko" },
            { "029", "Karibia" },
            { "030", "Eysturasia" },
            { "034", "Su\u00f0urasia" },
            { "035", "\u00datsynningsasia" },
            { "039", "Su\u00f0urevropa" },
            { "053", "Avstralasia" },
            { "054", "Melanesia" },
            { "057", "Mikronesi \u00f8ki" },
            { "061", "Polynesia" },
            { "142", "Asia" },
            { "143", "Mi\u00f0asia" },
            { "145", "Vesturasia" },
            { "150", "Evropa" },
            { "151", "Eysturevropa" },
            { "154", "Nor\u00f0urevropa" },
            { "155", "Vesturevropa" },
            { "202", "Afrika sunnanfyri Sahara" },
            { "419", "Lat\u00ednamerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Sameindu Emirr\u00edkini" },
            { "AF", "Afganistan" },
            { "AG", "Antigua & Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "AS", "Amerikanska Samoa" },
            { "AT", "Eysturr\u00edki" },
            { "AU", "Avstralia" },
            { "AW", "Aruba" },
            { "AX", "\u00c1land" },
            { "AZ", "Aserbadjan" },
            { "BA", "Bosnia-Hersegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesj" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Barein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Ni\u00f0urlonds Karibia" },
            { "BR", "Brasil" },
            { "BS", "Bahamaoyggjar" },
            { "BT", "Butan" },
            { "BV", "Bouvetoyggj" },
            { "BW", "Botsvana" },
            { "BY", "Hv\u00edtarussland" },
            { "BZ", "Belis" },
            { "CA", "Kanada" },
            { "CC", "Kokosoyggjar" },
            { "CD", "Kongo, Dem. L\u00fd\u00f0veldi\u00f0" },
            { "CF", "Mi\u00f0afrikal\u00fd\u00f0veldi\u00f0" },
            { "CG", "Kongo" },
            { "CH", "Sveis" },
            { "CI", "F\u00edlabeinsstrondin" },
            { "CK", "Cooksoyggjar" },
            { "CL", "Kili" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Kolombia" },
            { "CP", "Clipperton" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Gr\u00f8nh\u00f8vdaoyggjar" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "J\u00f3laoyggjin" },
            { "CY", "K\u00fdpros" },
            { "CZ", "Kekkia" },
            { "DE", "T\u00fdskland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibuti" },
            { "DK", "Danmark" },
            { "DM", "Dominika" },
            { "DO", "Dominikal\u00fd\u00f0veldi\u00f0" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ekvador" },
            { "EE", "Estland" },
            { "EG", "Egyptaland" },
            { "EH", "Vestursahara" },
            { "ER", "Eritrea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "Evropasamveldi\u00f0" },
            { "EZ", "Evrasona" },
            { "FI", "Finnland" },
            { "FJ", "Fiji" },
            { "FK", "Falklandsoyggjar" },
            { "FM", "Mikronesiasamveldi\u00f0" },
            { "FO", "F\u00f8royar" },
            { "FR", "Frakland" },
            { "GA", "Gabon" },
            { "GB", "St\u00f3rabretland" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Franska Gujana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f8nland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorguinea" },
            { "GR", "Grikkaland" },
            { "GS", "Su\u00f0urgeorgia og Su\u00f0ursandwichoyggjar" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Gujana" },
            { "HK", "Hong Kong SAR Kina" },
            { "HM", "Heard og McDonaldoyggjar" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "IC", "Kanariuoyggjar" },
            { "ID", "Indonesia" },
            { "IE", "\u00cdrland" },
            { "IL", "\u00cdsrael" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "St\u00f3ra Bretlands Indiahavoyggjar" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "\u00cdsland" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenja" },
            { "KG", "Kirgisia" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komoroyggjar" },
            { "KN", "St. Kitts & Nevis" },
            { "KP", "Nor\u00f0urkorea" },
            { "KR", "Su\u00f0urkorea" },
            { "KW", "Kuvait" },
            { "KY", "Caymanoyggjar" },
            { "KZ", "Kasakstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lusia" },
            { "LI", "Liktinstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesoto" },
            { "LT", "Litava" },
            { "LU", "Luksemborg" },
            { "LV", "Lettland" },
            { "LY", "Libya" },
            { "MA", "Marokko" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshalloyggjar" },
            { "MK", "Nor\u00f0ur Maked\u00f3nia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Makao SAR Kina" },
            { "MP", "Nor\u00f0aru Mariuoyggjar" },
            { "MQ", "Martinique" },
            { "MR", "M\u00f3ritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "M\u00f3ritius" },
            { "MV", "Maldivoyggjar" },
            { "MW", "Malavi" },
            { "MX", "Meksiko" },
            { "MY", "Malaisia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "N\u00fdkaled\u00f3nia" },
            { "NE", "Niger" },
            { "NF", "Norfolksoyggj" },
            { "NG", "Nigeria" },
            { "NI", "Nikaragua" },
            { "NL", "Ni\u00f0urlond" },
            { "NO", "Noreg" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "N\u00fds\u00e6land" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franska Polynesia" },
            { "PG", "Papua N\u00fdguinea" },
            { "PH", "Filipsoyggjar" },
            { "PK", "Pakistan" },
            { "PL", "P\u00f3lland" },
            { "PM", "Saint Pierre & Miquelon" },
            { "PN", "Pitcairnoyggjar" },
            { "PR", "Puerto Riko" },
            { "PS", "Palestinskt land\u00f8ki" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Katar" },
            { "QO", "fjarskoti Osiania" },
            { "RE", "R\u00e9union" },
            { "RO", "Rumenia" },
            { "RS", "Serbia" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "SA", "Saudiarabia" },
            { "SB", "Salomonoyggjar" },
            { "SC", "Seyskelloyggjar" },
            { "SD", "Sudan" },
            { "SE", "Sv\u00f8r\u00edki" },
            { "SG", "Singapor" },
            { "SH", "St. Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leona" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Su\u00f0ursudan" },
            { "ST", "Sao Tome & Prinsipi" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00fdria" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- og Caicosoyggjar" },
            { "TD", "Kjad" },
            { "TF", "Fronsku sunnaru landa\u00f8ki" },
            { "TG", "Togo" },
            { "TH", "Tailand" },
            { "TJ", "Tadsjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Eysturtimor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesia" },
            { "TO", "Tonga" },
            { "TR", "Turkaland" },
            { "TT", "Trinidad & Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taivan" },
            { "TZ", "Tansania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "Sambandsr\u00edki Amerikas fjarskotnu oyggjar" },
            { "UN", "Sameindu Tj\u00f3\u00f0ir" },
            { "US", "Sambandsr\u00edki Amerika" },
            { "UY", "Uruguai" },
            { "UZ", "Usbekistan" },
            { "VA", "Vatikanb\u00fdur" },
            { "VC", "St. Vinsent & Grenadinoyggjar" },
            { "VE", "Venesuela" },
            { "VG", "St\u00f3ra Bretlands Jomfr\u00faoyggjar" },
            { "VI", "Sambandsr\u00edki Amerikas Jomfr\u00faoyggjar" },
            { "VN", "Vjetnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis- og Futunaoyggjar" },
            { "WS", "Samoa" },
            { "XA", "\u00f3ekta t\u00f3nalag" },
            { "XB", "\u00f3ekta\u00f0ur BIDI tekstur" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Su\u00f0urafrika" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabvi" },
            { "ZZ", "\u00f3kent \u00f8ki" },
            { "aa", "afar" },
            { "ab", "abkhasiskt" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhariskt" },
            { "an", "aragoniskt" },
            { "ar", "arabiskt" },
            { "as", "assamesiskt" },
            { "av", "avariskt" },
            { "ay", "aymara" },
            { "az", "aserbajdsjanskt" },
            { "ba", "bashkir" },
            { "be", "hvitarussiskt" },
            { "bg", "bulgarskt" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretonskt" },
            { "bs", "bosniskt" },
            { "ca", "katalani" },
            { "ce", "tjetjenskt" },
            { "ch", "chamorro" },
            { "co", "korsikanskt" },
            { "cs", "kekkiskt" },
            { "cu", "kirkju sl\u00e1viskt" },
            { "cv", "chuvash" },
            { "cy", "walisiskt" },
            { "da", "danskt" },
            { "de", "t\u00fdskt" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "enskt" },
            { "eo", "esperanto" },
            { "es", "spanskt" },
            { "et", "estiskt" },
            { "eu", "baskiskt" },
            { "fa", "persiskt" },
            { "ff", "fulah" },
            { "fi", "finskt" },
            { "fj", "fijim\u00e1l" },
            { "fo", "f\u00f8royskt" },
            { "fr", "franskt" },
            { "fy", "vestur fr\u00edsiskt" },
            { "ga", "\u00edrskt" },
            { "gd", "skotskt g\u00e6liskt" },
            { "gl", "galisiskt" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hr", "kroatiskt" },
            { "ht", "haitiskt creole" },
            { "hu", "ungarskt" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesiskt" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "io", "ido" },
            { "is", "\u00edslendskt" },
            { "it", "italskt" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "javanskt" },
            { "ka", "georgiskt" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "kurdiskt" },
            { "kv", "komi" },
            { "kw", "corniskt" },
            { "ky", "kyrgyz" },
            { "la", "lat\u00edn" },
            { "lb", "luksemborgskt" },
            { "lg", "ganda" },
            { "li", "limburgiskt" },
            { "ln", "lingala" },
            { "lo", "laoskt" },
            { "lt", "litaviskt" },
            { "lu", "luba-katanga" },
            { "lv", "lettiskt" },
            { "mg", "malagassiskt" },
            { "mh", "marshallesiskt" },
            { "mi", "maori" },
            { "mk", "maked\u00f3nskt" },
            { "ml", metaValue_ml },
            { "mn", "mongolskt" },
            { "mr", "marathi" },
            { "ms", "malaiiskt" },
            { "mt", "maltiskt" },
            { "my", "burmesiskt" },
            { "na", "nauru" },
            { "nb", "norskt b\u00f3km\u00e1l" },
            { "nd", "nor\u00f0ur ndebele" },
            { "ne", "nepalskt" },
            { "ng", "ndonga" },
            { "nl", "h\u00e1lendskt" },
            { "nn", "n\u00fdnorskt" },
            { "no", "norskt" },
            { "nr", "su\u00f0ur ndebele" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitanskt" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "ossetiskt" },
            { "pa", "punjabi" },
            { "pl", "p\u00f3lskt" },
            { "ps", "pashto" },
            { "pt", "portugiskiskt" },
            { "qu", "quechua" },
            { "rm", "retoromanskt" },
            { "rn", "rundi" },
            { "ro", "rumenskt" },
            { "ru", "russiskt" },
            { "rw", "kinyarwanda" },
            { "sa", "sanskrit" },
            { "sc", "sardiskt" },
            { "sd", "sindhi" },
            { "se", "nor\u00f0ur s\u00e1miskt" },
            { "sg", "sango" },
            { "sh", "serbokroatiskt" },
            { "si", "singalesiskt" },
            { "sk", "slovakiskt" },
            { "sl", "slovenskt" },
            { "sm", "s\u00e1moiskt" },
            { "sn", "shona" },
            { "so", "somaliskt" },
            { "sq", "albanskt" },
            { "sr", "serbiskt" },
            { "ss", "swatiskt" },
            { "st", "sesotho" },
            { "su", "sundanesiskt" },
            { "sv", "svenskt" },
            { "sw", "swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tajik" },
            { "th", metaValue_th },
            { "ti", "tigrinya" },
            { "tk", "turkmenskt" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonganskt" },
            { "tr", "turkiskt" },
            { "ts", "tsonga" },
            { "tt", "tatar" },
            { "tw", "twi" },
            { "ty", "tahitiskt" },
            { "ug", "uyghur" },
            { "uk", "ukrainskt" },
            { "ur", "urdu" },
            { "uz", "usbekiskt" },
            { "ve", "venda" },
            { "vi", "vjetnamesiskt" },
            { "vo", "volapykk" },
            { "wa", "walloon" },
            { "wo", "wolof" },
            { "xh", "xhosa" },
            { "yi", "jiddiskt" },
            { "yo", "yoruba" },
            { "zh", "kinesiskt" },
            { "zu", "sulu" },
            { "ace", "achinese" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "agq", "aghem" },
            { "ain", "ainu" },
            { "ale", "aleut" },
            { "alt", "su\u00f0ur altai" },
            { "anp", "angika" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "asa", "asu" },
            { "ast", "asturianskt" },
            { "awa", "awadhi" },
            { "ban", "balinesiskt" },
            { "bas", "basaa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgn", "vestur balochi" },
            { "bho", "bhojpuri" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "brx", "bodo" },
            { "bss", "bakossi" },
            { "bug", "buginesiskt" },
            { "byn", "blin" },
            { "ccp", "khakma" },
            { "ceb", "cebuano" },
            { "cgg", "chiga" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "cho", "choctaw" },
            { "chr", "cherokee" },
            { "chy", "cheyenne" },
            { "ckb", "mi\u00f0kurdiskt" },
            { "crs", "seselwa creole franskt" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "dgr", "dogrib" },
            { "dje", "sarma" },
            { "dsb", "l\u00e1gt sorbian" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "eka", "ekajuk" },
            { "ewo", "ewondo" },
            { "fil", "filipiniskt" },
            { "fon", "fon" },
            { "fur", "friuliskt" },
            { "gaa", "ga" },
            { "gag", "gagauz" },
            { "gan", "gan kinesiskt" },
            { "gez", "geez" },
            { "gil", "kiribatiskt" },
            { "gor", "gorontalo" },
            { "gsw", "t\u00fdskt (Sveis)" },
            { "guz", "gusii" },
            { "gwi", "gwich\u2019in" },
            { "hak", "hakka kinesiskt" },
            { "haw", "hawaiianskt" },
            { "hil", "hiligaynon" },
            { "hmn", "hmong" },
            { "hsb", "ovara sorbian" },
            { "hsn", "xiang kinesiskt" },
            { "hup", "hupa" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ilo", "iloko" },
            { "inh", "inguish" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "machame" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kbd", "kabardinskt" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "gr\u00f8nh\u00f8vdaoyggjarskt" },
            { "kfo", "koro" },
            { "kha", "khasi" },
            { "khq", "koyra chiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permyak" },
            { "kok", "konkani" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "karelskt" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f8lnskt" },
            { "kum", "kumyk" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lez", "lezghian" },
            { "lkt", "lakota" },
            { "loz", "lozi" },
            { "lrc", "nor\u00f0ur luri" },
            { "lua", "luba-lulua" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "maduresiskt" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "morisyen" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta\u02bc" },
            { "mic", "micmac" },
            { "min", "minangkabau" },
            { "mni", "manupuri" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "ymisk m\u00e1l" },
            { "mus", "creek" },
            { "mwl", "mirandesiskt" },
            { "myv", "erzya" },
            { "mzn", "mazanderani" },
            { "nan", "min nan kinesiskt" },
            { "nap", "napolitanskt" },
            { "naq", "nama" },
            { "nds", "l\u00e1gt t\u00fdskt" },
            { "new", "newari" },
            { "nia", "nias" },
            { "niu", "niuean" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogai" },
            { "nqo", "n\u02bcko" },
            { "nso", "nor\u00f0ur sotho" },
            { "nus", "nuer" },
            { "nyn", "nyankole" },
            { "pag", "pangasinan" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauan" },
            { "pcm", "nigeriskt pidgin" },
            { "prg", "prusslanskt" },
            { "quc", "k\u02bciche\u02bc" },
            { "rap", "rapanui" },
            { "rar", "rarotongiskt" },
            { "rof", "rombo" },
            { "rup", "aromenskt" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "sakha" },
            { "saq", "samburu" },
            { "sat", "santali" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sisilanskt" },
            { "sco", "skotskt" },
            { "sdh", "su\u00f0ur kurdiskt" },
            { "seh", "sena" },
            { "ses", "koyraboro senni" },
            { "shi", "tachelhit" },
            { "shn", "shan" },
            { "sma", "su\u00f0ur s\u00e1miskt" },
            { "smj", "lule s\u00e1miskt" },
            { "smn", "inari sami" },
            { "sms", "skolt s\u00e1miskt" },
            { "snk", "soninke" },
            { "srn", "sranan tongo" },
            { "ssy", "saho" },
            { "suk", "sukuma" },
            { "swb", "komoriskt" },
            { "syr", "syriac" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "tet", "tetum" },
            { "tig", "tigre" },
            { "tlh", "klingonskt" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasawaq" },
            { "tyv", "tuvinian" },
            { "tzm", "mi\u00f0atlasfj\u00f8ll tamazight" },
            { "udm", "udmurt" },
            { "umb", "umbundu" },
            { "und", "\u00f3kent m\u00e1l" },
            { "vai", "vai" },
            { "vun", "vunjo" },
            { "wae", "walser" },
            { "wal", "wolaytta" },
            { "war", "waray" },
            { "wbp", "warlpiri" },
            { "wuu", "wu kinesiskt" },
            { "xal", "kalmyk" },
            { "xog", "soga" },
            { "yav", "yangben" },
            { "ybb", "yemba" },
            { "yue", "kantonesiskt" },
            { "zgh", "vanligt marokanskt tamazight" },
            { "zun", "zuni" },
            { "zxx", "einki m\u00e1lsligt innihald" },
            { "zza", "zaza" },
            { "Arab", "arabisk" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "blindaskrift" },
            { "Cyrl", "kyrilliskt" },
            { "Deva", "devanagari" },
            { "Ethi", "etiopiskt" },
            { "Geor", "georgianskt" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanb" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hans", "einkult" },
            { "Hant", "vanligt" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hrkt", "japanskir stavir" },
            { "Jamo", "jamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", "lao" },
            { "Latn", "lat\u00ednskt" },
            { "Mlym", metaValue_ml },
            { "Mong", "mongolsk" },
            { "Mymr", "myanmarskt" },
            { "Orya", metaValue_or },
            { "Sinh", "sinhala" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Zmth", "st\u00f8ddfr\u00f8\u00f0ilig teknskipan" },
            { "Zsye", "emoji" },
            { "Zsym", "tekin" },
            { "Zxxx", "\u00f3skriva" },
            { "Zyyy", "vanlig" },
            { "Zzzz", "\u00f3kend skrift" },
            { "de_AT", "t\u00fdskt (Eysturr\u00edki)" },
            { "de_CH", "h\u00f8gt t\u00fdskt (Sveis)" },
            { "en_AU", "enskt (Avstralia)" },
            { "en_CA", "enskt (Kanada)" },
            { "en_GB", "enskt (St\u00f3rabretland)" },
            { "en_US", "enskt (Sambandsr\u00edki Amerika)" },
            { "es_ES", "spanskt (Spania)" },
            { "es_MX", "spanskt (Meksiko)" },
            { "fa_AF", "dari" },
            { "fr_CA", "franskt (Kanada)" },
            { "fr_CH", "franskt (Sveis)" },
            { "nl_BE", "flamskt" },
            { "pt_BR", "portugiskiskt (Brasilia)" },
            { "pt_PT", "portugiskiskt (Evropa)" },
            { "ro_MD", "moldaviskt" },
            { "sw_CD", "kongo svahili" },
            { "ar_001", "n\u00fat\u00ed\u00f0ar vanligt arabiskt" },
            { "es_419", "spanskt (Lat\u00ednamerika)" },
            { "key.ca", "kalendari" },
            { "key.cf", "gjaldoyra format" },
            { "key.co", "ra\u00f0skipan" },
            { "key.cu", "gjaldoyra" },
            { "key.hc", "klokkuskipan (12 \u00edm\u00f3ti 24)" },
            { "key.lb", "reglubrot st\u00edlur" },
            { "key.ms", "m\u00e1tingareind" },
            { "key.nu", "t\u00f8l" },
            { "nds_NL", "l\u00e1gt saksiskt" },
            { "zh_Hans", "einkult kinesiskt" },
            { "zh_Hant", "vanligt kinesiskt" },
            { "%%PINYIN", "pinyin" },
            { "%%MONOTON", "monoton\u00edsk" },
            { "%%POLYTON", "polyton\u00edsk" },
            { "%%WADEGILE", "Wade-Giles" },
            { "type.ca.roc", "minguo kalendari" },
            { "type.co.eor", "r\u00f6\u00f0ina fyrir fj\u00f6ltyngi evr\u00f3pskum skj\u00f6lum" },
            { "type.hc.h11", "12 t\u00edmar klokkuskipan (0\u201311)" },
            { "type.hc.h12", "12 t\u00edmar klokkuskipan (1\u201312)" },
            { "type.hc.h23", "24 t\u00edmar klokkuskipan (0\u201323)" },
            { "type.hc.h24", "24 t\u00edmar klokkuskipan (1\u201324)" },
            { "type.nu.arab", "arabisk t\u00f8l" },
            { "type.nu.armn", "armensk t\u00f8l" },
            { "type.nu.beng", "bangla t\u00f8l" },
            { "type.nu.deva", "devanagarik t\u00f8l" },
            { "type.nu.ethi", "etiopisk t\u00f8l" },
            { "type.nu.geor", "gregoriansk t\u00f8l" },
            { "type.nu.grek", "grikskt t\u00f8l" },
            { "type.nu.gujr", "gujaratik t\u00f8l" },
            { "type.nu.guru", "gurmukhik t\u00f8l" },
            { "type.nu.hans", "einkul kinesisk t\u00f8l" },
            { "type.nu.hant", "vanlig kinesisk t\u00f8l" },
            { "type.nu.hebr", "hebraisk t\u00f8l" },
            { "type.nu.jpan", "japanskt t\u00f8l" },
            { "type.nu.khmr", "khmer t\u00f8l" },
            { "type.nu.knda", "kannada t\u00f8l" },
            { "type.nu.laoo", "lao t\u00f8l" },
            { "type.nu.latn", "vesturlendsk t\u00f8l" },
            { "type.nu.mlym", "malayalam t\u00f8l" },
            { "type.nu.mymr", "myanmarsk t\u00f8l" },
            { "type.nu.orya", "odia t\u00f8l" },
            { "type.nu.taml", "vanlig tamilsk t\u00f8l" },
            { "type.nu.telu", "telugu t\u00f8l" },
            { "type.nu.thai", "tailendsk t\u00f8l" },
            { "type.nu.tibt", "tibetsk t\u00f8l" },
            { "type.ca.dangi", "dangi kalendari" },
            { "type.co.ducet", "forsett Unicode ra\u00f0skipan" },
            { "type.lb.loose", "leysur reglubrot st\u00edlur" },
            { "type.nu.roman", "r\u00f3mart\u00f8l" },
            { "type.ca.hebrew", "hebraiskur kalendari" },
            { "type.co.search", "vanlig leiting" },
            { "type.lb.normal", "vanligur reglubrot st\u00edlur" },
            { "type.lb.strict", "strangur reglubrot st\u00edlur" },
            { "type.ms.metric", "metralag" },
            { "type.ca.chinese", "kinesiskur kalendari" },
            { "type.ca.islamic", "islamiskur kalendari" },
            { "type.ca.iso8601", "ISO-8601 kalendari" },
            { "type.ca.persian", "persiskur kalendari" },
            { "type.cf.account", "gjaldoyras roknskaparf\u00f8rsla format" },
            { "type.nu.arabext", "v\u00ed\u00f0ka\u00f0 arabisk t\u00f8l" },
            { "type.nu.armnlow", "armensk t\u00f8l (sm\u00e1ir b\u00f3kstavir)" },
            { "type.nu.greklow", "grikskt t\u00f8l (sm\u00e1ir b\u00f3kstavir)" },
            { "type.nu.hanidec", "kinesisk desimal t\u00f8l" },
            { "type.nu.hansfin", "einkul kinesisk f\u00edggjarlig t\u00f8l" },
            { "type.nu.hantfin", "vanlig kinesisk f\u00edggjarlig t\u00f8l" },
            { "type.nu.jpanfin", "japanskt f\u00edggjarlig t\u00f8l" },
            { "type.nu.tamldec", "tamilsk t\u00f8l" },
            { "type.ca.buddhist", "buddistiskur kalendari" },
            { "type.ca.ethiopic", "etiopiskur kalendari" },
            { "type.ca.japanese", "japanskur kalendari" },
            { "type.cf.standard", "vanlig gjaldoyra format" },
            { "type.co.standard", "vanlig ra\u00f0skipan" },
            { "type.ms.uksystem", "m\u00e1tingareind (UK)" },
            { "type.ms.ussystem", "m\u00e1tingareind (USA)" },
            { "type.nu.fullwide", "t\u00f8l \u00ed fullari longd" },
            { "type.nu.romanlow", "r\u00f3mart\u00f8l (sm\u00e1ir b\u00f3kstavir)" },
            { "type.ca.gregorian", "gregorianskur kalendari" },
        };
        return data;
    }
}
