/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_sk extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ccp = "čakma";
        final String metaValue_bm = "bambarčina";
        final String metaValue_su = "sundčina";
        final String metaValue_syr = "sýrčina";
        final Object[][] data = new Object[][] {
            { "001", "svet" },
            { "002", "Afrika" },
            { "003", "Severná Amerika" },
            { "005", "Južná Amerika" },
            { "009", "Oceánia" },
            { "011", "západná Afrika" },
            { "013", "Stredná Amerika" },
            { "014", "východná Afrika" },
            { "015", "severná Afrika" },
            { "017", "stredná Afrika" },
            { "018", "južné územia Afriky" },
            { "019", "Amerika" },
            { "021", "severné územia Ameriky" },
            { "029", "Karibik" },
            { "030", "východná Ázia" },
            { "034", "južná Ázia" },
            { "035", "juhovýchodná Ázia" },
            { "039", "južná Európa" },
            { "053", "Australázia" },
            { "054", "Melanézia" },
            { "057", "oblasť Mikronézie" },
            { "061", "Polynézia" },
            { "142", "Ázia" },
            { "143", "stredná Ázia" },
            { "145", "západná Ázia" },
            { "150", "Európa" },
            { "151", "východná Európa" },
            { "154", "severná Európa" },
            { "155", "západná Európa" },
            { "202", "subsaharská Afrika" },
            { "419", "Latinská Amerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Spojené arabské emiráty" },
            { "AF", "Afganistan" },
            { "AG", "Antigua a Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albánsko" },
            { "AM", "Arménsko" },
            { "AO", "Angola" },
            { "AQ", "Antarktída" },
            { "AR", "Argentína" },
            { "AS", "Americká Samoa" },
            { "AT", "Rakúsko" },
            { "AU", "Austrália" },
            { "AW", "Aruba" },
            { "AX", "Alandy" },
            { "AZ", "Azerbajdžan" },
            { "BA", "Bosna a Hercegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladéš" },
            { "BE", "Belgicko" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulharsko" },
            { "BH", "Bahrajn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Svätý Bartolomej" },
            { "BM", "Bermudy" },
            { "BN", "Brunej" },
            { "BO", "Bolívia" },
            { "BQ", "Karibské Holandsko" },
            { "BR", "Brazília" },
            { "BS", "Bahamy" },
            { "BT", "Bhután" },
            { "BV", "Bouvetov ostrov" },
            { "BW", "Botswana" },
            { "BY", "Bielorusko" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosové ostrovy" },
            { "CD", "Konžská demokratická republika" },
            { "CF", "Stredoafrická republika" },
            { "CG", "Konžská republika" },
            { "CH", "Švajčiarsko" },
            { "CI", "Pobrežie Slonoviny" },
            { "CK", "Cookove ostrovy" },
            { "CL", "Čile" },
            { "CM", "Kamerun" },
            { "CN", "Čína" },
            { "CO", "Kolumbia" },
            { "CP", "Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Kapverdy" },
            { "CW", "Curaçao" },
            { "CX", "Vianočný ostrov" },
            { "CY", "Cyprus" },
            { "CZ", "Česko" },
            { "DE", "Nemecko" },
            { "DG", "Diego Garcia" },
            { "DJ", "Džibutsko" },
            { "DK", "Dánsko" },
            { "DM", "Dominika" },
            { "DO", "Dominikánska republika" },
            { "DZ", "Alžírsko" },
            { "EA", "Ceuta a Melilla" },
            { "EC", "Ekvádor" },
            { "EE", "Estónsko" },
            { "EG", "Egypt" },
            { "EH", "Západná Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Španielsko" },
            { "ET", "Etiópia" },
            { "EU", "Európska únia" },
            { "EZ", "eurozóna" },
            { "FI", "Fínsko" },
            { "FJ", "Fidži" },
            { "FK", "Falklandy" },
            { "FM", "Mikronézia" },
            { "FO", "Faerské ostrovy" },
            { "FR", "Francúzsko" },
            { "GA", "Gabon" },
            { "GB", "Spojené kráľovstvo" },
            { "GD", "Grenada" },
            { "GE", "Gruzínsko" },
            { "GF", "Francúzska Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltár" },
            { "GL", "Grónsko" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Rovníková Guinea" },
            { "GR", "Grécko" },
            { "GS", "Južná Georgia a Južné Sandwichove ostrovy" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong – OAO Číny" },
            { "HM", "Heardov ostrov a Macdonaldove ostrovy" },
            { "HN", "Honduras" },
            { "HR", "Chorvátsko" },
            { "HT", "Haiti" },
            { "HU", "Maďarsko" },
            { "IC", "Kanárske ostrovy" },
            { "ID", "Indonézia" },
            { "IE", "Írsko" },
            { "IL", "Izrael" },
            { "IM", "Ostrov Man" },
            { "IN", "India" },
            { "IO", "Britské indickooceánske územie" },
            { "IQ", "Irak" },
            { "IR", "Irán" },
            { "IS", "Island" },
            { "IT", "Taliansko" },
            { "JE", "Jersey" },
            { "JM", "Jamajka" },
            { "JO", "Jordánsko" },
            { "JP", "Japonsko" },
            { "KE", "Keňa" },
            { "KG", "Kirgizsko" },
            { "KH", "Kambodža" },
            { "KI", "Kiribati" },
            { "KM", "Komory" },
            { "KN", "Svätý Krištof a Nevis" },
            { "KP", "Severná Kórea" },
            { "KR", "Južná Kórea" },
            { "KW", "Kuvajt" },
            { "KY", "Kajmanie ostrovy" },
            { "KZ", "Kazachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Svätá Lucia" },
            { "LI", "Lichtenštajnsko" },
            { "LK", "Srí Lanka" },
            { "LR", "Libéria" },
            { "LS", "Lesotho" },
            { "LT", "Litva" },
            { "LU", "Luxembursko" },
            { "LV", "Lotyšsko" },
            { "LY", "Líbya" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavsko" },
            { "ME", "Čierna Hora" },
            { "MF", "Svätý Martin (fr.)" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallove ostrovy" },
            { "MK", "Severné Macedónsko" },
            { "ML", "Mali" },
            { "MM", "Mjanmarsko" },
            { "MN", "Mongolsko" },
            { "MO", "Macao – OAO Číny" },
            { "MP", "Severné Mariány" },
            { "MQ", "Martinik" },
            { "MR", "Mauritánia" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maurícius" },
            { "MV", "Maldivy" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malajzia" },
            { "MZ", "Mozambik" },
            { "NA", "Namíbia" },
            { "NC", "Nová Kaledónia" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigéria" },
            { "NI", "Nikaragua" },
            { "NL", "Holandsko" },
            { "NO", "Nórsko" },
            { "NP", "Nepál" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nový Zéland" },
            { "OM", "Omán" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francúzska Polynézia" },
            { "PG", "Papua-Nová Guinea" },
            { "PH", "Filipíny" },
            { "PK", "Pakistan" },
            { "PL", "Poľsko" },
            { "PM", "Saint Pierre a Miquelon" },
            { "PN", "Pitcairnove ostrovy" },
            { "PR", "Portoriko" },
            { "PS", "Palestínske územia" },
            { "PT", "Portugalsko" },
            { "PW", "Palau" },
            { "PY", "Paraguaj" },
            { "QA", "Katar" },
            { "QO", "ostatné Tichomorie" },
            { "RE", "Réunion" },
            { "RO", "Rumunsko" },
            { "RS", "Srbsko" },
            { "RU", "Rusko" },
            { "RW", "Rwanda" },
            { "SA", "Saudská Arábia" },
            { "SB", "Šalamúnove ostrovy" },
            { "SC", "Seychely" },
            { "SD", "Sudán" },
            { "SE", "Švédsko" },
            { "SG", "Singapur" },
            { "SH", "Svätá Helena" },
            { "SI", "Slovinsko" },
            { "SJ", "Svalbard a Jan Mayen" },
            { "SK", "Slovensko" },
            { "SL", "Sierra Leone" },
            { "SM", "San Maríno" },
            { "SN", "Senegal" },
            { "SO", "Somálsko" },
            { "SR", "Surinam" },
            { "SS", "Južný Sudán" },
            { "ST", "Svätý Tomáš a Princov ostrov" },
            { "SV", "Salvádor" },
            { "SX", "Svätý Martin (hol.)" },
            { "SY", "Sýria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks a Caicos" },
            { "TD", "Čad" },
            { "TF", "Francúzske južné a antarktické územia" },
            { "TG", "Togo" },
            { "TH", "Thajsko" },
            { "TJ", "Tadžikistan" },
            { "TK", "Tokelau" },
            { "TL", "Východný Timor" },
            { "TM", "Turkménsko" },
            { "TN", "Tunisko" },
            { "TO", "Tonga" },
            { "TR", "Turecko" },
            { "TT", "Trinidad a Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzánia" },
            { "UA", "Ukrajina" },
            { "UG", "Uganda" },
            { "UM", "Menšie odľahlé ostrovy USA" },
            { "UN", "Organizácia Spojených národov" },
            { "US", "Spojené štáty" },
            { "UY", "Uruguaj" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikán" },
            { "VC", "Svätý Vincent a Grenadíny" },
            { "VE", "Venezuela" },
            { "VG", "Britské Panenské ostrovy" },
            { "VI", "Americké Panenské ostrovy" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis a Futuna" },
            { "WS", "Samoa" },
            { "XA", "falošná diakritika" },
            { "XB", "obrátenie sprava doľava" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Južná Afrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "neznámy región" },
            { "aa", "afarčina" },
            { "ab", "abcházčina" },
            { "ae", "avestčina" },
            { "af", "afrikánčina" },
            { "ak", "akančina" },
            { "am", "amharčina" },
            { "an", "aragónčina" },
            { "ar", "arabčina" },
            { "as", "ásamčina" },
            { "av", "avarčina" },
            { "ay", "aymarčina" },
            { "az", "azerbajdžančina" },
            { "ba", "baškirčina" },
            { "be", "bieloruština" },
            { "bg", "bulharčina" },
            { "bi", "bislama" },
            { "bm", metaValue_bm },
            { "bn", "bengálčina" },
            { "bo", "tibetčina" },
            { "br", "bretónčina" },
            { "bs", "bosniačtina" },
            { "ca", "katalánčina" },
            { "ce", "čečenčina" },
            { "ch", "čamorčina" },
            { "co", "korzičtina" },
            { "cr", "krí" },
            { "cs", "čeština" },
            { "cu", "cirkevná slovančina" },
            { "cv", "čuvaština" },
            { "cy", "waleština" },
            { "da", "dánčina" },
            { "de", "nemčina" },
            { "dv", "maldivčina" },
            { "dz", "dzongkha" },
            { "ee", "eweština" },
            { "el", "gréčtina" },
            { "en", "angličtina" },
            { "eo", "esperanto" },
            { "es", "španielčina" },
            { "et", "estónčina" },
            { "eu", "baskičtina" },
            { "fa", "perzština" },
            { "ff", "fulbčina" },
            { "fi", "fínčina" },
            { "fj", "fidžijčina" },
            { "fo", "faerčina" },
            { "fr", "francúzština" },
            { "fy", "západná frízština" },
            { "ga", "írčina" },
            { "gd", "škótska gaelčina" },
            { "gl", "galícijčina" },
            { "gn", "guaraníjčina" },
            { "gu", "gudžarátčina" },
            { "gv", "mančina" },
            { "ha", "hauština" },
            { "he", "hebrejčina" },
            { "hi", "hindčina" },
            { "ho", "hiri motu" },
            { "hr", "chorvátčina" },
            { "ht", "haitská kreolčina" },
            { "hu", "maďarčina" },
            { "hy", "arménčina" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonézština" },
            { "ie", "interlingue" },
            { "ig", "igboština" },
            { "ii", "s’čchuanská iovčina" },
            { "ik", "inupik" },
            { "io", "ido" },
            { "is", "islandčina" },
            { "it", "taliančina" },
            { "iu", "inuktitut" },
            { "ja", "japončina" },
            { "jv", "jávčina" },
            { "ka", "gruzínčina" },
            { "kg", "kongčina" },
            { "ki", "kikujčina" },
            { "kj", "kuaňama" },
            { "kk", "kazaština" },
            { "kl", "grónčina" },
            { "km", "khmérčina" },
            { "kn", "kannadčina" },
            { "ko", "kórejčina" },
            { "kr", "kanurijčina" },
            { "ks", "kašmírčina" },
            { "ku", "kurmandži" },
            { "kv", "komijčina" },
            { "kw", "kornčina" },
            { "ky", "kirgizština" },
            { "la", "latinčina" },
            { "lb", "luxemburčina" },
            { "lg", "gandčina" },
            { "li", "limburčina" },
            { "ln", "lingalčina" },
            { "lo", "laoština" },
            { "lt", "litovčina" },
            { "lu", "lubčina (katanžská)" },
            { "lv", "lotyština" },
            { "mg", "malgaština" },
            { "mh", "marshallčina" },
            { "mi", "maorijčina" },
            { "mk", "macedónčina" },
            { "ml", "malajálamčina" },
            { "mn", "mongolčina" },
            { "mr", "maráthčina" },
            { "ms", "malajčina" },
            { "mt", "maltčina" },
            { "my", "barmčina" },
            { "na", "nauruština" },
            { "nb", "nórčina (bokmal)" },
            { "nd", "ndebelčina (severná)" },
            { "ne", "nepálčina" },
            { "ng", "ndonga" },
            { "nl", "holandčina" },
            { "nn", "nórčina (nynorsk)" },
            { "no", "nórčina" },
            { "nr", "ndebelčina (južná)" },
            { "nv", "navaho" },
            { "ny", "ňandža" },
            { "oc", "okcitánčina" },
            { "oj", "odžibva" },
            { "om", "oromčina" },
            { "or", "uríjčina" },
            { "os", "osetčina" },
            { "pa", "pandžábčina" },
            { "pi", "pálí" },
            { "pl", "poľština" },
            { "ps", "paštčina" },
            { "pt", "portugalčina" },
            { "qu", "kečuánčina" },
            { "rm", "rétorománčina" },
            { "rn", "rundčina" },
            { "ro", "rumunčina" },
            { "ru", "ruština" },
            { "rw", "rwandčina" },
            { "sa", "sanskrit" },
            { "sc", "sardínčina" },
            { "sd", "sindhčina" },
            { "se", "saamčina (severná)" },
            { "sg", "sango" },
            { "sh", "srbochorvátčina" },
            { "si", "sinhalčina" },
            { "sk", "slovenčina" },
            { "sl", "slovinčina" },
            { "sm", "samojčina" },
            { "sn", "šončina" },
            { "so", "somálčina" },
            { "sq", "albánčina" },
            { "sr", "srbčina" },
            { "ss", "svazijčina" },
            { "st", "sothčina (južná)" },
            { "su", metaValue_su },
            { "sv", "švédčina" },
            { "sw", "swahilčina" },
            { "ta", "tamilčina" },
            { "te", "telugčina" },
            { "tg", "tadžičtina" },
            { "th", "thajčina" },
            { "ti", "tigriňa" },
            { "tk", "turkménčina" },
            { "tl", "tagalčina" },
            { "tn", "tswančina" },
            { "to", "tongčina" },
            { "tr", "turečtina" },
            { "ts", "tsongčina" },
            { "tt", "tatárčina" },
            { "tw", "twi" },
            { "ty", "tahitčina" },
            { "ug", "ujgurčina" },
            { "uk", "ukrajinčina" },
            { "ur", "urdčina" },
            { "uz", "uzbečtina" },
            { "ve", "vendčina" },
            { "vi", "vietnamčina" },
            { "vo", "volapük" },
            { "wa", "valónčina" },
            { "wo", "wolofčina" },
            { "xh", "xhoština" },
            { "yi", "jidiš" },
            { "yo", "jorubčina" },
            { "za", "čuangčina" },
            { "zh", "čínština" },
            { "zu", "zuluština" },
            { "ace", "acehčina" },
            { "ach", "ačoli" },
            { "ada", "adangme" },
            { "ady", "adygejčina" },
            { "afh", "afrihili" },
            { "agq", "aghem" },
            { "ain", "ainčina" },
            { "akk", "akkadčina" },
            { "ale", "aleutčina" },
            { "alt", "južná altajčina" },
            { "ang", "stará angličtina" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramejčina" },
            { "arn", "mapudungun" },
            { "arp", "arapažština" },
            { "ars", "arabčina (nadždská)" },
            { "arw", "arawačtina" },
            { "asa", "asu" },
            { "ast", "astúrčina" },
            { "atj", "atikamekwčina" },
            { "awa", "awadhi" },
            { "bal", "balúčtina" },
            { "ban", "balijčina" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "bbj", "ghomala" },
            { "bej", "bedža" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bfd", "bafut" },
            { "bgc", "haryanvi" },
            { "bgn", "západná balúčtina" },
            { "bho", "bhódžpurčina" },
            { "bik", "bikolčina" },
            { "bin", "bini" },
            { "bkm", "kom" },
            { "bla", "siksika" },
            { "blo", "anii" },
            { "bra", "bradžčina" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "buriatčina" },
            { "bug", "bugiština" },
            { "bum", "bulu" },
            { "byn", "blin" },
            { "byv", "medumba" },
            { "cad", "kaddo" },
            { "car", "karibčina" },
            { "cay", "kajugčina" },
            { "cch", "atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "cebuánčina" },
            { "cgg", "kiga" },
            { "chb", "čibča" },
            { "chg", "čagatajčina" },
            { "chk", "chuuk" },
            { "chm", "marijčina" },
            { "chn", "činucký žargón" },
            { "cho", "čoktčina" },
            { "chp", "čipevajčina" },
            { "chr", "čerokí" },
            { "chy", "čejenčina" },
            { "ckb", "kurdčina (sorání)" },
            { "clc", "chilcotin" },
            { "cop", "koptčina" },
            { "crg", "michif" },
            { "crh", "krymská tatárčina" },
            { "crj", "cree (juhovýchod)" },
            { "crk", "plains cree" },
            { "crl", "northern east cree" },
            { "crm", "moose cree" },
            { "crr", "karolínska algonkčina" },
            { "crs", "seychelská kreolčina" },
            { "csb", "kašubčina" },
            { "csw", "swampy cree" },
            { "dak", "dakotčina" },
            { "dar", "darginčina" },
            { "dav", "taita" },
            { "del", "delawarčina" },
            { "den", "slavé" },
            { "dgr", "dogribčina" },
            { "din", "dinkčina" },
            { "dje", "zarma" },
            { "doi", "dógrí" },
            { "dsb", "dolnolužická srbčina" },
            { "dua", "duala" },
            { "dum", "stredná holandčina" },
            { "dyo", "jola-fonyi" },
            { "dyu", "ďula" },
            { "dzg", "dazaga" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "staroegyptčina" },
            { "eka", "ekadžuk" },
            { "elx", "elamčina" },
            { "enm", "stredná angličtina" },
            { "ewo", "ewondo" },
            { "fan", "fangčina" },
            { "fat", "fanti" },
            { "fil", "filipínčina" },
            { "fon", "fončina" },
            { "frc", "francúzština (cajunská)" },
            { "frm", "stredná francúzština" },
            { "fro", "stará francúzština" },
            { "frr", "severná frízština" },
            { "frs", "východofrízština" },
            { "fur", "friulčina" },
            { "gaa", "ga" },
            { "gag", "gagauzština" },
            { "gay", "gayo" },
            { "gba", "gbaja" },
            { "gez", "etiópčina" },
            { "gil", "kiribatčina" },
            { "gmh", "stredná horná nemčina" },
            { "goh", "stará horná nemčina" },
            { "gon", "góndčina" },
            { "gor", "gorontalo" },
            { "got", "gótčina" },
            { "grb", "grebo" },
            { "grc", "starogréčtina" },
            { "gsw", "nemčina (švajčiarska)" },
            { "guz", "gusii" },
            { "gwi", "kučinčina" },
            { "hai", "haida" },
            { "haw", "havajčina" },
            { "hax", "haida (juh)" },
            { "hil", "hiligajnončina" },
            { "hit", "chetitčina" },
            { "hmn", "hmongčina" },
            { "hsb", "hornolužická srbčina" },
            { "hup", "hupčina" },
            { "hur", "halkomelem" },
            { "iba", "ibančina" },
            { "ibb", "ibibio" },
            { "ikt", "inuktitut (západná Kanada)" },
            { "ilo", "ilokánčina" },
            { "inh", "inguština" },
            { "jbo", "lojban" },
            { "jgo", "ngomba" },
            { "jmc", "mašame" },
            { "jpr", "židovská perzština" },
            { "jrb", "židovská arabčina" },
            { "kaa", "karakalpačtina" },
            { "kab", "kabylčina" },
            { "kac", "kačjinčina" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", "kawi" },
            { "kbd", "kabardčina" },
            { "kbl", "kanembu" },
            { "kcg", "tyap" },
            { "kde", "makonde" },
            { "kea", "kapverdčina" },
            { "kfo", "koro" },
            { "kgp", "kaingang" },
            { "kha", "khasijčina" },
            { "kho", "chotančina" },
            { "khq", "západná songhajčina" },
            { "kkj", "kako" },
            { "kln", "kalendžin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permiačtina" },
            { "kok", "konkánčina" },
            { "kos", "kusaie" },
            { "kpe", "kpelle" },
            { "krc", "karačajevsko-balkarčina" },
            { "krl", "karelčina" },
            { "kru", "kuruchčina" },
            { "ksb", "šambala" },
            { "ksf", "bafia" },
            { "ksh", "kolínčina" },
            { "kum", "kumyčtina" },
            { "kut", "kutenajčina" },
            { "kwk", "kwakʼwala" },
            { "kxv", "kuvi" },
            { "lad", "židovská španielčina" },
            { "lag", "langi" },
            { "lah", "lahandčina" },
            { "lam", "lamba" },
            { "lez", "lezginčina" },
            { "lij", "ligurčina" },
            { "lil", "lillooet" },
            { "lkt", "lakotčina" },
            { "lmo", "lombardčina" },
            { "lol", "mongo" },
            { "lou", "kreolčina (Louisiana)" },
            { "loz", "lozi" },
            { "lrc", "severné luri" },
            { "lsm", "saamia" },
            { "lua", "lubčina (luluánska)" },
            { "lui", "luiseňo" },
            { "lun", "lunda" },
            { "lus", "mizorámčina" },
            { "luy", "luhja" },
            { "mad", "madurčina" },
            { "maf", "mafa" },
            { "mag", "magadhčina" },
            { "mai", "maithilčina" },
            { "mak", "makasarčina" },
            { "man", "mandingo" },
            { "mas", "masajčina" },
            { "mde", "maba" },
            { "mdf", "mokšiančina" },
            { "mdr", "mandarčina" },
            { "men", "mendejčina" },
            { "mer", "meru" },
            { "mfe", "maurícijská kreolčina" },
            { "mga", "stredná írčina" },
            { "mgh", "makua-meetto" },
            { "mgo", "meta’" },
            { "mic", "mikmakčina" },
            { "min", "minangkabaučina" },
            { "mnc", "mandžuština" },
            { "mni", "manípurčina" },
            { "moe", "innu-aimunčina" },
            { "moh", "mohawkčina" },
            { "mos", "mossi" },
            { "mua", "mundang" },
            { "mul", "viaceré jazyky" },
            { "mus", "kríkčina" },
            { "mwl", "mirandčina" },
            { "mwr", "marwari" },
            { "mye", "myene" },
            { "myv", "erzjančina" },
            { "mzn", "mázandaránčina" },
            { "nap", "neapolčina" },
            { "naq", "nama" },
            { "nds", "dolná nemčina" },
            { "new", "nevárčina" },
            { "nia", "niasánčina" },
            { "niu", "niueština" },
            { "nmg", "kwasio" },
            { "nnh", "ngiemboon" },
            { "nog", "nogajčina" },
            { "non", "stará nórčina" },
            { "nqo", "n’ko" },
            { "nso", "sothčina (severná)" },
            { "nus", "nuer" },
            { "nwc", "klasická nevárčina" },
            { "nym", "ňamwezi" },
            { "nyn", "ňankole" },
            { "nyo", "ňoro" },
            { "nzi", "nzima" },
            { "ojb", "northwestern ojibwa" },
            { "ojc", "centrálna odžibvejčina" },
            { "ojs", "oji-cree" },
            { "ojw", "ojibwa (západ)" },
            { "oka", "okanagan" },
            { "osa", "osedžština" },
            { "ota", "osmanská turečtina" },
            { "pag", "pangasinančina" },
            { "pal", "pahlaví" },
            { "pam", "kapampangančina" },
            { "pap", "papiamento" },
            { "pau", "palaučina" },
            { "pcm", "nigerijský pidžin" },
            { "peo", "stará perzština" },
            { "phn", "feničtina" },
            { "pis", "pidžin" },
            { "pon", "pohnpeiština" },
            { "pqm", "maliseet-passamaquoddy" },
            { "prg", "pruština" },
            { "pro", "stará okcitánčina" },
            { "quc", "quiché" },
            { "raj", "radžastančina" },
            { "rap", "rapanujčina" },
            { "rar", "rarotongská maorijčina" },
            { "rhg", "rohingčina" },
            { "rof", "rombo" },
            { "rom", "rómčina" },
            { "rup", "arumunčina" },
            { "rwk", "rwa" },
            { "sad", "sandaweština" },
            { "sah", "jakutčina" },
            { "sam", "samaritánska aramejčina" },
            { "saq", "samburu" },
            { "sas", "sasačtina" },
            { "sat", "santalčina" },
            { "sba", "ngambay" },
            { "sbp", "sangu" },
            { "scn", "sicílčina" },
            { "sco", "škótčina" },
            { "sdh", "južná kurdčina" },
            { "see", "senekčina" },
            { "seh", "sena" },
            { "sel", "selkupčina" },
            { "ses", "koyraboro senni" },
            { "sga", "stará írčina" },
            { "shi", "tachelhit" },
            { "shn", "šančina" },
            { "shu", "čadská arabčina" },
            { "sid", "sidamo" },
            { "slh", "lushootseed (juh)" },
            { "sma", "saamčina (južná)" },
            { "smj", "saamčina (lulská)" },
            { "smn", "saamčina (inarijská)" },
            { "sms", "saamčina (skoltská)" },
            { "snk", "soninke" },
            { "sog", "sogdijčina" },
            { "srn", "surinamčina" },
            { "srr", "sererčina" },
            { "ssy", "saho" },
            { "str", "straits salish" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumerčina" },
            { "swb", "komorčina" },
            { "syc", "sýrčina (klasická)" },
            { "syr", metaValue_syr },
            { "szl", "sliezština" },
            { "tce", "tutchone (juh)" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "terêna" },
            { "tet", "tetumčina" },
            { "tgx", "tagiš" },
            { "tht", "tahltan" },
            { "tig", "tigrejčina" },
            { "tiv", "tiv" },
            { "tkl", "tokelauština" },
            { "tlh", "klingónčina" },
            { "tli", "tlingitčina" },
            { "tmh", "tuaregčina" },
            { "tog", "ňasa tonga" },
            { "tok", "toki pona" },
            { "tpi", "novoguinejský pidžin" },
            { "trv", "taroko" },
            { "tsi", "cimšjančina" },
            { "ttm", "northern tutchone" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalčina" },
            { "twq", "tasawaq" },
            { "tyv", "tuviančina" },
            { "tzm", "tamazight (stredomarocký)" },
            { "udm", "udmurtčina" },
            { "uga", "ugaritčina" },
            { "umb", "umbundu" },
            { "und", "neznámy jazyk" },
            { "vec", "benátčina" },
            { "vmw", "makhuwčina" },
            { "vot", "vodčina" },
            { "vun", "vunjo" },
            { "wae", "walserčina" },
            { "wal", "walamčina" },
            { "war", "waray" },
            { "was", "washo" },
            { "wbp", "warlpiri" },
            { "wuu", "čínština (wu)" },
            { "xal", "kalmyčtina" },
            { "xnr", "kángrí" },
            { "xog", "soga" },
            { "yao", "jao" },
            { "yap", "japčina" },
            { "yav", "jangben" },
            { "ybb", "yemba" },
            { "yrl", "nheengatu" },
            { "yue", "kantončina" },
            { "zap", "zapotéčtina" },
            { "zbl", "systém Bliss" },
            { "zen", "zenaga" },
            { "zgh", "tuaregčina (marocká štandardná)" },
            { "zun", "zuniština" },
            { "zxx", "bez jazykového obsahu" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Arab", "arabské" },
            { "Aran", "nastaliq" },
            { "Armn", "arménske" },
            { "Bali", "balijský" },
            { "Beng", "bengálske" },
            { "Bopo", "bopomofo" },
            { "Brai", "braillovo" },
            { "Cakm", metaValue_ccp },
            { "Cans", "zjednotené kanadské domorodé slabiky" },
            { "Cher", "čerokézčina" },
            { "Cyrl", "cyrilika" },
            { "Deva", "dévanágarí" },
            { "Egyp", "egyptské hieroglyfy" },
            { "Ethi", "etiópske" },
            { "Geor", "gruzínske" },
            { "Glag", "hlaholika" },
            { "Goth", "gotický" },
            { "Grek", "grécke" },
            { "Gujr", "gudžarátí" },
            { "Guru", "gurmukhi" },
            { "Hanb", "čínske a bopomofo" },
            { "Hang", "hangul" },
            { "Hani", "čínske" },
            { "Hans", "zjednodušené" },
            { "Hant", "tradičné" },
            { "Hebr", "hebrejské" },
            { "Hira", "hiragana" },
            { "Hrkt", "kana" },
            { "Jamo", "jamo" },
            { "Jpan", "japonské" },
            { "Kana", "katakana" },
            { "Khmr", "khmérske" },
            { "Knda", "kannadské" },
            { "Kore", "kórejské" },
            { "Laoo", "laoské" },
            { "Latn", "latinka" },
            { "Lina", "lineárna A" },
            { "Linb", "lineárna B" },
            { "Maya", "mayské hieroglyfy" },
            { "Mlym", "malajálamske" },
            { "Mong", "mongolské" },
            { "Mtei", "mejtej majek (manipurské)" },
            { "Mymr", "barmské" },
            { "Nkoo", metaValue_bm },
            { "Olck", "santálske (ol chiki)" },
            { "Orya", "uríjske" },
            { "Osma", "osmanský" },
            { "Qaag", "zawgyi" },
            { "Rohg", "hanifi" },
            { "Runr", "Runové písmo" },
            { "Sinh", "sinhálske" },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Taml", "tamilské" },
            { "Telu", "telugské" },
            { "Tfng", "tifinagh" },
            { "Thaa", "tána" },
            { "Thai", "thajské" },
            { "Tibt", "tibetské" },
            { "Vaii", "vai" },
            { "Yiii", "yi" },
            { "Zmth", "matematický zápis" },
            { "Zsye", "emodži" },
            { "Zsym", "symboly" },
            { "Zxxx", "bez zápisu" },
            { "Zyyy", "všeobecné" },
            { "Zzzz", "neznáme písmo" },
            { "de_AT", "nemčina (rakúska)" },
            { "de_CH", "nemčina (švajčiarska spisovná)" },
            { "en_AU", "angličtina (austrálska)" },
            { "en_CA", "angličtina (kanadská)" },
            { "en_GB", "angličtina (britská)" },
            { "en_US", "angličtina (americká)" },
            { "es_ES", "španielčina (európska)" },
            { "es_MX", "španielčina (mexická)" },
            { "fa_AF", "daríjčina" },
            { "fr_CA", "francúzština (kanadská)" },
            { "fr_CH", "francúzština (švajčiarska)" },
            { "nl_BE", "flámčina" },
            { "pt_BR", "portugalčina (brazílska)" },
            { "pt_PT", "portugalčina (európska)" },
            { "ro_MD", "moldavčina" },
            { "sw_CD", "svahilčina (konžská)" },
            { "ar_001", "arabčina (moderná štandardná)" },
            { "es_419", "španielčina (latinskoamerická)" },
            { "key.ca", "kalendár" },
            { "key.cf", "formát meny" },
            { "key.co", "zoradenie" },
            { "key.cu", "mena" },
            { "key.em", "prezentácia emodži" },
            { "key.hc", "hodinový cyklus (12 vs 24)" },
            { "key.lb", "štýl koncov riadka" },
            { "key.lw", "zlom riadka v slovách" },
            { "key.ms", "merná sústava" },
            { "key.nu", "čísla" },
            { "key.ss", "veta po skrat." },
            { "key.tz", "časové pásmo" },
            { "key.va", "variant miestneho nastavenia" },
            { "nds_NL", "dolná saština" },
            { "zh_Hans", "čínština (zjednodušená)" },
            { "zh_Hant", "čínština (tradičná)" },
            { "%%SCOTLAND", "škótska štandardná angličtina" },
            { "type.ca.roc", "čínsky republikánsky kalendár" },
            { "type.co.eor", "európske zoradenie" },
            { "type.hc.h11", "12-hodinový cyklus (0 – 11)" },
            { "type.hc.h12", "12-hodinový cyklus (1 – 12)" },
            { "type.hc.h23", "24-hodinový cyklus (0 – 23)" },
            { "type.hc.h24", "24-hodinový cyklus (1 – 24)" },
            { "type.m0.bgn", "americká transliterácia BGN" },
            { "type.nu.arab", "arabsko-indické číslice" },
            { "type.nu.armn", "arménske číslice" },
            { "type.nu.beng", "bengálske číslice" },
            { "type.nu.cakm", "číslice chakma" },
            { "type.nu.deva", "číslice dévanágarí" },
            { "type.nu.ethi", "etiópske číslice" },
            { "type.nu.geor", "gruzínske číslice" },
            { "type.nu.grek", "grécke číslice" },
            { "type.nu.gujr", "gudžarátske číslice" },
            { "type.nu.guru", "číslice gurumukhí" },
            { "type.nu.hans", "číslice zjednodušenej čínštiny" },
            { "type.nu.hant", "číslice tradičnej čínštiny" },
            { "type.nu.hebr", "hebrejské číslice" },
            { "type.nu.java", "jávske číslice" },
            { "type.nu.jpan", "japonské číslice" },
            { "type.nu.khmr", "khmérske číslice" },
            { "type.nu.knda", "kannadské číslice" },
            { "type.nu.laoo", "laoské číslice" },
            { "type.nu.latn", "arabské číslice" },
            { "type.nu.mlym", "malajálamske číslice" },
            { "type.nu.mong", "Mongolské číslice" },
            { "type.nu.mtei", "číslice meetei mayek" },
            { "type.nu.mymr", "barmské číslice" },
            { "type.nu.olck", "číslice ol chiki" },
            { "type.nu.orya", "uríjske číslice" },
            { "type.nu.taml", "číslice tradičnej tamilčiny" },
            { "type.nu.telu", "telugské číslice" },
            { "type.nu.thai", "thajské číslice" },
            { "type.nu.tibt", "tibetské číslice" },
            { "type.nu.vaii", "vaiské číslice" },
            { "type.ca.dangi", "kórejský kalendár" },
            { "type.co.ducet", "predvolené zoradenie unicode" },
            { "type.lb.loose", "voľný štýl koncov riadka" },
            { "type.nu.roman", "rímske číslice" },
            { "type.ca.coptic", "koptský kalendár" },
            { "type.ca.hebrew", "židovský kalendár" },
            { "type.ca.indian", "Indický národný kalendár" },
            { "type.co.compat", "predchádzajúce zoradenie, kompatibilita" },
            { "type.co.pinyin", "zoradenie pchin-jin" },
            { "type.co.search", "všeobecné vyhľadávanie" },
            { "type.co.stroke", "zoradenie podľa ťahov" },
            { "type.co.unihan", "zoradenie podľa znakov radikál" },
            { "type.co.zhuyin", "zoradenie zhuyin" },
            { "type.d0.fwidth", "celá šírka" },
            { "type.d0.hwidth", "polovičná šírka" },
            { "type.lb.normal", "bežný štýl koncov riadka" },
            { "type.lb.strict", "presný štýl koncov riadka" },
            { "type.m0.ungegn", "medzinárodná transliterácia GEGN" },
            { "type.ms.metric", "metrická sústava" },
            { "type.nu.native", "natívne číslice" },
            { "type.ca.chinese", "čínsky kalendár" },
            { "type.ca.islamic", "kalendár podľa hidžry" },
            { "type.ca.iso8601", "kalendár ISO 8601" },
            { "type.ca.persian", "perzský kalendár" },
            { "type.cf.account", "účtovný formát meny" },
            { "type.d0.npinyin", "Číslice" },
            { "type.nu.arabext", "rozšírené arabsko-indické číslice" },
            { "type.nu.armnlow", "malé arménske číslice" },
            { "type.nu.finance", "Finančnícky zápis čísiel" },
            { "type.nu.greklow", "malé grécke číslice" },
            { "type.nu.hanidec", "čínske desiatkové číslice" },
            { "type.nu.hansfin", "finančné číslice zjednodušenej čínštiny" },
            { "type.nu.hantfin", "finančné číslice tradičnej čínštiny" },
            { "type.nu.jpanfin", "japonské finančné číslice" },
            { "type.nu.tamldec", "tamilské číslice" },
            { "type.ca.buddhist", "budhistický kalendár" },
            { "type.ca.ethiopic", "etiópsky kalendár" },
            { "type.ca.japanese", "japonský kalendár" },
            { "type.cf.standard", "štandardný formát meny" },
            { "type.co.phonetic", "fonetické zoradenie" },
            { "type.co.searchjl", "Hľadať podľa počiatočnej spoluhlásky písma Hangul" },
            { "type.co.standard", "štandardné zoradenie" },
            { "type.ms.uksystem", "britská merná sústava" },
            { "type.ms.ussystem", "americká merná sústava" },
            { "type.nu.fullwide", "číslice s celou šírkou" },
            { "type.nu.romanlow", "malé rímske číslice" },
            { "type.ca.gregorian", "gregoriánsky kalendár" },
            { "type.co.phonebook", "lexikografické zoradenie" },
            { "type.co.dictionary", "slovníkové zoradenie" },
            { "type.co.traditional", "tradičné poradie zoradenia" },
            { "type.nu.traditional", "Tradičné číslovky" },
            { "type.ca.islamic-civil", "kalendár podľa hidžry (občiansky)" },
            { "type.ca.islamic-umalqura", "kalendár podľa hidžry (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "etiópsky kalendár Amete Alem" },
        };
        return data;
    }
}
