/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ta extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "அரபிக்";
        final String metaValue_ae = "அவெஸ்தான்";
        final String metaValue_bn = "வங்காளம்";
        final String metaValue_bug = "புகினீஸ்";
        final String metaValue_ccp = "சக்மா";
        final String metaValue_cop = "காப்டிக்";
        final String metaValue_ka = "ஜார்ஜியன்";
        final String metaValue_got = "கோதிக்";
        final String metaValue_el = "கிரேக்கம்";
        final String metaValue_gu = "குஜராத்தி";
        final String metaValue_jv = "ஜாவனீஸ்";
        final String metaValue_kn = "கன்னடம்";
        final String metaValue_ko = "கொரியன்";
        final String metaValue_lo = "லாவோ";
        final String metaValue_la = "லத்தின்";
        final String metaValue_ml = "மலையாளம்";
        final String metaValue_mn = "மங்கோலியன்";
        final String metaValue_nqo = "என்‘கோ";
        final String metaValue_or = "ஒடியா";
        final String metaValue_si = "சிங்களம்";
        final String metaValue_syr = "சிரியாக்";
        final String metaValue_ta = "தமிழ்";
        final String metaValue_te = "தெலுங்கு";
        final String metaValue_th = "தாய்";
        final String metaValue_bo = "திபெத்தியன்";
        final String metaValue_vai = "வை";
        final String metaValue_peo = "பழைய பெர்ஷியன்";
        final Object[][] data = new Object[][] {
            { "001", "உலகம்" },
            { "002", "ஆப்பிரிக்கா" },
            { "003", "வட அமெரிக்கா" },
            { "005", "தென் அமெரிக்கா" },
            { "009", "ஓஷியானியா" },
            { "011", "மேற்கு ஆப்பிரிக்கா" },
            { "013", "மத்திய அமெரிக்கா" },
            { "014", "கிழக்கு ஆப்பிரிக்கா" },
            { "015", "வடக்கு ஆப்பிரிக்கா" },
            { "017", "மத்திய ஆப்பிரிக்கா" },
            { "018", "தெற்கு ஆப்பிரிக்கா" },
            { "019", "அமெரிக்காஸ்" },
            { "021", "வடக்கு அமெரிக்கா" },
            { "029", "கரீபியன்" },
            { "030", "கிழக்கு ஆசியா" },
            { "034", "தெற்கு ஆசியா" },
            { "035", "தென்கிழக்கு ஆசியா" },
            { "039", "தெற்கு ஐரோப்பா" },
            { "053", "ஆஸ்திரலேசியா" },
            { "054", "மெலனேஷியா" },
            { "057", "மைக்ரோனேஷியன் பிரதேசம்" },
            { "061", "பாலினேஷியா" },
            { "142", "ஆசியா" },
            { "143", "மத்திய ஆசியா" },
            { "145", "மேற்கு ஆசியா" },
            { "150", "ஐரோப்பா" },
            { "151", "கிழக்கு ஐரோப்பா" },
            { "154", "வடக்கு ஐரோப்பா" },
            { "155", "மேற்கு ஐரோப்பா" },
            { "202", "துணை சஹாரா ஆப்பிரிக்கா" },
            { "419", "லத்தீன் அமெரிக்கா" },
            { "AC", "அஷன்ஷியன் தீவு" },
            { "AD", "அன்டோரா" },
            { "AE", "ஐக்கிய அரபு அமீரகம்" },
            { "AF", "ஆஃப்கானிஸ்தான்" },
            { "AG", "ஆண்டிகுவா மற்றும் பார்புடா" },
            { "AI", "அங்கியுலா" },
            { "AL", "அல்பேனியா" },
            { "AM", "அர்மேனியா" },
            { "AO", "அங்கோலா" },
            { "AQ", "அண்டார்டிகா" },
            { "AR", "அர்ஜென்டினா" },
            { "AS", "அமெரிக்க சமோவா" },
            { "AT", "ஆஸ்திரியா" },
            { "AU", "ஆஸ்திரேலியா" },
            { "AW", "அரூபா" },
            { "AX", "ஆலந்து தீவுகள்" },
            { "AZ", "அசர்பைஜான்" },
            { "BA", "போஸ்னியா & ஹெர்ஸகோவினா" },
            { "BB", "பார்படாஸ்" },
            { "BD", "பங்களாதேஷ்" },
            { "BE", "பெல்ஜியம்" },
            { "BF", "புர்கினா ஃபாஸோ" },
            { "BG", "பல்கேரியா" },
            { "BH", "பஹ்ரைன்" },
            { "BI", "புருண்டி" },
            { "BJ", "பெனின்" },
            { "BL", "செயின்ட் பார்தேலெமி" },
            { "BM", "பெர்முடா" },
            { "BN", "புருனே" },
            { "BO", "பொலிவியா" },
            { "BQ", "கரீபியன் நெதர்லாந்து" },
            { "BR", "பிரேசில்" },
            { "BS", "பஹாமாஸ்" },
            { "BT", "பூடான்" },
            { "BV", "பொவேட் தீவு" },
            { "BW", "போட்ஸ்வானா" },
            { "BY", "பெலாரஸ்" },
            { "BZ", "பெலிஸ்" },
            { "CA", "கனடா" },
            { "CC", "கோகோஸ் (கீலிங்) தீவுகள்" },
            { "CD", "காங்கோ - கின்ஷாசா" },
            { "CF", "மத்திய ஆப்ரிக்கக் குடியரசு" },
            { "CG", "காங்கோ - ப்ராஸாவில்லே" },
            { "CH", "ஸ்விட்சர்லாந்து" },
            { "CI", "கோட் தி’வாயர்" },
            { "CK", "குக் தீவுகள்" },
            { "CL", "சிலி" },
            { "CM", "கேமரூன்" },
            { "CN", "சீனா" },
            { "CO", "கொலம்பியா" },
            { "CP", "கிலிப்பர்டன் தீவு" },
            { "CQ", "சார்க்" },
            { "CR", "கோஸ்டாரிகா" },
            { "CU", "கியூபா" },
            { "CV", "கேப் வெர்டே" },
            { "CW", "குராகவ்" },
            { "CX", "கிறிஸ்துமஸ் தீவு" },
            { "CY", "சைப்ரஸ்" },
            { "CZ", "செசியா" },
            { "DE", "ஜெர்மனி" },
            { "DG", "டியகோ கார்ஷியா" },
            { "DJ", "ஜிபௌட்டி" },
            { "DK", "டென்மார்க்" },
            { "DM", "டொமினிகா" },
            { "DO", "டொமினிகன் குடியரசு" },
            { "DZ", "அல்ஜீரியா" },
            { "EA", "சியூடா & மெலில்லா" },
            { "EC", "ஈக்வடார்" },
            { "EE", "எஸ்டோனியா" },
            { "EG", "எகிப்து" },
            { "EH", "மேற்கு சஹாரா" },
            { "ER", "எரிட்ரியா" },
            { "ES", "ஸ்பெயின்" },
            { "ET", "எத்தியோப்பியா" },
            { "EU", "ஐரோப்பிய யூனியன்" },
            { "EZ", "யூரோஜோன்" },
            { "FI", "பின்லாந்து" },
            { "FJ", "ஃபிஜி" },
            { "FK", "ஃபாக்லாந்து தீவுகள்" },
            { "FM", "மைக்ரோனேஷியா" },
            { "FO", "ஃபாரோ தீவுகள்" },
            { "FR", "பிரான்ஸ்" },
            { "GA", "கேபான்" },
            { "GB", "யுனைடெட் கிங்டம்" },
            { "GD", "கிரனெடா" },
            { "GE", "ஜார்ஜியா" },
            { "GF", "பிரெஞ்சு கயானா" },
            { "GG", "கெர்ன்சி" },
            { "GH", "கானா" },
            { "GI", "ஜிப்ரால்டர்" },
            { "GL", "கிரீன்லாந்து" },
            { "GM", "காம்பியா" },
            { "GN", "கினியா" },
            { "GP", "க்வாதேலோப்" },
            { "GQ", "ஈக்வடோரியல் கினியா" },
            { "GR", "கிரீஸ்" },
            { "GS", "தெற்கு ஜார்ஜியா மற்றும் தெற்கு சாண்ட்விச் தீவுகள்" },
            { "GT", "கவுதமாலா" },
            { "GU", "குவாம்" },
            { "GW", "கினியா-பிஸ்ஸாவ்" },
            { "GY", "கயானா" },
            { "HK", "ஹாங்காங் எஸ்ஏஆர் சீனா" },
            { "HM", "ஹேர்ட் மற்றும் மெக்டொனால்டு தீவுகள்" },
            { "HN", "ஹோண்டூராஸ்" },
            { "HR", "குரோஷியா" },
            { "HT", "ஹைட்டி" },
            { "HU", "ஹங்கேரி" },
            { "IC", "கேனரி தீவுகள்" },
            { "ID", "இந்தோனேசியா" },
            { "IE", "அயர்லாந்து" },
            { "IL", "இஸ்ரேல்" },
            { "IM", "ஐல் ஆஃப் மேன்" },
            { "IN", "இந்தியா" },
            { "IO", "பிரிட்டிஷ் இந்தியப் பெருங்கடல் பிரதேசம்" },
            { "IQ", "ஈராக்" },
            { "IR", "ஈரான்" },
            { "IS", "ஐஸ்லாந்து" },
            { "IT", "இத்தாலி" },
            { "JE", "ஜெர்சி" },
            { "JM", "ஜமைக்கா" },
            { "JO", "ஜோர்டான்" },
            { "JP", "ஜப்பான்" },
            { "KE", "கென்யா" },
            { "KG", "கிர்கிஸ்தான்" },
            { "KH", "கம்போடியா" },
            { "KI", "கிரிபாட்டி" },
            { "KM", "கோமரோஸ்" },
            { "KN", "செயின்ட் கிட்ஸ் & நெவிஸ்" },
            { "KP", "வட கொரியா" },
            { "KR", "தென் கொரியா" },
            { "KW", "குவைத்" },
            { "KY", "கெய்மென் தீவுகள்" },
            { "KZ", "கஸகஸ்தான்" },
            { "LA", "லாவோஸ்" },
            { "LB", "லெபனான்" },
            { "LC", "செயின்ட் லூசியா" },
            { "LI", "லிச்செண்ஸ்டெய்ன்" },
            { "LK", "இலங்கை" },
            { "LR", "லைபீரியா" },
            { "LS", "லெசோதோ" },
            { "LT", "லிதுவேனியா" },
            { "LU", "லக்ஸ்சம்பர்க்" },
            { "LV", "லாட்வியா" },
            { "LY", "லிபியா" },
            { "MA", "மொராக்கோ" },
            { "MC", "மொனாக்கோ" },
            { "MD", "மால்டோவா" },
            { "ME", "மான்டேனெக்ரோ" },
            { "MF", "செயின்ட் மார்ட்டீன்" },
            { "MG", "மடகாஸ்கர்" },
            { "MH", "மார்ஷல் தீவுகள்" },
            { "MK", "வடக்கு மாசிடோனியா" },
            { "ML", "மாலி" },
            { "MM", "மியான்மர் (பர்மா)" },
            { "MN", "மங்கோலியா" },
            { "MO", "மகாவ் எஸ்ஏஆர் சீனா" },
            { "MP", "வடக்கு மரியானா தீவுகள்" },
            { "MQ", "மார்டினிக்" },
            { "MR", "மௌரிடானியா" },
            { "MS", "மாண்ட்செராட்" },
            { "MT", "மால்டா" },
            { "MU", "மொரிசியஸ்" },
            { "MV", "மாலத்தீவு" },
            { "MW", "மலாவி" },
            { "MX", "மெக்சிகோ" },
            { "MY", "மலேசியா" },
            { "MZ", "மொசாம்பிக்" },
            { "NA", "நமீபியா" },
            { "NC", "நியூ கேலிடோனியா" },
            { "NE", "நைஜர்" },
            { "NF", "நார்ஃபோக் தீவு" },
            { "NG", "நைஜீரியா" },
            { "NI", "நிகரகுவா" },
            { "NL", "நெதர்லாந்து" },
            { "NO", "நார்வே" },
            { "NP", "நேபாளம்" },
            { "NR", "நௌரு" },
            { "NU", "நியுவே" },
            { "NZ", "நியூசிலாந்து" },
            { "OM", "ஓமன்" },
            { "PA", "பனாமா" },
            { "PE", "பெரு" },
            { "PF", "பிரெஞ்சு பாலினேஷியா" },
            { "PG", "பப்புவா நியூ கினியா" },
            { "PH", "பிலிப்பைன்ஸ்" },
            { "PK", "பாகிஸ்தான்" },
            { "PL", "போலந்து" },
            { "PM", "செயின்ட் பியர் & மிக்வேலான்" },
            { "PN", "பிட்கெய்ர்ன் தீவுகள்" },
            { "PR", "பியூர்டோ ரிகோ" },
            { "PS", "பாலஸ்தீனிய பிரதேசங்கள்" },
            { "PT", "போர்ச்சுக்கல்" },
            { "PW", "பாலோ" },
            { "PY", "பராகுவே" },
            { "QA", "கத்தார்" },
            { "QO", "வெளிப்புற ஓஷியானியா" },
            { "RE", "ரீயூனியன்" },
            { "RO", "ருமேனியா" },
            { "RS", "செர்பியா" },
            { "RU", "ரஷ்யா" },
            { "RW", "ருவாண்டா" },
            { "SA", "சவுதி அரேபியா" },
            { "SB", "சாலமன் தீவுகள்" },
            { "SC", "சீஷெல்ஸ்" },
            { "SD", "சூடான்" },
            { "SE", "ஸ்வீடன்" },
            { "SG", "சிங்கப்பூர்" },
            { "SH", "செயின்ட் ஹெலெனா" },
            { "SI", "ஸ்லோவேனியா" },
            { "SJ", "ஸ்வல்பார்டு & ஜான் மேயன்" },
            { "SK", "ஸ்லோவாகியா" },
            { "SL", "சியாரா லியோன்" },
            { "SM", "சான் மரினோ" },
            { "SN", "செனெகல்" },
            { "SO", "சோமாலியா" },
            { "SR", "சுரினாம்" },
            { "SS", "தெற்கு சூடான்" },
            { "ST", "சாவ் தோம் & ப்ரின்சிபி" },
            { "SV", "எல் சால்வடார்" },
            { "SX", "சின்ட் மார்டென்" },
            { "SY", "சிரியா" },
            { "SZ", "எஸ்வாட்டீனி" },
            { "TA", "டிரிஸ்டன் டா குன்ஹா" },
            { "TC", "டர்க்ஸ் & கைகோஸ் தீவுகள்" },
            { "TD", "சாட்" },
            { "TF", "பிரெஞ்சு தெற்கு பிரதேசங்கள்" },
            { "TG", "டோகோ" },
            { "TH", "தாய்லாந்து" },
            { "TJ", "தஜிகிஸ்தான்" },
            { "TK", "டோகேலோ" },
            { "TL", "திமோர்-லெஸ்தே" },
            { "TM", "துர்க்மெனிஸ்தான்" },
            { "TN", "டுனிசியா" },
            { "TO", "டோங்கா" },
            { "TR", "துருக்கியே" },
            { "TT", "டிரினிடாட் & டொபாகோ" },
            { "TV", "துவாலு" },
            { "TW", "தைவான்" },
            { "TZ", "தான்சானியா" },
            { "UA", "உக்ரைன்" },
            { "UG", "உகாண்டா" },
            { "UM", "யூ.எஸ். வெளிப்புறத் தீவுகள்" },
            { "UN", "ஐக்கிய நாடுகள்" },
            { "US", "அமெரிக்கா" },
            { "UY", "உருகுவே" },
            { "UZ", "உஸ்பெகிஸ்தான்" },
            { "VA", "வாடிகன் நகரம்" },
            { "VC", "செயின்ட் வின்சென்ட் & கிரெனடைன்ஸ்" },
            { "VE", "வெனிசுலா" },
            { "VG", "பிரிட்டீஷ் கன்னித் தீவுகள்" },
            { "VI", "யூ.எஸ். கன்னித் தீவுகள்" },
            { "VN", "வியட்நாம்" },
            { "VU", "வனுவாட்டு" },
            { "WF", "வாலிஸ் மற்றும் ஃபுடுனா" },
            { "WS", "சமோவா" },
            { "XA", "போலி உச்சரிப்புகள்" },
            { "XB", "போலி பீடி" },
            { "XK", "கொசோவோ" },
            { "YE", "ஏமன்" },
            { "YT", "மயோட்" },
            { "ZA", "தென் ஆப்பிரிக்கா" },
            { "ZM", "ஜாம்பியா" },
            { "ZW", "ஜிம்பாப்வே" },
            { "ZZ", "அறியப்படாத பிரதேசம்" },
            { "aa", "அஃபார்" },
            { "ab", "அப்காஜியான்" },
            { "ae", metaValue_ae },
            { "af", "ஆஃப்ரிகான்ஸ்" },
            { "ak", "அகான்" },
            { "am", "அம்ஹாரிக்" },
            { "an", "ஆர்கோனீஸ்" },
            { "ar", metaValue_ar },
            { "as", "அஸ்ஸாமீஸ்" },
            { "av", "அவேரிக்" },
            { "ay", "அய்மரா" },
            { "az", "அசர்பைஜானி" },
            { "ba", "பஷ்கிர்" },
            { "be", "பெலாருஷியன்" },
            { "bg", "பல்கேரியன்" },
            { "bi", "பிஸ்லாமா" },
            { "bm", "பம்பாரா" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "பிரெட்டன்" },
            { "bs", "போஸ்னியன்" },
            { "ca", "கேட்டலான்" },
            { "ce", "செச்சென்" },
            { "ch", "சாமோரோ" },
            { "co", "கார்சிகன்" },
            { "cr", "க்ரீ" },
            { "cs", "செக்" },
            { "cu", "சர்ச் ஸ்லாவிக்" },
            { "cv", "சுவாஷ்" },
            { "cy", "வேல்ஷ்" },
            { "da", "டேனிஷ்" },
            { "de", "ஜெர்மன்" },
            { "dv", "திவேஹி" },
            { "dz", "பூடானி" },
            { "ee", "ஈவ்" },
            { "el", metaValue_el },
            { "en", "ஆங்கிலம்" },
            { "eo", "எஸ்பரேன்டோ" },
            { "es", "ஸ்பானிஷ்" },
            { "et", "எஸ்டோனியன்" },
            { "eu", "பாஸ்க்" },
            { "fa", "பெர்ஷியன்" },
            { "ff", "ஃபுலா" },
            { "fi", "ஃபின்னிஷ்" },
            { "fj", "ஃபிஜியன்" },
            { "fo", "ஃபரோயிஸ்" },
            { "fr", "பிரெஞ்சு" },
            { "fy", "மேற்கு ஃப்ரிஷியன்" },
            { "ga", "ஐரிஷ்" },
            { "gd", "ஸ்காட்ஸ் கேலிக்" },
            { "gl", "காலிஸியன்" },
            { "gn", "க்வாரனி" },
            { "gu", metaValue_gu },
            { "gv", "மேங்க்ஸ்" },
            { "ha", "ஹௌஸா" },
            { "he", "ஹீப்ரூ" },
            { "hi", "இந்தி" },
            { "ho", "ஹிரி மோட்டு" },
            { "hr", "குரோஷியன்" },
            { "ht", "ஹைத்தியன் க்ரியோலி" },
            { "hu", "ஹங்கேரியன்" },
            { "hy", "ஆர்மேனியன்" },
            { "hz", "ஹெரேரோ" },
            { "ia", "இன்டர்லிங்வா" },
            { "id", "இந்தோனேஷியன்" },
            { "ie", "இன்டர்லிங்" },
            { "ig", "இக்போ" },
            { "ii", "சிசுவான் ஈ" },
            { "ik", "இனுபியாக்" },
            { "io", "இடோ" },
            { "is", "ஐஸ்லேண்டிக்" },
            { "it", "இத்தாலியன்" },
            { "iu", "இனுகிடூட்" },
            { "ja", "ஜாப்பனீஸ்" },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "காங்கோ" },
            { "ki", "கிகுயூ" },
            { "kj", "குவான்யாமா" },
            { "kk", "கசாக்" },
            { "kl", "கலாலிசூட்" },
            { "km", "கெமெர்" },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "கனுரி" },
            { "ks", "காஷ்மிரி" },
            { "ku", "குர்மாஞ்சி" },
            { "kv", "கொமி" },
            { "kw", "கார்னிஷ்" },
            { "ky", "கிர்கிஸ்" },
            { "la", metaValue_la },
            { "lb", "லக்ஸம்போர்கிஷ்" },
            { "lg", "கான்டா" },
            { "li", "லிம்பர்கிஷ்" },
            { "ln", "லிங்காலா" },
            { "lo", metaValue_lo },
            { "lt", "லிதுவேனியன்" },
            { "lu", "லுபா-கடாங்கா" },
            { "lv", "லாட்வியன்" },
            { "mg", "மலகாஸி" },
            { "mh", "மார்ஷெலீஸ்" },
            { "mi", "மௌரி" },
            { "mk", "மாஸிடோனியன்" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "மராத்தி" },
            { "ms", "மலாய்" },
            { "mt", "மால்டிஸ்" },
            { "my", "பர்மீஸ்" },
            { "na", "நவ்ரூ" },
            { "nb", "நார்வேஜியன் பொக்மால்" },
            { "nd", "வடக்கு தெபெலே" },
            { "ne", "நேபாளி" },
            { "ng", "தோங்கா" },
            { "nl", "டச்சு" },
            { "nn", "நார்வேஜியன் நியூநார்ஸ்க்" },
            { "no", "நார்வேஜியன்" },
            { "nr", "தெற்கு தெபெலே" },
            { "nv", "நவாஜோ" },
            { "ny", "நயன்ஜா" },
            { "oc", "ஒக்கிடன்" },
            { "oj", "ஒஜிப்வா" },
            { "om", "ஒரோமோ" },
            { "or", metaValue_or },
            { "os", "ஒசெட்டிக்" },
            { "pa", "பஞ்சாபி" },
            { "pi", "பாலி" },
            { "pl", "போலிஷ்" },
            { "ps", "பஷ்தோ" },
            { "pt", "போர்ச்சுகீஸ்" },
            { "qu", "க்வெச்சுவா" },
            { "rm", "ரோமான்ஷ்" },
            { "rn", "ருண்டி" },
            { "ro", "ரோமேனியன்" },
            { "ru", "ரஷியன்" },
            { "rw", "கின்யாருவான்டா" },
            { "sa", "சமஸ்கிருதம்" },
            { "sc", "சார்தீனியன்" },
            { "sd", "சிந்தி" },
            { "se", "வடக்கு சமி" },
            { "sg", "சாங்கோ" },
            { "sh", "செர்போ-குரோஷியன்" },
            { "si", metaValue_si },
            { "sk", "ஸ்லோவாக்" },
            { "sl", "ஸ்லோவேனியன்" },
            { "sm", "சமோவான்" },
            { "sn", "ஷோனா" },
            { "so", "சோமாலி" },
            { "sq", "அல்பேனியன்" },
            { "sr", "செர்பியன்" },
            { "ss", "ஸ்வாடீ" },
            { "st", "தெற்கு ஸோதோ" },
            { "su", "சுண்டானீஸ்" },
            { "sv", "ஸ்வீடிஷ்" },
            { "sw", "ஸ்வாஹிலி" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "தஜிக்" },
            { "th", metaValue_th },
            { "ti", "டிக்ரின்யா" },
            { "tk", "துருக்மென்" },
            { "tl", "டாகாலோக்" },
            { "tn", "ஸ்வானா" },
            { "to", "டோங்கான்" },
            { "tr", "துருக்கிஷ்" },
            { "ts", "ஸோங்கா" },
            { "tt", "டாடர்" },
            { "tw", "ட்வி" },
            { "ty", "தஹிதியன்" },
            { "ug", "உய்குர்" },
            { "uk", "உக்ரைனியன்" },
            { "ur", "உருது" },
            { "uz", "உஸ்பெக்" },
            { "ve", "வென்டா" },
            { "vi", "வியட்நாமீஸ்" },
            { "vo", "ஒலாபூக்" },
            { "wa", "ஒவாலூன்" },
            { "wo", "ஓலோஃப்" },
            { "xh", "ஹோசா" },
            { "yi", "யெட்டிஷ்" },
            { "yo", "யோருபா" },
            { "za", "ஜுவாங்" },
            { "zh", "சீனம்" },
            { "zu", "ஜுலு" },
            { "ace", "ஆச்சினீஸ்" },
            { "ach", "அகோலி" },
            { "ada", "அதாங்மே" },
            { "ady", "அதகே" },
            { "aeb", "துனிசிய அரபு" },
            { "afh", "அஃப்ரிஹிலி" },
            { "agq", "அகெம்" },
            { "ain", "ஐனு" },
            { "akk", "அக்கேதியன்" },
            { "ale", "அலூட்" },
            { "alt", "தெற்கு அல்தை" },
            { "ang", "பழைய ஆங்கிலம்" },
            { "ann", "ஒபோலோ" },
            { "anp", "அங்கிகா" },
            { "arc", "அராமைக்" },
            { "arn", "மபுச்சே" },
            { "arp", "அரபஹோ" },
            { "ars", "நஜ்தி அரபிக்" },
            { "arw", "அராவாக்" },
            { "asa", "அசு" },
            { "ast", "அஸ்துரியன்" },
            { "atj", "அடிகாமேக்வ்" },
            { "awa", "அவதி" },
            { "bal", "பலூச்சி" },
            { "ban", "பலினீஸ்" },
            { "bas", "பாஸா" },
            { "bej", "பேஜா" },
            { "bem", "பெம்பா" },
            { "bez", "பெனா" },
            { "bfq", "படகா" },
            { "bgc", "ஹரியான்வி" },
            { "bgn", "மேற்கு பலோச்சி" },
            { "bho", "போஜ்பூரி" },
            { "bik", "பிகோல்" },
            { "bin", "பினி" },
            { "bla", "சிக்சிகா" },
            { "blo", "அனீ" },
            { "bpy", "பிஷ்ணுப்பிரியா" },
            { "bra", "ப்ராஜ்" },
            { "brx", "போடோ" },
            { "bua", "புரியாத்" },
            { "bug", metaValue_bug },
            { "byn", "ப்லின்" },
            { "cad", "கேடோ" },
            { "car", "கரீப்" },
            { "cay", "கேயுகா" },
            { "cch", "ஆட்சம்" },
            { "ccp", metaValue_ccp },
            { "ceb", "செபுவானோ" },
            { "cgg", "சிகா" },
            { "chb", "சிப்சா" },
            { "chg", "ஷகதை" },
            { "chk", "சூகிசே" },
            { "chm", "மாரி" },
            { "chn", "சினூக் ஜார்கான்" },
            { "cho", "சோக்தௌ" },
            { "chp", "சிபெவ்யான்" },
            { "chr", "செரோகீ" },
            { "chy", "செயேனி" },
            { "ckb", "மத்திய குர்திஷ்" },
            { "clc", "சில்கோடின்" },
            { "cop", metaValue_cop },
            { "crg", "மிச்சிஃப்" },
            { "crh", "கிரிமியன் துர்க்கி" },
            { "crj", "தென்கிழக்கு க்ரீ" },
            { "crk", "சமவெளி க்ரீ" },
            { "crl", "வடகிழக்கு க்ரீ" },
            { "crm", "மூஸ் க்ரீ" },
            { "crr", "கரோலினா அல்கோன்குயன்" },
            { "crs", "செசெல்வா க்ரெயோல் பிரெஞ்சு" },
            { "csb", "கஷுபியன்" },
            { "csw", "சதுப்பு நில க்ரீ" },
            { "dak", "டகோடா" },
            { "dar", "தார்குவா" },
            { "dav", "டைடா" },
            { "del", "டெலாவர்" },
            { "den", "ஸ்லாவ்" },
            { "dgr", "டோக்ரிப்" },
            { "din", "டின்கா" },
            { "dje", "ஸார்மா" },
            { "doi", "டோக்ரி" },
            { "dsb", "லோயர் சோர்பியன்" },
            { "dua", "டுவாலா" },
            { "dum", "மிடில் டச்சு" },
            { "dyo", "ஜோலா-ஃபோன்யி" },
            { "dyu", "ட்யூலா" },
            { "dzg", "டசாகா" },
            { "ebu", "எம்பு" },
            { "efi", "எஃபிக்" },
            { "egy", "பண்டைய எகிப்தியன்" },
            { "eka", "ஈகாஜுக்" },
            { "elx", "எலமைட்" },
            { "enm", "மிடில் ஆங்கிலம்" },
            { "ewo", "எவோன்டோ" },
            { "fan", "ஃபேங்க்" },
            { "fat", "ஃபான்டி" },
            { "fil", "ஃபிலிபினோ" },
            { "fon", "ஃபான்" },
            { "frc", "கஜுன் பிரெஞ்சு" },
            { "frm", "மிடில் பிரெஞ்சு" },
            { "fro", "பழைய பிரெஞ்சு" },
            { "frr", "வடக்கு ஃப்ரிஸியான்" },
            { "frs", "கிழக்கு ஃப்ரிஸியான்" },
            { "fur", "ஃப்ரியூலியன்" },
            { "gaa", "கா" },
            { "gag", "காகௌஸ்" },
            { "gan", "கன் சீனம்" },
            { "gay", "கயோ" },
            { "gba", "பயா" },
            { "gez", "கீஜ்" },
            { "gil", "கில்பெர்டீஸ்" },
            { "gmh", "மிடில் ஹை ஜெர்மன்" },
            { "goh", "பழைய ஹை ஜெர்மன்" },
            { "gon", "கோன்டி" },
            { "gor", "கோரோன்டலோ" },
            { "got", metaValue_got },
            { "grb", "க்ரேபோ" },
            { "grc", "பண்டைய கிரேக்கம்" },
            { "gsw", "ஸ்விஸ் ஜெர்மன்" },
            { "guz", "குஸி" },
            { "gwi", "குவிசின்" },
            { "hai", "ஹைடா" },
            { "hak", "ஹக்கா சீனம்" },
            { "haw", "ஹவாயியன்" },
            { "hax", "தெற்கு ஹைடா" },
            { "hif", "ஃபிஜி இந்தி" },
            { "hil", "ஹிலிகாய்னான்" },
            { "hit", "ஹிட்டைட்" },
            { "hmn", "மாங்க்" },
            { "hsb", "அப்பர் சோர்பியான்" },
            { "hsn", "சியாங்க் சீனம்" },
            { "hup", "ஹுபா" },
            { "hur", "ஹல்கோமெலம்" },
            { "iba", "இபான்" },
            { "ibb", "இபிபியோ" },
            { "ikt", "மேற்கு கனடிய இனுக்டிடுட்" },
            { "ilo", "இலோகோ" },
            { "inh", "இங்குஷ்" },
            { "jbo", "லோஜ்பன்" },
            { "jgo", "நகொம்பா" },
            { "jmc", "மாசெம்" },
            { "jpr", "ஜூதேயோ-பெர்ஷியன்" },
            { "jrb", "ஜூதேயோ-அராபிக்" },
            { "kaa", "காரா-கல்பாக்" },
            { "kab", "கபாய்ல்" },
            { "kac", "காசின்" },
            { "kaj", "ஜ்ஜூ" },
            { "kam", "கம்பா" },
            { "kaw", "காவி" },
            { "kbd", "கபார்டியன்" },
            { "kcg", "தையாப்" },
            { "kde", "மகொண்டே" },
            { "kea", "கபுவெர்தியானு" },
            { "kfo", "கோரோ" },
            { "kgp", "கைன்கேங்" },
            { "kha", "காஸி" },
            { "kho", "கோதானீஸ்" },
            { "khq", "கொய்ரா சீனீ" },
            { "kkj", "ககோ" },
            { "kln", "கலின்ஜின்" },
            { "kmb", "கிம்புன்து" },
            { "koi", "கொமி-பெர்ம்யாக்" },
            { "kok", "கொங்கணி" },
            { "kos", "கோஸ்ரைன்" },
            { "kpe", "க்பெல்லே" },
            { "krc", "கராசே-பல்கார்" },
            { "krl", "கரேலியன்" },
            { "kru", "குருக்" },
            { "ksb", "ஷம்பாலா" },
            { "ksf", "பாஃபியா" },
            { "ksh", "கொலோக்னியன்" },
            { "kum", "கும்யிக்" },
            { "kut", "குடேனை" },
            { "kwk", "குவாக்வாலா" },
            { "kxv", "குவி" },
            { "lad", "லடினோ" },
            { "lag", "லங்கி" },
            { "lah", "லஹன்டா" },
            { "lam", "லம்பா" },
            { "lez", "லெஜ்ஜியன்" },
            { "lij", "லிகூரியன்" },
            { "lil", "லில்லூயிட்" },
            { "lkt", "லகோடா" },
            { "lmo", "லொம்பார்டு" },
            { "lol", "மோங்கோ" },
            { "lou", "லூசியானா க்ரயோல்" },
            { "loz", "லோசி" },
            { "lrc", "வடக்கு லுரி" },
            { "lsm", "சாமியா" },
            { "lua", "லுபா-லுலுலா" },
            { "lui", "லுய்சேனோ" },
            { "lun", "லூன்டா" },
            { "luo", "லுயோ" },
            { "lus", "மிஸோ" },
            { "luy", "லுயியா" },
            { "mad", "மதுரீஸ்" },
            { "mag", "மகாஹி" },
            { "mai", "மைதிலி" },
            { "mak", "மகாசார்" },
            { "man", "மான்டிங்கோ" },
            { "mas", "மாசாய்" },
            { "mdf", "மோக்க்ஷா" },
            { "mdr", "மான்டார்" },
            { "men", "மென்டீ" },
            { "mer", "மெரு" },
            { "mfe", "மொரிசியன்" },
            { "mga", "மிடில் ஐரிஷ்" },
            { "mgh", "மகுவா-மீட்டோ" },
            { "mgo", "மேடா" },
            { "mic", "மிக்மாக்" },
            { "min", "மின்னாங்கபௌ" },
            { "mnc", "மன்சூ" },
            { "mni", "மணிப்புரி" },
            { "moe", "இன்னு-ஐமுன்" },
            { "moh", "மொஹாக்" },
            { "mos", "மோஸ்ஸி" },
            { "mua", "முன்டாங்" },
            { "mul", "பல மொழிகள்" },
            { "mus", "க்ரீக்" },
            { "mwl", "மிரான்டீஸ்" },
            { "mwr", "மார்வாரி" },
            { "myv", "ஏர்ஜியா" },
            { "mzn", "மசந்தேரனி" },
            { "nan", "மின் நான் சீனம்" },
            { "nap", "நியோபோலிடன்" },
            { "naq", "நாமா" },
            { "nds", "லோ ஜெர்மன்" },
            { "new", "நெவாரி" },
            { "nia", "நியாஸ்" },
            { "niu", "நியூவான்" },
            { "nmg", "க்வாசியோ" },
            { "nnh", "நெகெய்ம்பூன்" },
            { "nog", "நோகை" },
            { "non", "பழைய நோர்ஸ்" },
            { "nqo", metaValue_nqo },
            { "nso", "வடக்கு சோதோ" },
            { "nus", "நியூர்" },
            { "nwc", "பாரம்பரிய நேவாரி" },
            { "nym", "நியாம்வேஜி" },
            { "nyn", "நியான்கோலே" },
            { "nyo", "நியோரோ" },
            { "nzi", "நிஜ்மா" },
            { "ojb", "வடமேற்கு ஓஜிப்வா" },
            { "ojc", "மத்திய ஓஜிப்வா" },
            { "ojs", "ஓஜி-க்ரீ" },
            { "ojw", "மேற்கு ஓஜிப்வா" },
            { "oka", "ஒகானகன்" },
            { "osa", "ஓசேஜ்" },
            { "ota", "ஓட்டோமான் துருக்கிஷ்" },
            { "pag", "பன்காசினன்" },
            { "pal", "பாஹ்லவி" },
            { "pam", "பம்பாங்கா" },
            { "pap", "பபியாமென்டோ" },
            { "pau", "பலௌவன்" },
            { "pcm", "நைஜீரியன் பிட்கின்" },
            { "pdc", "பென்சில்வேனிய ஜெர்மன்" },
            { "peo", metaValue_peo },
            { "phn", "ஃபொனிஷியன்" },
            { "pis", "பிஜின்" },
            { "pon", "ஃபோன்பெயென்" },
            { "pqm", "மலிசீட்-பஸ்ஸமகுவாடி" },
            { "prg", "பிரஷ்யன்" },
            { "pro", "பழைய ப்ரோவென்சால்" },
            { "quc", "கீசீ" },
            { "raj", "ராஜஸ்தானி" },
            { "rap", "ரபனுய்" },
            { "rar", "ரரோடோங்கன்" },
            { "rhg", "ரோகிஞ்சா" },
            { "rof", "ரோம்போ" },
            { "rom", "ரோமானி" },
            { "rup", "அரோமானியன்" },
            { "rwk", "ருவா" },
            { "sad", "சான்டாவே" },
            { "sah", "சக்கா" },
            { "sam", "சமாரிடன் அராமைக்" },
            { "saq", "சம்புரு" },
            { "sas", "சாசாக்" },
            { "sat", "சான்டாலி" },
            { "saz", "சௌராஷ்டிரம்" },
            { "sba", "நெகாம்பே" },
            { "sbp", "சங்கு" },
            { "scn", "சிசிலியன்" },
            { "sco", "ஸ்காட்ஸ்" },
            { "sdh", "தெற்கு குர்திஷ்" },
            { "seh", "செனா" },
            { "sel", "செல்குப்" },
            { "ses", "கொய்ராபோரோ சென்னி" },
            { "sga", "பழைய ஐரிஷ்" },
            { "shi", "தசேஹித்" },
            { "shn", "ஷான்" },
            { "sid", "சிடாமோ" },
            { "slh", "தெற்கு லுஷூட்சீட்" },
            { "sma", "தெற்கு சமி" },
            { "smj", "லுலே சமி" },
            { "smn", "இனாரி சமி" },
            { "sms", "ஸ்கோல்ட் சமி" },
            { "snk", "சோனின்கே" },
            { "sog", "சோக்தியன்" },
            { "srn", "ஸ்ரானன் டோங்கோ" },
            { "srr", "செரெர்" },
            { "ssy", "சஹோ" },
            { "str", "ஸ்ட்ரெய்ட்ஸ் சாலிஷ்" },
            { "suk", "சுகுமா" },
            { "sus", "சுசு" },
            { "sux", "சுமேரியன்" },
            { "swb", "கொமோரியன்" },
            { "syc", "பாரம்பரிய சிரியாக்" },
            { "syr", metaValue_syr },
            { "szl", "சிலேசியன்" },
            { "tce", "தெற்கு டட்சோன்" },
            { "tem", "டிம்னே" },
            { "teo", "டெசோ" },
            { "ter", "டெரெனோ" },
            { "tet", "டெடும்" },
            { "tgx", "தகிஷ்" },
            { "tht", "தால்டன்" },
            { "tig", "டைக்ரே" },
            { "tiv", "டிவ்" },
            { "tkl", "டோகேலௌ" },
            { "tlh", "க்ளிங்கோன்" },
            { "tli", "லிங்கிட்" },
            { "tmh", "தமஷேக்" },
            { "tog", "நயாசா டோங்கா" },
            { "tok", "டோக்கி போனா" },
            { "tpi", "டோக் பிஸின்" },
            { "trv", "தரோகோ" },
            { "tsi", "ட்ஸிம்ஷியன்" },
            { "ttm", "வடக்கு டட்சோன்" },
            { "tum", "தும்புகா" },
            { "tvl", "டுவாலு" },
            { "twq", "டசவாக்" },
            { "tyv", "டுவினியன்" },
            { "tzm", "மத்திய அட்லஸ் டமசைட்" },
            { "udm", "உட்முர்ட்" },
            { "uga", "உகாரிடிக்" },
            { "umb", "அம்பொண்டு" },
            { "und", "அறியப்படாத மொழி" },
            { "vai", metaValue_vai },
            { "vec", "வினிசியன்" },
            { "vmw", "மகுவா" },
            { "vot", "வோட்க்" },
            { "vun", "வுன்ஜோ" },
            { "wae", "வால்சேர்" },
            { "wal", "வோலாய்ட்டா" },
            { "war", "வாரே" },
            { "was", "வாஷோ" },
            { "wbp", "வல்பிரி" },
            { "wuu", "வூ சீனம்" },
            { "xal", "கல்மிக்" },
            { "xnr", "காங்கிரி" },
            { "xog", "சோகா" },
            { "yao", "யாவ்" },
            { "yap", "யாபேசே" },
            { "yav", "யாங்பென்" },
            { "ybb", "யெம்பா" },
            { "yrl", "நஹீன்கட்டு" },
            { "yue", "காண்டோனீஸ்" },
            { "zap", "ஜாபோடெக்" },
            { "zbl", "ப்லிஸ்ஸிம்பால்ஸ்" },
            { "zen", "ஜெனகா" },
            { "zgh", "ஸ்டாண்டர்ட் மொராக்கன் தமாசைட்" },
            { "zun", "ஜூனி" },
            { "zxx", "மொழி உள்ளடக்கம் ஏதுமில்லை" },
            { "zza", "ஜாஜா" },
            { "Adlm", "அட்லாம்" },
            { "Arab", metaValue_ar },
            { "Aran", "நஸ்டாலிக்" },
            { "Armi", "இம்பேரியல் அரமெய்க்" },
            { "Armn", "அர்மேனியன்" },
            { "Avst", metaValue_ae },
            { "Bali", "பாலினீஸ்" },
            { "Batk", "பாடாக்" },
            { "Beng", metaValue_bn },
            { "Blis", "ப்லிஸ்ஸிமிபால்ஸ்" },
            { "Bopo", "போபோமோஃபோ" },
            { "Brah", "பிரம்மி" },
            { "Brai", "பிரெயில்" },
            { "Bugi", metaValue_bug },
            { "Buhd", "புகித்" },
            { "Cakm", metaValue_ccp },
            { "Cans", "ஒருங்கிணைக்கப்பட்ட கனடிய பழங்குடி எழுத்துகள்" },
            { "Cari", "கரியன்" },
            { "Cham", "சாம்" },
            { "Cher", "செரோக்கி" },
            { "Cirt", "கிர்த்" },
            { "Copt", metaValue_cop },
            { "Cprt", "சைப்ரியாட்" },
            { "Cyrl", "சிரிலிக்" },
            { "Cyrs", "பழைய சர்ச் ஸ்லவோனிக் சிரிலிக்" },
            { "Deva", "தேவநாகரி" },
            { "Dsrt", "டெசராட்" },
            { "Egyd", "எகிப்தியன் டெமோட்டிக்" },
            { "Egyh", "எகிப்தியன் ஹைரேட்டிக்" },
            { "Egyp", "எகிப்தியன் ஹைரோகிளிப்ஸ்" },
            { "Ethi", "எத்தியோபிக்" },
            { "Geok", "ஜியார்ஜியன் குட்சுரி" },
            { "Geor", metaValue_ka },
            { "Glag", "க்லாகோலிடிக்" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "குர்முகி" },
            { "Hanb", "ஹன்ப்" },
            { "Hang", "ஹங்குல்" },
            { "Hani", "ஹன்" },
            { "Hano", "ஹனுனூ" },
            { "Hans", "எளிதாக்கப்பட்டது" },
            { "Hant", "பாரம்பரியம்" },
            { "Hebr", "ஹீப்ரு" },
            { "Hira", "ஹிராகானா" },
            { "Hmng", "பஹாவ் மாங்க்" },
            { "Hrkt", "ஜப்பானிய எழுத்துருக்கள்" },
            { "Hung", "பழைய ஹங்கேரியன்" },
            { "Inds", "சிந்து" },
            { "Ital", "பழைய இத்தாலி" },
            { "Jamo", "ஜமோ" },
            { "Java", metaValue_jv },
            { "Jpan", "ஜப்பானியம்" },
            { "Kali", "கயாஹ் லீ" },
            { "Kana", "கதகானா" },
            { "Khar", "கரோஷ்டி" },
            { "Khmr", "கமெர்" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "காய்தி" },
            { "Lana", "லன்னா" },
            { "Laoo", metaValue_lo },
            { "Latf", "ஃப்ரக்டூர் லெத்தின்" },
            { "Latg", "கேலிக் லெத்தின்" },
            { "Latn", metaValue_la },
            { "Lepc", "லெப்சா" },
            { "Limb", "லிம்பு" },
            { "Lina", "லினியர் ஏ" },
            { "Linb", "லினியர் பி" },
            { "Lyci", "லிசியன்" },
            { "Lydi", "லிடியன்" },
            { "Mand", "மேன்டியன்" },
            { "Mani", "மனிசெய்ன்" },
            { "Maya", "மயான் ஹைரோகிளிப்" },
            { "Mero", "மெராய்டிக்" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "மூன்" },
            { "Mtei", "மெய்தெய் மயக்" },
            { "Mymr", "மியான்மர்" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ஒகாம்" },
            { "Olck", "ஒல் சிக்கி" },
            { "Orkh", "ஆர்கான்" },
            { "Orya", metaValue_or },
            { "Osma", "ஒஸ்மான்யா" },
            { "Perm", "பழைய பெர்மிக்" },
            { "Phag", "பக்ஸ்-பா" },
            { "Phli", "இன்ஸ்கிரிப்ஷனல் பஹலவி" },
            { "Phlp", "சால்டர் பஹலவி" },
            { "Phlv", "புக் பஹலவி" },
            { "Phnx", "ஃபோனேஷியன்" },
            { "Plrd", "போலார்ட் ஃபொனெட்டிக்" },
            { "Prti", "இன்ஸ்கிரிப்ஷனல் பார்த்தியன்" },
            { "Rjng", "ரெஜெய்ன்" },
            { "Rohg", "ஹனிஃபி" },
            { "Roro", "ரொங்கோரொங்கோ" },
            { "Runr", "ருனிக்" },
            { "Samr", "சமாரிடன்" },
            { "Sara", "சாராதி" },
            { "Saur", "சௌராஷ்ட்ரா" },
            { "Sgnw", "ஸைன்எழுத்து" },
            { "Shaw", "ஷவியான்" },
            { "Sinh", metaValue_si },
            { "Sund", "சுந்தானீஸ்" },
            { "Sylo", "சிலோடி நக்ரி" },
            { "Syrc", metaValue_syr },
            { "Syre", "எஸ்ட்ரெங்கெலோ சிரியாக்" },
            { "Syrj", "மேற்கு சிரியாக்" },
            { "Syrn", "கிழக்கு சிரியாக்" },
            { "Tagb", "தகோவானா" },
            { "Tale", "தாய் லே" },
            { "Talu", "புதிய தை லூ" },
            { "Taml", metaValue_ta },
            { "Tavt", "தை வியத்" },
            { "Telu", metaValue_te },
            { "Teng", "தெங்வார்" },
            { "Tfng", "டிஃபினாக்" },
            { "Tglg", "தகலாக்" },
            { "Thaa", "தானா" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "உகாரதிக்" },
            { "Vaii", metaValue_vai },
            { "Visp", "விசிபிள் ஸ்பீச்" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "சுமெரோ-அக்கடியன் க்யூனிஃபார்ம்" },
            { "Yiii", "யீ" },
            { "Zinh", "பாரம்பரியமான" },
            { "Zmth", "கணிதக்குறியீடு" },
            { "Zsye", "எமோஜி" },
            { "Zsym", "சின்னங்கள்" },
            { "Zxxx", "எழுதப்படாதது" },
            { "Zyyy", "பொது" },
            { "Zzzz", "அறியப்படாத ஸ்கிரிப்ட்" },
            { "de_AT", "ஆஸ்திரிய ஜெர்மன்" },
            { "de_CH", "ஸ்விஸ் ஹை ஜெர்மன்" },
            { "en_AU", "ஆஸ்திரேலிய ஆங்கிலம்" },
            { "en_CA", "கனடிய ஆங்கிலம்" },
            { "en_GB", "பிரிட்டிஷ் ஆங்கிலம்" },
            { "en_US", "அமெரிக்க ஆங்கிலம்" },
            { "es_ES", "ஐரோப்பிய ஸ்பானிஷ்" },
            { "es_MX", "மெக்ஸிகன் ஸ்பானிஷ்" },
            { "fa_AF", "தாரி" },
            { "fr_CA", "கனடிய பிரெஞ்சு" },
            { "fr_CH", "ஸ்விஸ் பிரஞ்சு" },
            { "nl_BE", "ஃப்லெமிஷ்" },
            { "pt_BR", "பிரேசிலிய போர்ச்சுகீஸ்" },
            { "pt_PT", "ஐரோப்பிய போர்ச்சுகீஸ்" },
            { "ro_MD", "மோல்டாவியன்" },
            { "sw_CD", "காங்கோ ஸ்வாஹிலி" },
            { "ar_001", "நவீன நிலையான அரபிக்" },
            { "es_419", "லத்தின் அமெரிக்க ஸ்பானிஷ்" },
            { "key.ca", "நாள்காட்டி" },
            { "key.cf", "நாணய வடிவம்" },
            { "key.co", "வரிசை முறை" },
            { "key.cu", "நாணயம்" },
            { "key.em", "இமோஜி வெளிப்பாடு" },
            { "key.hc", "மணிநேர சுழற்சி (12, 24)" },
            { "key.lb", "வரி முறிப்பு ஸ்டைல்" },
            { "key.lw", "வவ" },
            { "key.ms", "அளவீட்டு முறை" },
            { "key.nu", "எண்கள்" },
            { "key.ss", "வமு" },
            { "key.tz", "நேர மண்டலம்" },
            { "key.va", "மொழி மாறிலி" },
            { "nds_NL", "லோ சாக்ஸன்" },
            { "zh_Hans", "எளிதாக்கப்பட்ட சீனம்" },
            { "zh_Hant", "பாரம்பரிய சீனம்" },
            { "%%PINYIN", "பின்யின் ரோமானைசெஷன்" },
            { "%%WADEGILE", "வேட்-கைல்ஸ் ரோமனைஷேசன்" },
            { "type.ca.roc", "மின்கோ நாள்காட்டி" },
            { "type.co.eor", "ஐரோப்பிய வரிசைப்படுத்தல் விதிகள்" },
            { "type.hc.h11", "12 மணிநேர முறைமை (0–11)" },
            { "type.hc.h12", "12 மணிநேர முறைமை (1–12)" },
            { "type.hc.h23", "24 மணிநேர முறைமை (0–23)" },
            { "type.hc.h24", "24 மணிநேர முறைமை (1–24)" },
            { "type.m0.bgn", "யூஎஸ் பிஜிஎன் ஒலிபெயர்ப்பு" },
            { "type.nu.arab", "அரபிய-இந்திய இலக்கங்கள்" },
            { "type.nu.armn", "ஆர்மேனியன் எண்கள்" },
            { "type.nu.beng", "பெங்காலி இலக்கங்கள்" },
            { "type.nu.cakm", "சக்மா இலக்கங்கள்" },
            { "type.nu.deva", "தேவநாகரி இலக்கங்கள்" },
            { "type.nu.ethi", "எத்தியோப்பிய எண்கள்" },
            { "type.nu.geor", "ஜார்ஜியன் எண்கள்" },
            { "type.nu.grek", "கிரேக்க எண்கள்" },
            { "type.nu.gujr", "குஜராத்தி இலக்கங்கள்" },
            { "type.nu.guru", "குர்முகி இலக்கங்கள்" },
            { "type.nu.hans", "எளிதாக்கப்பட்ட சீன எண்கள்" },
            { "type.nu.hant", "பாரம்பரிய சீன எண்கள்" },
            { "type.nu.hebr", "ஹீப்ரு எண்கள்" },
            { "type.nu.java", "ஜாவானிய இலக்கங்கள்" },
            { "type.nu.jpan", "ஜப்பானிய எண்கள்" },
            { "type.nu.khmr", "கெமெர் இலக்கங்கள்" },
            { "type.nu.knda", "கன்னட இலக்கங்கள்" },
            { "type.nu.laoo", "லாவோ இலக்கங்கள்" },
            { "type.nu.latn", "மேற்கத்திய இலக்கங்கள்" },
            { "type.nu.mlym", "மலையாள இலக்கங்கள்" },
            { "type.nu.mong", "மங்கோலியன் இலக்கங்கள்" },
            { "type.nu.mtei", "மீடீ மயக் இலக்கங்கள்" },
            { "type.nu.mymr", "மியான்மர் இலக்கங்கள்" },
            { "type.nu.olck", "ஒல் சிக்கி இலக்கங்கள்" },
            { "type.nu.orya", "ஒடியா இலக்கங்கள்" },
            { "type.nu.taml", "பாரம்பரிய தமிழ் எண்கள்" },
            { "type.nu.telu", "தெலுங்கு இலக்கங்கள்" },
            { "type.nu.thai", "தாய் இலக்கங்கள்" },
            { "type.nu.tibt", "திபெத்திய இலக்கங்கள்" },
            { "type.nu.vaii", "வை இலக்கங்கள்" },
            { "type.ca.dangi", "டேங்கி நாள்காட்டி" },
            { "type.co.ducet", "இயல்புநிலை யுனிகோட் வரிசை முறை" },
            { "type.lb.loose", "தளர்வான வரி முறிப்பு ஸ்டைல்" },
            { "type.nu.roman", "ரோமன் எண்கள்" },
            { "type.ca.coptic", "காப்டிக் நாள்காட்டி" },
            { "type.ca.hebrew", "ஹீப்ரு நாள்காட்டி" },
            { "type.ca.indian", "இந்திய தேசிய நாள்காட்டி" },
            { "type.co.compat", "முந்தைய வரிசை வடிவம், இணக்கத்தன்மைக்கு" },
            { "type.co.pinyin", "பின்யின் வரிசை முறை" },
            { "type.co.search", "பொதுப்படையான தேடல்" },
            { "type.co.stroke", "ஸ்ட்ரோக் வரிசை முறை" },
            { "type.co.unihan", "ரேடியன் ஸ்ட்ரோக் வரிசை முறை" },
            { "type.d0.fwidth", "முழு அகலம்" },
            { "type.d0.hwidth", "அரை அகலம்" },
            { "type.lb.normal", "சாதாரண வரி முறிப்பு ஸ்டைல்" },
            { "type.lb.strict", "கண்டிப்பான வரி முறிப்பு ஸ்டைல்" },
            { "type.m0.ungegn", "யூஎன் ஜிஇஜிஎன் ஒலிபெயர்ப்பு" },
            { "type.ms.metric", "மெட்ரிக் முறை" },
            { "type.nu.native", "சொந்த இலக்கங்கள்" },
            { "type.ca.chinese", "சீன நாள்காட்டி" },
            { "type.ca.islamic", "இஸ்லாமிய நாள்காட்டி" },
            { "type.ca.iso8601", "கிரிகோரிய நாள்காட்டி" },
            { "type.ca.persian", "பாரசீக நாள்காட்டி" },
            { "type.cf.account", "கணக்கிடல் நாணய வடிவம்" },
            { "type.d0.npinyin", "எண்" },
            { "type.nu.arabext", "நீட்டிக்கப்பட்ட அரபிய-இந்திய இலக்கங்கள்" },
            { "type.nu.armnlow", "ஆர்மேனியன் சிற்றெழுத்து எண்கள்" },
            { "type.nu.finance", "நிதி எண்கள்" },
            { "type.nu.greklow", "கிரேக்கச் சிற்றெழுத்து எண்கள்" },
            { "type.nu.hanidec", "சீன பின்ன எண்கள்" },
            { "type.nu.hansfin", "எளிதாக்கப்பட்ட சீன நிதி எண்கள்" },
            { "type.nu.hantfin", "பாரம்பரிய சீன நிதி எண்கள்" },
            { "type.nu.jpanfin", "ஜப்பானிய நிதி எண்கள்" },
            { "type.nu.tamldec", "தமிழ் இலக்கங்கள்" },
            { "type.ca.buddhist", "புத்த நாள்காட்டி" },
            { "type.ca.ethiopic", "எத்தியோப்பிய நாள்காட்டி" },
            { "type.ca.japanese", "ஜப்பானிய நாள்காட்டி" },
            { "type.cf.standard", "நிலையான நாணய வடிவம்" },
            { "type.co.phonetic", "ஒலியியல் வரிசைப்படுத்தல் முறை" },
            { "type.co.searchjl", "ஹங்குல் முதன்மை மெய்யெழுத்தின்படி தேடு" },
            { "type.co.standard", "நிலையான வரிசை முறை" },
            { "type.ms.uksystem", "இம்பீரியல் அளவீட்டு முறை" },
            { "type.ms.ussystem", "அமெரிக்க அளவீட்டு முறை" },
            { "type.nu.fullwide", "முழு-அகல இலக்கங்கள்" },
            { "type.nu.romanlow", "ரோமன் சிற்றெழுத்து எண்கள்" },
            { "type.ca.gregorian", "கிரிகோரியன் நாள்காட்டி" },
            { "type.co.phonebook", "தொலைபேசி புத்தக வரிசை முறை" },
            { "type.co.dictionary", "அகராதி வரிசை முறை" },
            { "type.co.traditional", "பாரம்பரிய வரிசை முறை" },
            { "type.nu.traditional", "பாரம்பரிய எண்கள்" },
            { "type.ca.islamic-tbla", "இஸ்லாமிய வானியல் நாள்காட்டி" },
            { "type.ca.islamic-civil", "இஸ்லாமிய சிவில் நாள்காட்டி" },
            { "type.ca.islamic-umalqura", "இஸ்லாமிய நாள்காட்டி (உம்-அல்-குரா)" },
            { "type.ca.ethiopic-amete-alem", "எத்தியோபிக் அமேதே ஆலெம் நாள்காட்டி" },
        };
        return data;
    }
}
