/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.activityexplorer.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.common.log.ViewpointDslLogger;

public class IconsFileHelper {
    public static final String ICONS_FOLDER_NAME = "icons";
    private static final NullProgressMonitor NPM = new NullProgressMonitor();

    public static void copyIcon(final String iconName, String sourceProjectName, String targetProjectName) throws InvocationTargetException, InterruptedException {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        final IProject sourceProject = workspaceRoot.getProject(sourceProjectName);
        if (!sourceProject.exists()) {
            throw new RuntimeException("Project " + sourceProjectName + "doesn't exists");
        }
        final IProject targetProject = workspaceRoot.getProject(targetProjectName);
        if (!targetProject.exists()) {
            throw new RuntimeException("Project " + targetProjectName + "doesn't exists");
        }
        WorkspaceModifyOperation wo = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                IFolder iconFolder = sourceProject.getFolder(IconsFileHelper.ICONS_FOLDER_NAME);
                IFile vpIconFile = iconFolder.getFile(iconName);
                if (vpIconFile.exists()) {
                    IFile targetIconFile;
                    IFolder targetFolder = targetProject.getFolder(IconsFileHelper.ICONS_FOLDER_NAME);
                    if (!targetFolder.exists()) {
                        targetFolder.create(true, true, (IProgressMonitor)NPM);
                    }
                    if ((targetIconFile = targetFolder.getFile(iconName)).exists()) {
                        targetIconFile.setContents(vpIconFile.getContents(), 256, (IProgressMonitor)NPM);
                    } else {
                        targetIconFile.create(vpIconFile.getContents(), true, (IProgressMonitor)NPM);
                    }
                } else {
                    ViewpointDslLogger.doLogWarning((String)("Unable to find the icon : " + iconName));
                }
            }
        };
        wo.run(null);
    }
}

