/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.ecore.helpers;

import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.kitalpha.doc.gen.business.ecore.helpers.EcoreModelHelper;

public class EClassContentHelper {
    public static String getAttributesTable(EClass element) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table>");
        buffer.append("<tr>");
        buffer.append("<th></th>");
        buffer.append("<th>Name</th>");
        buffer.append("<th>Type</th>");
        buffer.append("<th>Changeable</th>");
        buffer.append("<th>Required</th>");
        buffer.append("<th>Derived</th>");
        buffer.append("<th>Cardinality</th>");
        buffer.append("<th>Description</th>");
        buffer.append("</tr>");
        for (EAttribute attribute : element.getEAllAttributes()) {
            if (element.getEAttributes().contains((Object)attribute)) {
                EClassContentHelper.appendAttributeRow(buffer, attribute, false);
                continue;
            }
            EClassContentHelper.appendAttributeRow(buffer, attribute, true);
        }
        buffer.append("</table>");
        return buffer.toString();
    }

    private static void appendAttributeRow(StringBuffer buffer, EAttribute attribute, boolean isInherited) {
        EObject container;
        String descriptionValue = EcoreModelHelper.getDescription((EModelElement)attribute);
        String attributeType = "";
        String title = "";
        if (attribute.getEType() != null) {
            attributeType = EcoreModelHelper.getTypeHyperLink((ENamedElement)attribute.getEType());
        }
        buffer.append("<tr");
        if (isInherited && (container = attribute.eContainer()) instanceof ENamedElement) {
            title = "Inherited From " + ((ENamedElement)container).getName();
            buffer.append(" title=\"" + title + "\"");
        }
        buffer.append(">");
        buffer.append("<td>");
        if (isInherited) {
            buffer.append(EcoreModelHelper.getTypeHyperLink((ENamedElement)attribute.eContainer(), "<img src=\"../../img/arrow_up.png\" alt=\"" + title + "\" />"));
        }
        buffer.append("</td>");
        buffer.append("<td>" + attribute.getName() + "</td>");
        buffer.append("<td>" + attributeType + "</td>");
        buffer.append("<td>" + attribute.isChangeable() + "</td>");
        buffer.append("<td>" + attribute.isRequired() + "</td>");
        buffer.append("<td>" + attribute.isDerived() + "</td>");
        buffer.append("<td>" + EClassContentHelper.getCardinality(attribute.getLowerBound()) + ".." + EClassContentHelper.getCardinality(attribute.getUpperBound()) + "</td>");
        buffer.append("<td>" + descriptionValue + "</td>");
        buffer.append("</tr>");
    }

    public static String getReferencesTable(EClass element) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table>");
        buffer.append("<tr>");
        buffer.append("<th></th>");
        buffer.append("<th>Name</th>");
        buffer.append("<th>Type</th>");
        buffer.append("<th>Changeable</th>");
        buffer.append("<th>Required</th>");
        buffer.append("<th>Ordered</th>");
        buffer.append("<th>Derived</th>");
        buffer.append("<th>Unique</th>");
        buffer.append("<th>Cardinality</th>");
        buffer.append("<th>Description</th>");
        buffer.append("</tr>");
        for (EReference reference : element.getEAllReferences()) {
            if (element.getEReferences().contains((Object)reference)) {
                EClassContentHelper.appendReferenceTableRow(buffer, reference, false);
                continue;
            }
            EClassContentHelper.appendReferenceTableRow(buffer, reference, true);
        }
        buffer.append("</table>");
        return buffer.toString();
    }

    private static void appendReferenceTableRow(StringBuffer buffer, EReference reference, boolean isInherited) {
        EObject container;
        String referenceType = "";
        String title = "";
        if (reference.getEType() != null) {
            referenceType = EcoreModelHelper.getTypeHyperLink((ENamedElement)reference.getEType());
        }
        buffer.append("<tr");
        if (isInherited && (container = reference.eContainer()) instanceof ENamedElement) {
            title = "Inherited From " + ((ENamedElement)container).getName();
            buffer.append(" title=\"" + title + "\"");
        }
        buffer.append("><td>");
        if (reference.isContainment()) {
            buffer.append("<img src=\"../../img/ContainmentFeature.gif\" alt=\"" + title + "\" />");
        }
        if (isInherited) {
            buffer.append(EcoreModelHelper.getTypeHyperLink((ENamedElement)reference.eContainer(), "<img src=\"../../img/arrow_up.png\" alt=\"" + title + "\" />"));
        }
        if (reference.isDerived()) {
            buffer.append("<img src=\"../../img/DerivedFeature.gif\" alt=\"" + title + "\" />");
        }
        buffer.append("</td>");
        buffer.append("<td");
        if (isInherited) {
            buffer.append(" title=\"" + title + "\"");
        }
        buffer.append(">" + reference.getName() + "</td>");
        buffer.append("<td>" + referenceType + "</td>");
        buffer.append("<td>" + reference.isChangeable() + "</td>");
        buffer.append("<td>" + reference.isRequired() + "</td>");
        buffer.append("<td>" + reference.isOrdered() + "</td>");
        buffer.append("<td>" + reference.isDerived() + "</td>");
        buffer.append("<td>" + reference.isUnique() + "</td>");
        buffer.append("<td>" + EClassContentHelper.getCardinality(reference.getLowerBound()) + ".." + EClassContentHelper.getCardinality(reference.getUpperBound()) + "</td>");
        buffer.append("<td>" + EcoreModelHelper.getDescription((EModelElement)reference) + "</td>");
        buffer.append("</tr>");
    }

    public static String getOperationsTable(EClass element) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table>");
        buffer.append("<tr>");
        buffer.append("<th></th>");
        buffer.append("<th>Name</th>");
        buffer.append("<th>Return</th>");
        buffer.append("<th>Parameter(s)</th>");
        buffer.append("</tr>");
        for (EOperation eOperation : element.getEAllOperations()) {
            if (element.getEOperations().contains((Object)eOperation)) {
                EClassContentHelper.appendOperationTableRow(buffer, eOperation, false);
                continue;
            }
            EClassContentHelper.appendOperationTableRow(buffer, eOperation, true);
        }
        buffer.append("</table>");
        return buffer.toString();
    }

    private static void appendOperationTableRow(StringBuffer buffer, EOperation eOperation, boolean isInherited) {
        EObject container;
        String eOperationType = "";
        String title = "";
        if (eOperation.getEType() != null) {
            eOperationType = EcoreModelHelper.getTypeHyperLink((ENamedElement)eOperation.getEType());
        }
        buffer.append("<tr");
        if (isInherited && (container = eOperation.eContainer()) instanceof ENamedElement) {
            title = "Inherited From " + ((ENamedElement)container).getName();
            buffer.append(" title=\"" + title + "\"");
        }
        buffer.append(">");
        buffer.append("<td>");
        if (isInherited) {
            buffer.append(EcoreModelHelper.getTypeHyperLink((ENamedElement)eOperation.eContainer(), "<img src=\"../../img/arrow_up.png\" alt=\"" + title + "\" />"));
        }
        buffer.append("</td>");
        buffer.append("<td>" + eOperation.getName() + "</td>");
        buffer.append("<td>0.." + EClassContentHelper.getCardinality(eOperation.getUpperBound()) + " " + eOperationType + "</td>");
        buffer.append("<td>");
        Iterator iterator = eOperation.getEParameters().iterator();
        while (iterator.hasNext()) {
            EParameter parameter = (EParameter)iterator.next();
            buffer.append(parameter.getName());
            if (parameter.getEType() != null) {
                buffer.append(": ");
                buffer.append(EcoreModelHelper.getTypeHyperLink((ENamedElement)parameter.getEType()));
            }
            if (!iterator.hasNext()) continue;
            buffer.append(" | ");
        }
        buffer.append("</td>");
        buffer.append("</tr>");
    }

    private static String getCardinality(int cardinality) {
        if (cardinality == -1) {
            return "*";
        }
        return String.valueOf(cardinality);
    }
}

