# Introduction #

Kitalpha provides an integrated and pure DSL environment for accurate, safe, and fast development of [DSMs](http://en.wikipedia.org/wiki/Domain-specific_modeling DSMs) and viewpoints

# Tutorials #
* Presentation: [Case_Study](https://raw.githubusercontent.com/wiki/eclipse/kitalpha/pdf/Kitalpha-B01-Case_Study.pdf)
* Presentation: [Architecture Framework and Viewpoint DSL](https://raw.githubusercontent.com/wiki/eclipse/kitalpha/pdf/Kitalpha-B02-AF_and_Viewpoint_DSLs.pdf)
* Presentation: [Metamodel Extensibility](https://raw.githubusercontent.com/wiki/eclipse/kitalpha/pdf/Kitalpha-CTK-Metamodel_Extensibility-1.0.1.pdf)
* Presentation: [Target Application](https://raw.githubusercontent.com/wiki/eclipse/kitalpha/pdf/Kitalpha-TargetApplication-1.0.0.pdf)
* Presentation: [VPDSL Architecture](https://raw.githubusercontent.com/wiki/eclipse/kitalpha/pdf/Kitalpha-AD-Metamodels-1.0.0.pdf)
* Document: [Textual DSL for Architecture Description](https://raw.githubusercontent.com/wiki/eclipse/kitalpha/pdf/Textual_DSL_for_Architecture_Description-v1.0.0.pdf)
* Videos: [Viewpoint Creation](https://www.youtube.com/channel/UC97ADFbY7tn1goEvduEsx4A)

# Migration #

For any new version of Kitalpha it is strongly advised to generate the artifacts of a viewpoint. Indeed, if the textual description does not change, the implementation can change or the generation adjusts implementation when used APIs change.

