/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.desc.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;

public class ECoreFileInformation {
    private String _projectName;
    private String _folderName;
    private String _metaModelName;

    public ECoreFileInformation(String projectName, String modelFolder, String eCoreFileName) throws Exception {
        this._projectName = projectName;
        this._folderName = modelFolder;
        this._metaModelName = eCoreFileName;
        if (!this.checkInforamtions()) {
            throw new Exception();
        }
    }

    public boolean EcoreFileExist() {
        IFolder folder;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this._projectName);
        if (project.exists() && (folder = project.getFolder(this._folderName)).exists()) {
            IFile file = folder.getFile(String.valueOf(this._metaModelName) + ".ecore");
            return file.exists();
        }
        return false;
    }

    public URI getEcoreFileURI() {
        String strUri = this.getEcoreFilePathName();
        return this.checkInforamtions() ? URI.createFileURI((String)strUri) : null;
    }

    public URI getEcorePlatformResourceURI() {
        String strUri = this.getEcoreFilePathName();
        return this.checkInforamtions() ? URI.createPlatformResourceURI((String)strUri, (boolean)false) : null;
    }

    private String getCorrectECoreFileName(String fileName) {
        if (fileName.endsWith(".ecore")) {
            return fileName;
        }
        return String.valueOf(fileName) + "." + "ecore";
    }

    private boolean checkInforamtions() {
        return this._projectName != "" && this._folderName != "" && this._metaModelName != "";
    }

    private String getEcoreFilePathName() {
        return "/" + this._projectName + "/" + this._folderName + "/" + this.getCorrectECoreFileName(this._metaModelName);
    }
}

