/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.util;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.diagram.helper.conf.DiagramGenerationConfigurationHelper;

public final class VSMGenerationUtil {
    public static boolean canExecuteTask(ITaskProductionContext productionContext) throws InvocationException {
        EMFDomain domain = (EMFDomain)productionContext.getInputValue((Object)"vpdesc.model", EMFDomain.class);
        String projectName = (String)productionContext.getInputValue((Object)"design.project.name", String.class);
        if (VSMGenerationUtil.checkResourcesExistance(projectName)) {
            return VSMGenerationUtil.precondition(domain);
        }
        return true;
    }

    private static boolean checkResourcesExistance(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return project.exists();
    }

    private static boolean precondition(EMFDomain domain) throws InvocationException {
        EObject root;
        if (domain != null && (root = (EObject)domain.getContent().get(0)) != null) {
            boolean generateVSM = DiagramGenerationConfigurationHelper.generateVSM((EObject)root);
            return generateVSM;
        }
        return true;
    }
}

