/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.preference.helper;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.polarsys.kitalpha.doc.gen.business.core.preference.Activator;

public class DocgenProjectPreferencesHelper {
    private static DocgenProjectPreferencesHelper INSTANCE = null;
    private static IScopeContext currentScope;
    private static String currentResourceNodeName;

    private DocgenProjectPreferencesHelper() {
    }

    private void initScope(Object resource) {
        IProject project = DocgenProjectPreferencesHelper.getRelatedProject(resource);
        currentScope = project == null ? InstanceScope.INSTANCE : new ProjectScope(project);
    }

    public static DocgenProjectPreferencesHelper getInstance(Object resource) {
        if (INSTANCE == null) {
            INSTANCE = new DocgenProjectPreferencesHelper();
        }
        INSTANCE.initScope(resource);
        if (resource instanceof IResource) {
            INSTANCE.setCurrentResourceNodeName(((IResource)resource).getFullPath().toString());
        } else if (resource instanceof EObject) {
            URI uri = ((EObject)resource).eResource().getURI();
            INSTANCE.setCurrentResourceNodeName(uri.toFileString());
        } else {
            INSTANCE.setCurrentResourceNodeName("DefaultProjectResourceNodeName");
        }
        return INSTANCE;
    }

    public String getOutputLocationPreference(String defaultValue) {
        IEclipsePreferences docgenProjectNode = currentScope.getNode("org.polarsys.kitalpha.doc.gen");
        Preferences resourceNode = docgenProjectNode.node(currentResourceNodeName);
        return resourceNode.get("DocgenProjectResourceOutputPath", defaultValue);
    }

    public void setOutputLocationPreference(String value) {
        IEclipsePreferences docgenProjectNode = currentScope.getNode("org.polarsys.kitalpha.doc.gen");
        Preferences resourceNode = docgenProjectNode.node(currentResourceNodeName);
        resourceNode.put("DocgenProjectResourceOutputPath", value);
        try {
            docgenProjectNode.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError(e.getMessage(), e);
        }
    }

    private void setCurrentResourceNodeName(String fullPath) {
        String currentResourcePath = fullPath;
        if (currentResourcePath.charAt(0) == '/') {
            currentResourcePath = currentResourcePath.substring(1);
        }
        currentResourceNodeName = currentResourcePath.replaceAll(String.valueOf('/'), ".");
    }

    private static IProject getRelatedProject(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getProject();
        }
        if (element instanceof EObject) {
            URI uri = ((EObject)element).eResource().getURI();
            Path path = new Path(uri.toFileString());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
            return file.getProject();
        }
        return null;
    }
}

