/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.tools.ext.types;

import java.io.File;
import java.net.URI;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.polarsys.kitalpha.richtext.common.util.MDERichTextHelper;
import org.polarsys.kitalpha.richtext.widget.tools.ext.internal.Activator;
import org.polarsys.kitalpha.richtext.widget.tools.intf.LinkHandler;
import org.polarsys.kitalpha.richtext.widget.tools.utils.Tuple;

public class LocalFileLinkHandler
implements LinkHandler {
    public boolean canHandleLink(String link) {
        return link != null && link.contains("local:");
    }

    public void openLink(Object object, String link) {
        File file = new File(link);
        if (file.exists()) {
            URI uri = file.toURI();
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            try {
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)files[0]);
            }
            catch (PartInitException e) {
                Status status = new Status(4, "org.polarsys.kitalpha.richtext.widget.tools.ext", "Cannot open editor concerning file: " + uri.getPath(), (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public Tuple<String, String> getLink(String linkType, String basePath, Object object) {
        String location = null;
        if (object instanceof EObject) {
            Object result;
            EObject element = (EObject)object;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
            dialog.setTitle("Select File");
            dialog.setMessage("Select Local File");
            dialog.setInput((Object)MDERichTextHelper.getProject((EObject)element));
            if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof IFile && (location = ((IFile)result).getLocation().toPortableString()).startsWith(basePath)) {
                location = location.replaceFirst(basePath, "");
            }
        }
        return new Tuple(location, null);
    }

    public String encode(String url, String urlDisplayName) {
        return "<a href=\"local:///" + url + "\">" + StringEscapeUtils.escapeHtml((String)urlDisplayName) + "</a>";
    }

    public String decode(String url, String basePath) {
        url = url.replaceFirst("local:///", basePath);
        url = url.replace('/', '\\');
        url = url.replace("%20", " ");
        return url;
    }
}

