/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS10CertificationRequestBuilder;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.core.keystore.KeystoreInstance;
import org.eclipse.kura.core.keystore.crl.CRLManager;
import org.eclipse.kura.core.keystore.crl.CRLManagerOptions;
import org.eclipse.kura.core.keystore.crl.StoredCRL;
import org.eclipse.kura.security.keystore.KeystoreChangedEvent;
import org.eclipse.kura.security.keystore.KeystoreService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseKeystoreService
implements KeystoreService,
ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(BaseKeystoreService.class);
    protected static final String NULL_INPUT_PARAMS_MESSAGE = "Input parameters cannot be null!";
    protected static final String KURA_SERVICE_PID = "kura.service.pid";
    protected static final String PEM_CERTIFICATE_REQUEST_TYPE = "CERTIFICATE REQUEST";
    protected EventAdmin eventAdmin;
    protected Optional<CRLManager> crlManager = Optional.empty();
    protected String ownPid;
    protected ComponentContext componentContext;
    private CRLManagerOptions crlManagerOptions;

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected abstract KeystoreInstance loadKeystore() throws KuraException;

    protected abstract void saveKeystore(KeystoreInstance var1) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException;

    protected abstract String getCrlStorePath();

    public KeyStore getKeyStore() throws KuraException {
        return this.loadKeystore().getKeystore();
    }

    public void activate(ComponentContext context, Map<String, Object> properties) {
        this.componentContext = context;
        this.ownPid = (String)properties.get(KURA_SERVICE_PID);
        this.crlManagerOptions = new CRLManagerOptions(properties);
        this.updateCRLManager(this.crlManagerOptions);
    }

    public void updated(Map<String, Object> properties) {
        logger.info("Bundle {} is updating!", properties.get(KURA_SERVICE_PID));
        CRLManagerOptions newCRLManagerOptions = new CRLManagerOptions(properties);
        if (!this.crlManagerOptions.equals(newCRLManagerOptions)) {
            this.crlManagerOptions = newCRLManagerOptions;
            this.updateCRLManager(newCRLManagerOptions);
        }
    }

    public void deactivate() {
        this.shutdownCRLManager();
    }

    public KeyStore.Entry getEntry(String alias) throws KuraException {
        if (Objects.isNull(alias)) {
            throw new IllegalArgumentException("Key Pair alias cannot be null!");
        }
        KeystoreInstance ks = this.loadKeystore();
        try {
            if (ks.getKeystore().entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) || ks.getKeystore().entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
                return ks.getKeystore().getEntry(alias, new KeyStore.PasswordProtection(ks.getPassword()));
            }
            return ks.getKeystore().getEntry(alias, null);
        }
        catch (GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get the entry " + alias});
        }
    }

    public void setEntry(String alias, KeyStore.Entry entry) throws KuraException {
        if (Objects.isNull(alias) || alias.trim().isEmpty() || Objects.isNull(entry)) {
            throw new IllegalArgumentException("Input cannot be null or empty!");
        }
        KeystoreInstance ks = this.loadKeystore();
        KeyStore.PasswordProtection protectionParameter = entry instanceof KeyStore.TrustedCertificateEntry ? null : new KeyStore.PasswordProtection(ks.getPassword());
        try {
            ks.getKeystore().setEntry(alias, entry, protectionParameter);
            this.saveKeystore(ks);
            if (!this.tryAddToCrlManagement(entry)) {
                this.postChangedEvent();
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to set the entry " + alias});
        }
    }

    public Map<String, KeyStore.Entry> getEntries() throws KuraException {
        HashMap<String, KeyStore.Entry> result = new HashMap<String, KeyStore.Entry>();
        KeyStore ks = this.getKeyStore();
        try {
            ArrayList<String> aliases = Collections.list(ks.aliases());
            for (String alias : aliases) {
                KeyStore.Entry tempEntry = this.getEntry(alias);
                result.put(alias, tempEntry);
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get the entries"});
        }
    }

    public void deleteEntry(String alias) throws KuraException {
        if (Objects.isNull(alias)) {
            throw new IllegalArgumentException("Alias cannot be null!");
        }
        Optional<KeyStore.Entry> currentEntry = Optional.ofNullable(this.getEntry(alias));
        if (!currentEntry.isPresent()) {
            return;
        }
        KeystoreInstance ks = this.loadKeystore();
        try {
            ks.getKeystore().deleteEntry(alias);
            this.saveKeystore(ks);
            boolean crlStoreChanged = false;
            crlStoreChanged = this.tryRemoveFromCrlManagement(currentEntry.get());
            if (!crlStoreChanged) {
                this.postChangedEvent();
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to delete entry " + alias});
        }
    }

    public List<KeyManager> getKeyManagers(String algorithm) throws KuraException {
        if (Objects.isNull(algorithm)) {
            throw new IllegalArgumentException("Algorithm cannot be null!");
        }
        KeystoreInstance ks = this.loadKeystore();
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks.getKeystore(), ks.getPassword());
            return Arrays.asList(kmf.getKeyManagers());
        }
        catch (GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get the key managers for algorithm " + algorithm});
        }
    }

    public void createKeyPair(String alias, String algorithm, int keySize, String signatureAlgorithm, String attributes) throws KuraException {
        this.createKeyPair(alias, algorithm, keySize, signatureAlgorithm, attributes, new SecureRandom());
    }

    public void createKeyPair(String alias, String algorithm, int keySize, String signatureAlgorithm, String attributes, SecureRandom secureRandom) throws KuraException {
        if (Objects.isNull(algorithm) || algorithm.trim().isEmpty() || Objects.isNull(secureRandom) || Objects.isNull(alias) || Objects.isNull(attributes) || attributes.trim().isEmpty() || Objects.isNull(signatureAlgorithm) || signatureAlgorithm.trim().isEmpty()) {
            throw new IllegalArgumentException("Parameters cannot be null or empty!");
        }
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm, "BC");
            keyGen.initialize(keySize, secureRandom);
            KeyPair keyPair = keyGen.generateKeyPair();
            this.setEntry(alias, new KeyStore.PrivateKeyEntry(keyPair.getPrivate(), this.generateCertificateChain(keyPair, signatureAlgorithm, attributes)));
        }
        catch (GeneralSecurityException | OperatorCreationException throwable) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
    }

    public void createKeyPair(String alias, String algorithm, AlgorithmParameterSpec algorithmParameter, String signatureAlgorithm, String attributes, SecureRandom secureRandom) throws KuraException {
        if (Objects.isNull(algorithm) || algorithm.trim().isEmpty() || Objects.isNull(secureRandom) || Objects.isNull(alias) || Objects.isNull(attributes) || attributes.trim().isEmpty() || Objects.isNull(signatureAlgorithm) || signatureAlgorithm.trim().isEmpty() || Objects.isNull(algorithmParameter)) {
            throw new IllegalArgumentException("Parameters cannot be null or empty!");
        }
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(algorithm, "BC");
            keyGen.initialize(algorithmParameter, secureRandom);
            KeyPair keyPair = keyGen.generateKeyPair();
            this.setEntry(alias, new KeyStore.PrivateKeyEntry(keyPair.getPrivate(), this.generateCertificateChain(keyPair, signatureAlgorithm, attributes)));
        }
        catch (GeneralSecurityException | OperatorCreationException throwable) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
    }

    public void createKeyPair(String alias, String algorithm, AlgorithmParameterSpec algorithmParameter, String signatureAlgorithm, String attributes) throws KuraException {
        this.createKeyPair(alias, algorithm, algorithmParameter, signatureAlgorithm, attributes, new SecureRandom());
    }

    /*
     * Loose catch block
     */
    public String getCSR(KeyPair keypair, X500Principal principal, String signerAlg) throws KuraException {
        if (Objects.isNull(principal) || Objects.isNull(keypair) || Objects.isNull(signerAlg) || signerAlg.trim().isEmpty()) {
            throw new IllegalArgumentException(NULL_INPUT_PARAMS_MESSAGE);
        }
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try {
                String string;
                JcaPEMWriter pemWriter;
                StringWriter str;
                block20: {
                    block19: {
                        str = new StringWriter();
                        pemWriter = new JcaPEMWriter((Writer)str);
                        ContentSigner signer = new JcaContentSignerBuilder(signerAlg).build(keypair.getPrivate());
                        PKCS10CertificationRequest csr = this.getCSRAsPKCS10Builder(keypair, principal).build(signer);
                        PemObject pemCSR = new PemObject(PEM_CERTIFICATE_REQUEST_TYPE, csr.getEncoded());
                        pemWriter.writeObject((PemObjectGenerator)pemCSR);
                        pemWriter.flush();
                        string = str.toString();
                        if (pemWriter == null) break block19;
                        pemWriter.close();
                    }
                    if (str == null) break block20;
                    str.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (pemWriter != null) {
                                pemWriter.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (str != null) {
                                str.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new KuraException(KuraErrorCode.ENCODE_ERROR, (Throwable)e, new Object[]{"Failed to get CSR"});
        }
        catch (OperatorCreationException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get CSR"});
        }
    }

    public String getCSR(String alias, X500Principal principal, String signerAlg) throws KuraException {
        if (Objects.isNull(principal) || Objects.isNull(alias) || alias.trim().isEmpty() || Objects.isNull(signerAlg) || signerAlg.trim().isEmpty()) {
            throw new IllegalArgumentException(NULL_INPUT_PARAMS_MESSAGE);
        }
        KeyStore.Entry entry = this.getEntry(alias);
        if (entry == null) {
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        if (!(entry instanceof KeyStore.PrivateKeyEntry)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST);
        }
        PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
        PublicKey publicKey = ((KeyStore.PrivateKeyEntry)entry).getCertificate().getPublicKey();
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return this.getCSR(keyPair, principal, signerAlg);
    }

    protected PKCS10CertificationRequestBuilder getCSRAsPKCS10Builder(KeyPair keyPair, X500Principal principal) {
        if (Objects.isNull(principal) || Objects.isNull(keyPair)) {
            throw new IllegalArgumentException(NULL_INPUT_PARAMS_MESSAGE);
        }
        return new JcaPKCS10CertificationRequestBuilder(principal, keyPair.getPublic());
    }

    public List<String> getAliases() throws KuraException {
        KeyStore ks = this.getKeyStore();
        try {
            return Collections.list(ks.aliases());
        }
        catch (GeneralSecurityException e) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, (Throwable)e, new Object[]{"Failed to get aliases"});
        }
    }

    public Collection<CRL> getCRLs() {
        Optional<CRLManager> currentCRLManager = this.crlManager;
        if (!currentCRLManager.isPresent()) {
            return Collections.emptyList();
        }
        return new ArrayList<CRL>(currentCRLManager.get().getCrls());
    }

    public CertStore getCRLStore() throws KuraException {
        Optional<CRLManager> currentCRLManager = this.crlManager;
        try {
            if (!currentCRLManager.isPresent()) {
                return CertStore.getInstance("Collection", new CollectionCertStoreParameters());
            }
            return currentCRLManager.get().getCertStore();
        }
        catch (Exception e) {
            throw new KuraException(KuraErrorCode.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
    }

    public void addCRL(X509CRL crl) throws KuraException {
        this.crlManager.ifPresent(manager -> {
            StoredCRL storedCRL = new StoredCRL(Collections.emptySet(), crl);
            manager.getCRLStore().storeCRL(storedCRL);
        });
    }

    protected void postChangedEvent() {
        this.eventAdmin.postEvent((Event)new KeystoreChangedEvent(this.ownPid));
    }

    protected X509Certificate[] generateCertificateChain(KeyPair keyPair, String signatureAlgorithm, String attributes) throws OperatorCreationException, CertificateException {
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        Security.addProvider((Provider)bcProvider);
        long now = System.currentTimeMillis();
        Date startDate = new Date(now);
        X500Name dnName = new X500Name(attributes);
        BigInteger certSerialNumber = new BigInteger(Long.toString(now));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        calendar.add(1, 1);
        Date endDate = calendar.getTime();
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
        X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(dnName, certSerialNumber, startDate, endDate, dnName, subjectPublicKeyInfo);
        ContentSigner contentSigner = new JcaContentSignerBuilder(signatureAlgorithm).setProvider((Provider)bcProvider).build(keyPair.getPrivate());
        X509CertificateHolder certificateHolder = certificateBuilder.build(contentSigner);
        return new X509Certificate[]{new JcaX509CertificateConverter().getCertificate(certificateHolder)};
    }

    protected Optional<X509Certificate> extractCertificate(KeyStore.Entry entry) {
        if (!(entry instanceof KeyStore.TrustedCertificateEntry)) {
            return Optional.empty();
        }
        KeyStore.TrustedCertificateEntry trustedCertificateEntry = (KeyStore.TrustedCertificateEntry)entry;
        Certificate certificate = trustedCertificateEntry.getTrustedCertificate();
        if (!(certificate instanceof X509Certificate)) {
            return Optional.empty();
        }
        return Optional.of((X509Certificate)certificate);
    }

    protected boolean tryAddToCrlManagement(KeyStore.Entry entry) {
        Optional<X509Certificate> certificate = this.extractCertificate(entry);
        Optional<CRLManager> currentCrlManager = this.crlManager;
        if (certificate.isPresent() && currentCrlManager.isPresent()) {
            return currentCrlManager.get().addTrustedCertificate(certificate.get());
        }
        return false;
    }

    protected boolean tryRemoveFromCrlManagement(KeyStore.Entry entry) {
        Optional<X509Certificate> certificate = this.extractCertificate(entry);
        Optional<CRLManager> currentCrlManager = this.crlManager;
        if (certificate.isPresent() && currentCrlManager.isPresent()) {
            return currentCrlManager.get().removeTrustedCertificate(certificate.get());
        }
        return false;
    }

    protected void updateCRLManager(CRLManagerOptions newCRLManagerOptions) {
        this.shutdownCRLManager();
        if (this.crlManagerOptions.isCrlManagementEnabled()) {
            CRLManager currentCRLManager = new CRLManager(this.crlManagerOptions.getStoreFile().orElseGet(() -> new File(this.getCrlStorePath())), 5000L, newCRLManagerOptions.getCrlCheckIntervalMs(), newCRLManagerOptions.getCrlUpdateIntervalMs(), this.getCRLVerifier(newCRLManagerOptions));
            currentCRLManager.setListener(Optional.of(this::postChangedEvent));
            for (URI uri : newCRLManagerOptions.getCrlURIs()) {
                currentCRLManager.addDistributionPoint(Collections.singleton(uri));
            }
            try {
                for (KeyStore.Entry e : this.getEntries().values()) {
                    KeyStore.TrustedCertificateEntry certEntry;
                    Certificate cert;
                    if (!(e instanceof KeyStore.TrustedCertificateEntry) || !((cert = (certEntry = (KeyStore.TrustedCertificateEntry)e).getTrustedCertificate()) instanceof X509Certificate)) continue;
                    currentCRLManager.addTrustedCertificate((X509Certificate)cert);
                }
            }
            catch (Exception e) {
                logger.warn("failed to add current trusted certificates to CRL manager", (Throwable)e);
            }
            this.crlManager = Optional.of(currentCRLManager);
        }
    }

    protected CRLManager.CRLVerifier getCRLVerifier(CRLManagerOptions options) {
        if (!options.isCRLVerificationEnabled()) {
            return crl -> true;
        }
        return crl -> {
            try {
                KeyStore.TrustedCertificateEntry trustedCertEntry;
                KeyStore.Entry e;
                Iterator<KeyStore.Entry> iterator = this.getEntries().values().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while (!((e = iterator.next()) instanceof KeyStore.TrustedCertificateEntry) || !this.verifyCRL(crl, trustedCertEntry = (KeyStore.TrustedCertificateEntry)e));
                return true;
            }
            catch (Exception e) {
                logger.warn("Exception verifying CRL", (Throwable)e);
                return false;
            }
        };
    }

    protected void shutdownCRLManager() {
        if (this.crlManager.isPresent()) {
            this.crlManager.get().close();
            this.crlManager = Optional.empty();
        }
    }

    protected boolean verifyCRL(X509CRL crl, KeyStore.TrustedCertificateEntry trustedCertEntry) {
        try {
            crl.verify(trustedCertEntry.getTrustedCertificate().getPublicKey());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

