/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.provider;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.annotation.Priority;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.rest.auth.AuthenticationProvider;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=100)
public class CertificateAuthenticationProvider
implements AuthenticationProvider {
    private final UserAdmin userAdmin;
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");
    private static final String KURA_USER_PREFIX = "kura.user.";

    public CertificateAuthenticationProvider(UserAdmin userAdmin) {
        this.userAdmin = userAdmin;
    }

    @Override
    public Optional<Principal> authenticate(HttpServletRequest request, ContainerRequestContext requestContext) {
        AuditContext auditContext = AuditContext.currentOrInternal();
        try {
            Object clientCertificatesRaw = requestContext.getProperty("javax.servlet.request.X509Certificate");
            if (!(clientCertificatesRaw instanceof X509Certificate[])) {
                return Optional.empty();
            }
            X509Certificate[] clientCertificates = (X509Certificate[])clientCertificatesRaw;
            if (clientCertificates.length == 0) {
                throw new IllegalArgumentException("Certificate chain is empty");
            }
            LdapName ldapName = new LdapName(clientCertificates[0].getSubjectX500Principal().getName());
            Optional<Rdn> commonNameRdn = ldapName.getRdns().stream().filter(r -> "cn".equalsIgnoreCase(r.getType())).findAny();
            if (!commonNameRdn.isPresent()) {
                throw new IllegalArgumentException("Certificate common name is not present");
            }
            String commonName = (String)commonNameRdn.get().getValue();
            auditContext.getProperties().put(AuditConstants.KEY_IDENTITY.getValue(), commonName);
            if (this.userAdmin.getRole(KURA_USER_PREFIX + commonName) instanceof User) {
                auditLogger.info("{} Rest - Success - Certificate Authentication succeeded", (Object)auditContext);
                return Optional.of(() -> commonName);
            }
            auditLogger.warn("{} Rest - Failure - Certificate Authentication failed", (Object)auditContext);
            return Optional.empty();
        }
        catch (Exception exception) {
            auditLogger.warn("{} Rest - Failure - Certificate Authentication failed", (Object)auditContext);
            return Optional.empty();
        }
    }

    @Override
    public void onEnabled() {
    }

    @Override
    public void onDisabled() {
    }
}

