/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.base;

import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.kura.annotation.Nullable;

public final class StringUtil {
    private StringUtil() {
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.isEmpty();
    }

    public static String join(CharSequence delimiter, Iterable<?> tokens) {
        Objects.requireNonNull(delimiter, "Delimiter cannot be null.");
        Objects.requireNonNull(tokens, "Iterable elements cannot be null.");
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = tokens.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
            while (it.hasNext()) {
                sb.append(delimiter);
                sb.append(it.next());
            }
        }
        return sb.toString();
    }

    public static String unescapeUTF8String(String string) {
        Objects.requireNonNull(string, "String cannot be null");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '\\') {
                String hexString = string.substring(i += 2, i + 2);
                baos.write(Integer.parseInt(hexString, 16));
                i += 2;
                continue;
            }
            baos.write(string.charAt(i));
            ++i;
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }

    public static String toHex(String string) {
        StringBuilder sb = new StringBuilder();
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02X", b));
            ++n2;
        }
        return sb.toString();
    }
}

