/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.asset.cloudlet.serialization.request;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ReadRequest {
    private String assetName;
    private Set<String> channelNames = new HashSet<String>();

    public ReadRequest(JsonObject object) {
        this.assetName = object.get("name").asString();
        Optional.ofNullable(object.get("channels")).ifPresent(channels -> channels.asArray().forEach(value -> this.channelNames.add(value.asObject().get("name").asString())));
    }

    public static List<ReadRequest> parseAll(JsonArray array) {
        ArrayList<ReadRequest> result = new ArrayList<ReadRequest>();
        for (JsonValue value : array) {
            result.add(new ReadRequest(value.asObject()));
        }
        return result;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public Set<String> getChannelNames() {
        return this.channelNames;
    }
}

