/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.driver;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.kura.driver.Driver;
import org.eclipse.kura.driver.DriverService;
import org.eclipse.kura.util.service.ServiceUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class DriverServiceImpl
implements DriverService {
    private BundleContext bundleContext;

    public void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    public Driver getDriver(String driverPid) {
        Objects.requireNonNull(driverPid, "Driver PID cannot be null");
        Driver driver = null;
        String filterString = String.format("(&(kura.service.pid=%s))", driverPid);
        ServiceReference<Driver>[] refs = this.getDriverServiceReferences(filterString);
        try {
            ServiceReference<Driver>[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<Driver> ref = serviceReferenceArray[n2];
                driver = (Driver)this.bundleContext.getService(ref);
                ++n2;
            }
        }
        finally {
            this.ungetDriverServiceReferences(refs);
        }
        return driver;
    }

    public String getDriverPid(Driver driver) {
        Objects.requireNonNull(driver, "Driver PID cannot be null");
        ServiceReference<Driver>[] refs = this.getDriverServiceReferences(null);
        try {
            ServiceReference<Driver>[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<Driver> ref = serviceReferenceArray[n2];
                Driver driverRef = (Driver)this.bundleContext.getService(ref);
                if (driverRef == driver) {
                    String string = ref.getProperty("driver.pid").toString();
                    return string;
                }
                ++n2;
            }
        }
        finally {
            this.ungetDriverServiceReferences(refs);
        }
        return null;
    }

    public List<Driver> listDrivers() {
        ArrayList<Driver> drivers = new ArrayList<Driver>();
        ServiceReference<Driver>[] refs = this.getDriverServiceReferences(null);
        try {
            ServiceReference<Driver>[] serviceReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference<Driver> ref = serviceReferenceArray[n2];
                Driver driverRef = (Driver)this.bundleContext.getService(ref);
                drivers.add(driverRef);
                ++n2;
            }
        }
        finally {
            this.ungetDriverServiceReferences(refs);
        }
        return drivers;
    }

    protected ServiceReference<Driver>[] getDriverServiceReferences(String filter) {
        return ServiceUtil.getServiceReferences((BundleContext)this.bundleContext, Driver.class, (String)filter);
    }

    protected void ungetDriverServiceReferences(ServiceReference<Driver>[] refs) {
        ServiceUtil.ungetServiceReferences((BundleContext)this.bundleContext, refs);
    }
}

