/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.cloudconnection.provider;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.kura.KuraConnectException;
import org.eclipse.kura.KuraDisconnectException;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.KuraRuntimeException;
import org.eclipse.kura.cloud.CloudService;
import org.eclipse.kura.cloudconnection.CloudConnectionManager;
import org.eclipse.kura.data.DataService;
import org.eclipse.kura.util.service.ServiceUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConnectionManagerBridge {
    private static final String CONNECTION_ERROR_MESSAGE = "Error connecting. Please review your configuration.";
    private static final Logger logger = LoggerFactory.getLogger(CloudConnectionManagerBridge.class);
    private static final String DATA_SERVICE_REFERENCE_NAME = "DataService";
    private final BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();

    public void connectCloudEndpoint(String connectionId) throws KuraException {
        boolean ran = false;
        ran = this.runOnDataService(connectionId, dataService -> {
            int counter = 10;
            dataService.connect();
            while (!dataService.isConnected() && counter > 0) {
                Thread.sleep(1000L);
                --counter;
            }
        });
        boolean bl = ran = ran || this.runOnCloudConnectionManager(connectionId, cloudConnectionManager -> {
            try {
                cloudConnectionManager.connect();
            }
            catch (KuraConnectException e) {
                throw new KuraRuntimeException(KuraErrorCode.CONNECTION_FAILED, (Throwable)e, new Object[]{CONNECTION_ERROR_MESSAGE});
            }
        });
        if (!ran) {
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
    }

    public void disconnectCloudEndpoint(String connectionId) throws KuraException {
        boolean ran = false;
        ran = this.runOnDataService(connectionId, dataService -> dataService.disconnect(10L));
        boolean bl = ran = ran || this.runOnCloudConnectionManager(connectionId, CloudConnectionManager::disconnect);
        if (!ran) {
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
    }

    public boolean isConnectedCloudEndpoint(String connectionId) throws KuraException {
        boolean ran = false;
        AtomicReference<Boolean> connectionStatusHolder = new AtomicReference<Boolean>(false);
        ran = this.runOnDataService(connectionId, dataService -> connectionStatusHolder.set(dataService.isConnected()));
        boolean bl = ran = ran || this.runOnCloudConnectionManager(connectionId, cloudConnectionManager -> connectionStatusHolder.set(cloudConnectionManager.isConnected()));
        if (!ran) {
            throw new KuraException(KuraErrorCode.NOT_FOUND);
        }
        return connectionStatusHolder.get();
    }

    private boolean runOnDataService(String connectionId, InterruptableConsumer<DataService> dataServiceConsumer) throws KuraException {
        Collection cloudServiceReferences = ServiceUtil.getServiceReferencesAsCollection((BundleContext)this.bundleContext, CloudService.class, null);
        for (ServiceReference cloudServiceReference : cloudServiceReferences) {
            String cloudServicePid = (String)cloudServiceReference.getProperty("kura.service.pid");
            if (cloudServicePid.endsWith(connectionId)) {
                String dataServiceRef = (String)cloudServiceReference.getProperty("DataService.target");
                Collection dataServiceReferences = ServiceUtil.getServiceReferencesAsCollection((BundleContext)this.bundleContext, DataService.class, (String)dataServiceRef);
                for (ServiceReference dataServiceReference : dataServiceReferences) {
                    DataService dataService = (DataService)ServiceUtil.getService((BundleContext)this.bundleContext, (ServiceReference)dataServiceReference);
                    if (dataService != null) {
                        this.invokeAndHandleExceptions(dataServiceConsumer, dataService);
                        return true;
                    }
                    ServiceUtil.ungetService((BundleContext)this.bundleContext, (ServiceReference)dataServiceReference);
                }
            }
            ServiceUtil.ungetService((BundleContext)this.bundleContext, (ServiceReference)cloudServiceReference);
        }
        return false;
    }

    private boolean runOnCloudConnectionManager(String connectionId, InterruptableConsumer<CloudConnectionManager> cloudConnectionManagerConsumer) throws KuraException {
        Collection cloudConnectionManagerReferences = ServiceUtil.getServiceReferencesAsCollection((BundleContext)this.bundleContext, CloudConnectionManager.class, null);
        for (ServiceReference cloudConnectionManagerReference : cloudConnectionManagerReferences) {
            String cloudConnectionManagerPid = (String)cloudConnectionManagerReference.getProperty("kura.service.pid");
            if (cloudConnectionManagerPid.endsWith(connectionId)) {
                CloudConnectionManager cloudConnectionManager = (CloudConnectionManager)ServiceUtil.getService((BundleContext)this.bundleContext, (ServiceReference)cloudConnectionManagerReference);
                this.invokeAndHandleExceptions(cloudConnectionManagerConsumer, cloudConnectionManager);
                return true;
            }
            ServiceUtil.ungetService((BundleContext)this.bundleContext, (ServiceReference)cloudConnectionManagerReference);
        }
        return false;
    }

    private <T> void invokeAndHandleExceptions(InterruptableConsumer<T> consumer, T service) throws KuraException {
        try {
            consumer.accept(service);
        }
        catch (KuraConnectException e) {
            throw new KuraException(KuraErrorCode.CONNECTION_FAILED, (Throwable)e, new Object[]{CONNECTION_ERROR_MESSAGE});
        }
        catch (IllegalStateException e) {
            throw new KuraException(KuraErrorCode.INTERNAL_ERROR, (Throwable)e, new Object[]{"Illegal client state"});
        }
        catch (InterruptedException interruptedException) {
            logger.warn("Interrupt Exception");
            Thread.currentThread().interrupt();
        }
    }

    public static interface InterruptableConsumer<T> {
        public void accept(T var1) throws InterruptedException, KuraConnectException, KuraDisconnectException, IllegalStateException;
    }
}

