/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.jms.meta.JmsConnectionInfo;
import org.apache.qpid.jms.meta.JmsResource;
import org.apache.qpid.jms.provider.AsyncResult;
import org.apache.qpid.jms.provider.ProviderException;
import org.apache.qpid.jms.provider.amqp.AmqpProvider;
import org.apache.qpid.jms.provider.amqp.AmqpResource;
import org.apache.qpid.jms.provider.amqp.AmqpResourceParent;
import org.apache.qpid.jms.provider.amqp.AmqpSupport;
import org.apache.qpid.jms.provider.exceptions.ProviderOperationTimedOutException;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Endpoint;
import org.apache.qpid.proton.engine.EndpointState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AmqpAbstractResource<R extends JmsResource, E extends Endpoint>
implements AmqpResource {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpAbstractResource.class);
    protected AsyncResult closeRequest;
    protected ScheduledFuture<?> closeTimeoutTask;
    private final E endpoint;
    private final R resourceInfo;
    private final AmqpResourceParent parent;

    public AmqpAbstractResource(R resourceInfo, E endpoint) {
        this(resourceInfo, endpoint, null);
    }

    public AmqpAbstractResource(R resourceInfo, E endpoint, AmqpResourceParent parent) {
        this.parent = parent;
        this.endpoint = endpoint;
        this.resourceInfo = resourceInfo;
        this.resourceInfo.getId().setProviderHint(this);
    }

    public void close(AsyncResult request) {
        if (this.parent != null) {
            this.parent.removeChildResource(this);
        }
        this.resourceInfo.setState(JmsResource.ResourceState.CLOSED);
        if (this.getEndpoint().getLocalState() == EndpointState.CLOSED || this.getEndpoint().getRemoteState() == EndpointState.CLOSED) {
            if (this.getEndpoint().getLocalState() != EndpointState.CLOSED) {
                this.getEndpoint().close();
                this.getEndpoint().free();
                this.getEndpoint().setContext(null);
            }
            request.onSuccess();
            return;
        }
        LOG.trace("{} requesting close on remote.", (Object)this);
        this.closeRequest = request;
        long closeTimeout = this.getParent().getProvider().getCloseTimeout();
        if (closeTimeout == -1L) {
            closeTimeout = this.getParent().getProvider().getRequestTimeout();
        }
        if (closeTimeout != -1L) {
            this.closeTimeoutTask = this.getParent().getProvider().scheduleRequestTimeout(new AsyncResult(){

                @Override
                public void onSuccess() {
                }

                @Override
                public void onFailure(ProviderException result) {
                    AmqpAbstractResource.this.closeResource(AmqpAbstractResource.this.getParent().getProvider(), result, false);
                }

                @Override
                public boolean isComplete() {
                    return AmqpAbstractResource.this.closeRequest != null ? AmqpAbstractResource.this.closeRequest.isComplete() : true;
                }
            }, closeTimeout, new ProviderOperationTimedOutException("Timed Out Waiting for close response: " + this));
        }
        this.closeOrDetachEndpoint();
    }

    public void closeResource(AmqpProvider provider, ProviderException cause, boolean remotelyClosed) {
        if (this.parent != null) {
            this.parent.removeChildResource(this);
        }
        this.resourceInfo.setState(JmsResource.ResourceState.CLOSED);
        if (this.getEndpoint() != null) {
            this.closeOrDetachEndpoint();
            provider.pumpToProtonTransport();
            this.handleResourceClosure(provider, cause);
            if (remotelyClosed) {
                this.getEndpoint().free();
                this.getEndpoint().setContext(null);
            }
        }
        if (this.closeTimeoutTask != null) {
            this.closeTimeoutTask.cancel(true);
            this.closeTimeoutTask = null;
        }
        if (this.isAwaitingClose()) {
            LOG.debug("{} is now closed: ", (Object)this);
            if (cause == null) {
                this.closeRequest.onSuccess();
            } else {
                this.closeRequest.onFailure(cause);
            }
            this.closeRequest = null;
        } else if (cause != null) {
            if (this.getResourceInfo() instanceof JmsConnectionInfo) {
                provider.fireProviderException(cause);
            } else {
                provider.fireResourceClosed((JmsResource)this.getResourceInfo(), cause);
            }
        }
    }

    public void handleResourceClosure(AmqpProvider provider, ProviderException error) {
    }

    protected void closeOrDetachEndpoint() {
        this.getEndpoint().close();
    }

    public E getEndpoint() {
        return this.endpoint;
    }

    public R getResourceInfo() {
        return this.resourceInfo;
    }

    public AmqpResourceParent getParent() {
        return this.parent;
    }

    public boolean isOpen() {
        return this.getEndpoint().getRemoteState() == EndpointState.ACTIVE;
    }

    public boolean isClosed() {
        return this.getEndpoint().getLocalState() == EndpointState.CLOSED;
    }

    public boolean isAwaitingClose() {
        return this.closeRequest != null;
    }

    public EndpointState getLocalState() {
        if (this.getEndpoint() == null) {
            return EndpointState.UNINITIALIZED;
        }
        return this.getEndpoint().getLocalState();
    }

    public EndpointState getRemoteState() {
        if (this.getEndpoint() == null) {
            return EndpointState.UNINITIALIZED;
        }
        return this.getEndpoint().getRemoteState();
    }

    @Override
    public final void processRemoteOpen(AmqpProvider provider) throws ProviderException {
    }

    @Override
    public void processRemoteDetach(AmqpProvider provider) throws ProviderException {
        this.processRemoteClose(provider);
    }

    @Override
    public void processRemoteClose(AmqpProvider provider) throws ProviderException {
        this.getResourceInfo().setState(JmsResource.ResourceState.REMOTELY_CLOSED);
        if (this.isAwaitingClose()) {
            this.closeResource(provider, null, true);
        } else {
            this.closeResource(provider, AmqpSupport.convertToNonFatalException(provider, this.getEndpoint(), this.getEndpoint().getRemoteCondition()), true);
        }
    }

    @Override
    public void processDeliveryUpdates(AmqpProvider provider, Delivery delivery) throws ProviderException {
    }

    @Override
    public void processFlowUpdates(AmqpProvider provider) throws ProviderException {
    }
}

