/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.channel;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.annotation.NotThreadSafe;
import org.eclipse.kura.channel.ChannelStatus;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@NotThreadSafe
@ProviderType
public class ChannelRecord {
    private transient Map<String, Object> channelConfiguration;
    private ChannelStatus channelStatus;
    private String name;
    private DataType valueType;
    private TypedValue<?> value;
    private long timestamp;
    private String unit;

    private ChannelRecord() {
    }

    public static ChannelRecord createReadRecord(String channelName, DataType valueType) {
        Objects.requireNonNull(channelName, "Channel Name cannot be null");
        Objects.requireNonNull(valueType, "Value Type cannot be null");
        ChannelRecord result = new ChannelRecord();
        result.name = channelName;
        result.valueType = valueType;
        result.unit = "";
        return result;
    }

    public static ChannelRecord createReadRecord(String channelName, DataType valueType, String unit) {
        Objects.requireNonNull(channelName, "Channel Name cannot be null");
        Objects.requireNonNull(valueType, "Value Type cannot be null");
        ChannelRecord result = new ChannelRecord();
        result.name = channelName;
        result.valueType = valueType;
        result.unit = unit;
        return result;
    }

    public static ChannelRecord createWriteRecord(String channelName, TypedValue<?> value) {
        Objects.requireNonNull(channelName, "Channel Name cannot be null");
        Objects.requireNonNull(value, "Value cannot be null");
        ChannelRecord result = new ChannelRecord();
        result.name = channelName;
        result.valueType = value.getType();
        result.value = value;
        return result;
    }

    public static ChannelRecord createStatusRecord(String channelName, ChannelStatus status) {
        Objects.requireNonNull(channelName, "Channel Name cannot be null");
        Objects.requireNonNull(status, "Status cannot be null");
        ChannelRecord result = new ChannelRecord();
        result.name = channelName;
        result.channelStatus = status;
        return result;
    }

    public Map<String, Object> getChannelConfig() {
        return this.channelConfiguration;
    }

    public ChannelStatus getChannelStatus() {
        return this.channelStatus;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setChannelConfig(Map<String, Object> channelConfig) {
        Objects.requireNonNull(channelConfig, "Channel configuration cannot be null");
        this.channelConfiguration = new HashMap<String, Object>(channelConfig);
    }

    public void setChannelStatus(ChannelStatus status) {
        Objects.requireNonNull(status, "Channel Status cannot be null");
        this.channelStatus = status;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getChannelName() {
        return this.name;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    public TypedValue<?> getValue() {
        return this.value;
    }

    public void setValue(TypedValue<?> value) {
        Objects.requireNonNull(value, "Value cannot be null");
        this.value = value;
    }

    public String toString() {
        return "ChannelRecord [channelConfiguration=" + this.channelConfiguration + ", channelStatus=" + this.channelStatus + ", name=" + this.name + ", valueType=" + (Object)((Object)this.valueType) + ", value=" + this.value + ", timestamp=" + this.timestamp + ", unit=" + this.unit + "]";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.channelStatus == null ? 0 : this.channelStatus.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.valueType == null ? 0 : this.valueType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChannelRecord other = (ChannelRecord)obj;
        if (this.channelStatus == null ? other.channelStatus != null : !this.channelStatus.equals(other.channelStatus)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals(other.unit)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.valueType == other.valueType;
    }
}

