/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.session.Attributes;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;

public class GwtSecurityTokenServiceImpl
extends OsgiRemoteServiceServlet
implements GwtSecurityTokenService {
    private static final long serialVersionUID = 5333012054583792499L;
    private static ThreadLocal<HttpServletRequest> threadRequest = new ThreadLocal();
    static final String XSRF_TOKEN_KEY = "XSRF_TOKEN";

    public String processCall(String payload) throws SerializationException {
        try {
            threadRequest.set(this.getThreadLocalRequest());
            String string = super.processCall(payload);
            return string;
        }
        finally {
            threadRequest.remove();
        }
    }

    public static HttpServletRequest getRequest() {
        return threadRequest.get();
    }

    public HttpSession getHttpSession() {
        HttpServletRequest request = GwtSecurityTokenServiceImpl.getRequest();
        return request.getSession(false);
    }

    @Override
    public GwtXSRFToken generateSecurityToken() {
        HttpServletRequest httpServletRequest = GwtSecurityTokenServiceImpl.getRequest();
        HttpSession session = httpServletRequest.getSession(false);
        Optional<String> existingToken = Optional.ofNullable(session.getAttribute(Attributes.XSRF_TOKEN.getValue())).filter(String.class::isInstance).map(String.class::cast);
        if (existingToken.isPresent()) {
            return new GwtXSRFToken(existingToken.get());
        }
        UUID token = UUID.randomUUID();
        String asString = token.toString();
        session.setAttribute(Attributes.XSRF_TOKEN.getValue(), (Object)asString);
        return new GwtXSRFToken(asString);
    }
}

