/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.useradmin;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.kura.crypto.CryptoService;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.useradmin.Group;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public class UserAdminHelper {
    private static final String PERMISSION_ROLE_NAME_PREFIX = "kura.permission.";
    private static final String USER_ROLE_NAME_PREFIX = "kura.user.";
    private static final String PASSWORD_PROPERTY = "kura.password";
    private static final String KURA_NEED_PASSWORD_CHANGE = "kura.need.password.change";
    private final UserAdmin userAdmin;
    private final CryptoService cryptoService;

    public UserAdminHelper(UserAdmin userAdmin, CryptoService cryptoService) {
        this.userAdmin = userAdmin;
        this.cryptoService = cryptoService;
    }

    public void verifyUsernamePassword(String username, String password) throws AuthenticationException {
        User user = this.getUser(username).orElseThrow(() -> new AuthenticationException(AuthenticationException.Reason.USER_NOT_FOUND));
        try {
            String sha256Password = this.cryptoService.sha256Hash(password);
            if (!Objects.equals(sha256Password, user.getCredentials().get(PASSWORD_PROPERTY))) {
                throw new AuthenticationException(AuthenticationException.Reason.INCORRECT_PASSWORD);
            }
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            throw new AuthenticationException(AuthenticationException.Reason.ENCRYPTION_ERROR);
        }
    }

    public void requirePermissions(String username, String ... permissions) throws AuthenticationException {
        String userRoleName = UserAdminHelper.getUserRoleName(username);
        Role role = this.userAdmin.getRole(userRoleName);
        if (!(role instanceof User)) {
            throw new AuthenticationException(AuthenticationException.Reason.USER_NOT_FOUND);
        }
        Group admin = this.getOrCreatePermission("kura.admin");
        if (admin.getMembers() != null) {
            if (Arrays.stream(admin.getMembers()).anyMatch(role::equals)) {
                return;
            }
        }
        String[] stringArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            String permission = stringArray[n2];
            String permissionRoleName = UserAdminHelper.getPermissionRoleName(permission);
            Role permissionRole = this.userAdmin.getRole(permissionRoleName);
            if (!(permissionRole instanceof Group)) {
                throw new AuthenticationException(AuthenticationException.Reason.USER_NOT_IN_ROLE);
            }
            Group asGroup = (Group)permissionRole;
            Role[] members = asGroup.getMembers();
            if (members == null || Arrays.stream(members).noneMatch(r -> r.getName().equals(userRoleName))) {
                throw new AuthenticationException(AuthenticationException.Reason.USER_NOT_IN_ROLE);
            }
            ++n2;
        }
    }

    public Set<String> getIdentityPermissions(String name) {
        String userRoleName = UserAdminHelper.getUserRoleName(name);
        Role role = this.userAdmin.getRole(userRoleName);
        if (!(role instanceof User)) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        this.foreachPermission((permission, group) -> {
            Role[] members = group.getMembers();
            if (members != null && Arrays.stream(members).anyMatch(r -> r.getName().equals(userRoleName))) {
                result.add(UserAdminHelper.getBaseName((Role)group));
            }
        });
        return result;
    }

    public void changeUserPassword(String username, String userPassword) throws AuthenticationException {
        User user = this.getUser(username).orElseThrow(() -> new AuthenticationException(AuthenticationException.Reason.USER_NOT_FOUND));
        try {
            String newHash = this.cryptoService.sha256Hash(userPassword);
            if (Objects.equals(user.getCredentials().get(PASSWORD_PROPERTY), newHash)) {
                throw new AuthenticationException(AuthenticationException.Reason.PASSWORD_CHANGE_WITH_SAME_PASSWORD);
            }
            user.getCredentials().put(PASSWORD_PROPERTY, newHash);
            user.getProperties().remove(KURA_NEED_PASSWORD_CHANGE);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            throw new AuthenticationException(AuthenticationException.Reason.ENCRYPTION_ERROR);
        }
    }

    public boolean isPasswordChangeRequired(String username) {
        String userRoleName = UserAdminHelper.getUserRoleName(username);
        Role role = this.userAdmin.getRole(userRoleName);
        if (!(role instanceof User)) {
            return false;
        }
        User asUser = (User)role;
        return "true".equals(asUser.getProperties().get(KURA_NEED_PASSWORD_CHANGE));
    }

    public void createUser(String userName) {
        User createdUser = this.getOrCreateUser(userName);
        Objects.requireNonNull(createdUser, "Could not create user " + userName);
    }

    public void deleteUser(String userName) {
        Optional<User> user = this.getUser(userName);
        if (!user.isPresent()) {
            return;
        }
        this.foreachPermission((name, group) -> {
            boolean bl = group.removeMember((Role)user.get());
        });
        this.userAdmin.removeRole(user.get().getName());
    }

    public Optional<Integer> getCredentialsHash(String userName) {
        Optional<User> user = this.getUser(userName);
        if (!user.isPresent()) {
            return Optional.empty();
        }
        Dictionary credentials = user.get().getCredentials();
        if (credentials == null) {
            return Optional.empty();
        }
        return Optional.of(credentials.hashCode());
    }

    public Set<String> getDefinedPermissions() {
        HashSet<String> result = new HashSet<String>();
        this.foreachPermission((permission, group) -> {
            boolean bl = result.add(permission);
        });
        return result;
    }

    public Optional<User> getUser(String name) {
        String roleName = UserAdminHelper.getUserRoleName(name);
        Role role = this.userAdmin.getRole(roleName);
        if (!(role instanceof User)) {
            return Optional.empty();
        }
        if (!UserAdminHelper.getBaseName(role).equals(name)) {
            return Optional.empty();
        }
        return Optional.of((User)role);
    }

    private static String getUserRoleName(String name) {
        return USER_ROLE_NAME_PREFIX + name;
    }

    private static String getPermissionRoleName(String name) {
        return PERMISSION_ROLE_NAME_PREFIX + name;
    }

    private static boolean isKuraUser(Role role) {
        return role.getName().startsWith(USER_ROLE_NAME_PREFIX);
    }

    private static boolean isKuraPermission(Role role) {
        return role.getName().startsWith(PERMISSION_ROLE_NAME_PREFIX);
    }

    private static String getBaseName(Role role) {
        String name = role.getName();
        if (UserAdminHelper.isKuraUser(role)) {
            return name.substring(USER_ROLE_NAME_PREFIX.length());
        }
        if (UserAdminHelper.isKuraPermission(role)) {
            return name.substring(PERMISSION_ROLE_NAME_PREFIX.length());
        }
        throw new IllegalArgumentException("not a Kura role");
    }

    public Group getOrCreatePermission(String name) {
        return this.getOrCreateRole(Group.class, UserAdminHelper.getPermissionRoleName(name));
    }

    public User getOrCreateUser(String name) {
        return this.getOrCreateRole(User.class, UserAdminHelper.getUserRoleName(name));
    }

    private <T extends Role> T getOrCreateRole(Class<T> classz, String name) {
        int type;
        if (classz == Role.class) {
            type = 0;
        } else if (classz == User.class) {
            type = 1;
        } else if (classz == Group.class) {
            type = 2;
        } else {
            throw new IllegalArgumentException("unknown role type");
        }
        Role result = this.userAdmin.getRole(name);
        if (result != null && result.getType() == type) {
            return (T)result;
        }
        if (result == null) {
            return (T)this.userAdmin.createRole(name, type);
        }
        throw new IllegalArgumentException("role exists but has different type");
    }

    public <R extends Role, E extends Exception> void foreachRole(Class<R> classz, FallibleConsumer<R, E> consumer) throws E {
        try {
            Role[] existingRoles = this.userAdmin.getRoles(null);
            if (existingRoles != null) {
                Role[] roleArray = existingRoles;
                int n = existingRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    Role role = roleArray[n2];
                    if (classz.isInstance(role)) {
                        consumer.accept(role);
                    }
                    ++n2;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    public <E extends Exception> void foreachUser(UserConsumer<E> consumer) throws E {
        this.foreachRole(User.class, user -> {
            String name = user.getName();
            if (!name.startsWith(USER_ROLE_NAME_PREFIX)) {
                return;
            }
            consumer.accept(name.substring(USER_ROLE_NAME_PREFIX.length()), (User)user);
        });
    }

    public <E extends Exception> void foreachPermission(PermissionConsumer<E> consumer) throws E {
        this.foreachRole(Group.class, group -> {
            String name = group.getName();
            if (!name.startsWith(PERMISSION_ROLE_NAME_PREFIX)) {
                return;
            }
            consumer.accept(name.substring(PERMISSION_ROLE_NAME_PREFIX.length()), (Group)group);
        });
    }

    public static class AuthenticationException
    extends Exception {
        private static final long serialVersionUID = -8534499595655286448L;
        private final Reason reason;

        public AuthenticationException(Reason reason) {
            this.reason = reason;
        }

        public Reason getReason() {
            return this.reason;
        }

        public static enum Reason {
            USER_NOT_FOUND,
            INCORRECT_PASSWORD,
            USER_NOT_IN_ROLE,
            PASSWORD_CHANGE_WITH_SAME_PASSWORD,
            ENCRYPTION_ERROR;

        }
    }

    public static interface FallibleConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    public static interface PermissionConsumer<E extends Exception> {
        public void accept(String var1, Group var2) throws E;
    }

    public static interface UserConsumer<E extends Exception> {
        public void accept(String var1, User var2) throws E;
    }
}

