/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.external.api.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.typeadapters.RuntimeTypeAdapterFactory;
import org.eclipse.lsat.external.api.model.ActionBase;
import org.eclipse.lsat.external.api.model.ArrayValues;
import org.eclipse.lsat.external.api.model.Claim;
import org.eclipse.lsat.external.api.model.LsatData;
import org.eclipse.lsat.external.api.model.Move;
import org.eclipse.lsat.external.api.model.PeripheralAction;
import org.eclipse.lsat.external.api.model.ProductLifeCycleEventBase;
import org.eclipse.lsat.external.api.model.ProductLifeCycleEventEntry;
import org.eclipse.lsat.external.api.model.ProductLifeCycleEventExit;
import org.eclipse.lsat.external.api.model.ProductLifeCycleEventTransfer;
import org.eclipse.lsat.external.api.model.ProductPropertyBase;
import org.eclipse.lsat.external.api.model.ProductPropertyBoolean;
import org.eclipse.lsat.external.api.model.ProductPropertyInteger;
import org.eclipse.lsat.external.api.model.ProductPropertyString;
import org.eclipse.lsat.external.api.model.RaiseEvent;
import org.eclipse.lsat.external.api.model.Release;
import org.eclipse.lsat.external.api.model.RequireEvent;
import org.eclipse.lsat.external.api.model.ScalarValue;
import org.eclipse.lsat.external.api.model.SyncBar;
import org.eclipse.lsat.external.api.model.TimingSetting;

public class LsatDataUtil {
    private LsatDataUtil() {
    }

    private static RuntimeTypeAdapterFactory<ActionBase> actionFactory() {
        return RuntimeTypeAdapterFactory.of(ActionBase.class, "actionType").registerSubtype(Claim.class, "Claim").registerSubtype(Release.class, "Release").registerSubtype(Move.class, "Move").registerSubtype(PeripheralAction.class, "PeripheralAction").registerSubtype(RaiseEvent.class, "RaiseEvent").registerSubtype(RequireEvent.class, "RequireEvent").registerSubtype(SyncBar.class, "SyncBar");
    }

    private static RuntimeTypeAdapterFactory<ProductLifeCycleEventBase> productLifeCycleEventFactory() {
        return RuntimeTypeAdapterFactory.of(ProductLifeCycleEventBase.class, "eventType").registerSubtype(ProductLifeCycleEventEntry.class, "Entry").registerSubtype(ProductLifeCycleEventExit.class, "Exit").registerSubtype(ProductLifeCycleEventTransfer.class, "Transfer");
    }

    private static RuntimeTypeAdapterFactory<ProductPropertyBase> productPropertyFactory() {
        return RuntimeTypeAdapterFactory.of(ProductPropertyBase.class, "propertyType").registerSubtype(ProductPropertyBoolean.class, "Boolean").registerSubtype(ProductPropertyInteger.class, "Integer").registerSubtype(ProductPropertyString.class, "String");
    }

    private static RuntimeTypeAdapterFactory<TimingSetting> timingSettingFactory() {
        return RuntimeTypeAdapterFactory.of(TimingSetting.class, "type").registerSubtype(ScalarValue.class, "Scalar").registerSubtype(ArrayValues.class, "Array");
    }

    private static Gson newGsonWithLsatFactories() {
        return new GsonBuilder().registerTypeAdapterFactory(LsatDataUtil.actionFactory()).registerTypeAdapterFactory(LsatDataUtil.productLifeCycleEventFactory()).registerTypeAdapterFactory(LsatDataUtil.productPropertyFactory()).registerTypeAdapterFactory(LsatDataUtil.timingSettingFactory()).create();
    }

    public static LsatData fromJson(String jsonText) {
        Gson gson = LsatDataUtil.newGsonWithLsatFactories();
        LsatData lsatData = (LsatData)gson.fromJson(jsonText, LsatData.class);
        lsatData.resolveReferences(lsatData);
        return lsatData;
    }
}

