/**
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.mpt.transformation;

import activity.Activity
import activity.ActivitySet
import java.util.List

import static extension activity.util.ActivityParametersUtil.expandName
import static extension activity.util.ActivityParametersUtil.queryCreateExpandedActivity
import static extension com.google.common.collect.Sets.cartesianProduct
import static extension activity.util.ActivityParametersUtil.findCandidates

/**
 * Add a named Activity for all combinations of ResourceItems.
 * The original (unusable) activity is removed.
 */
final class ExpandActivities {
    private new (){}

    static def void expand(ActivitySet activitySet) {
        val expandMap = activitySet.activities.expandNames
        if(expandMap.size == activitySet.activities.size){
            //nothing to expand
            return
        }
        val eligibleActivities = activitySet.activities.filter[!resourcesNeedingItem.empty].toList
        eligibleActivities.forEach[expand]
    }
    
    private static def void expand(Activity activity) {
        val declarations = activity.findCandidates
        declarations.cartesianProduct.forEach[activity.queryCreateExpandedActivity(it)]
        
        // remove original activity from container as it should not be used anymore
        val c = activity.eContainer as ActivitySet
        c.activities -= activity;
    }
    
     /**
     * returns a map with all possible activity names and activity as values
     */
    static def expandNames(List<Activity> activities) {
        val result = newLinkedHashMap
        activities.forEach[ activity |
        result.put(activity.name, activity)
        val modelCandidates = activity.findCandidates
        modelCandidates.cartesianProduct.map[activity.expandName(it)].forEach[result.put(it, activity)]
        ]
        return result
    }

}
