/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.resource_throughput.ui.editors.internal;

import activity.SimpleAction;
import java.math.BigDecimal;
import machine.IResource;
import machine.Peripheral;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.lsat.common.emf.common.ui.BigDecimalCellEditor;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.resource_throughput.ui.editors.ResourceThroughputEditingDomain;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.swt.widgets.Composite;
import setting.PhysicalSettings;
import timing.Scalar;
import timing.Timing;
import timing.TimingPackage;

public class SimpleActionExecutionTimeEditingSupport
extends EditingSupport {
    private final ResourceThroughputEditingDomain editingDomain;
    private final CellEditor cellEditor;

    public SimpleActionExecutionTimeEditingSupport(ColumnViewer viewer, ResourceThroughputEditingDomain editingDomain) {
        super(viewer);
        this.editingDomain = editingDomain;
        this.cellEditor = new BigDecimalCellEditor((Composite)viewer.getControl());
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected Timing getEditorContext(Object element) {
        Timing timing = null;
        if (element instanceof SimpleAction) {
            SimpleAction action = (SimpleAction)element;
            Peripheral peripheral = action.getPeripheral();
            try {
                IResource resource = action.getResource();
                PhysicalSettings settings = this.editingDomain.getSettings().getPhysicalSettings(resource, peripheral);
                if (settings != null) {
                    timing = (Timing)settings.getTimingSettings().get((Object)action.getType());
                }
            }
            catch (SpecificationException specificationException) {
                // empty catch block
            }
        }
        return timing;
    }

    protected boolean canEdit(Object element) {
        return this.getValueInMillis(element) != null;
    }

    protected final Object getValue(Object element) {
        return this.getValueInMillis(element);
    }

    protected BigDecimal getValueInMillis(Object element) {
        BigDecimal value = null;
        if (element instanceof SimpleAction) {
            try {
                value = this.editingDomain.getTimingCalculator().calculateDuration((Node)((SimpleAction)element));
            }
            catch (MotionException | SpecificationException throwable) {
                // empty catch block
            }
        }
        return value == null ? null : value.movePointRight(3);
    }

    protected void setValue(Object element, Object value) {
        BigDecimal millis = (BigDecimal)value;
        if (this.getValueInMillis(element).compareTo(millis) != 0) {
            BigDecimal seconds = millis.movePointLeft(3);
            Timing timing = this.getEditorContext(element);
            if (timing instanceof Scalar) {
                this.editingDomain.getCommandStack().execute((Command)new SetCommand((EditingDomain)this.editingDomain, (EObject)timing, (EStructuralFeature)TimingPackage.Literals.SCALAR__VALUE, (Object)seconds));
            }
        }
    }
}

