/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.scheduler;

import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

final class ScheduleStatistics {
    final DescriptiveStatistics startTime;

    final DescriptiveStatistics duration;

    final DescriptiveStatistics critical;

    public ScheduleStatistics(CollectedScheduleData collectedData) {
        startTime = new DescriptiveStatistics(collectedData.startTime);
        duration = new DescriptiveStatistics(collectedData.duration);
        critical = new DescriptiveStatistics(collectedData.critical);
    }
}
