/*
 * Copyright (c) 2021, 2026 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.lsat.timing.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MotionData {
    private List<String> parameterNames;

    private List<double[]> timeData;

    MotionData() {
        parameterNames = new ArrayList<String>();
        timeData = new ArrayList<>();
    }

    void setParameterNames(List<String> names) {
        parameterNames = Collections.unmodifiableList(names);
    }

    void setTimeData(List<double[]> data) {
        timeData = data;
    }

    public List<String> getParameterNames() {
        return parameterNames;
    }

    public List<double[]> getTimeData() {
        return timeData;
    }
}
