/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.outline;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EditorToOutlineAdapterFactoryTest
extends AbstractTestWithProject {
    private static ContentOutline outline;

    @BeforeClass
    public static void setUpBeforeClass() {
        IViewPart viewPart = UI.getActivePage().findView("org.eclipse.ui.views.ContentOutline");
        if (viewPart instanceof ContentOutline) {
            ContentOutline thisOutline;
            outline = thisOutline = (ContentOutline)viewPart;
        }
        Assert.assertNotNull((Object)outline);
    }

    @Test
    public void testGetAdapter() throws CoreException {
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "Hello World !!");
        outline.partClosed((IWorkbenchPart)outline);
        MockLanguageServer.INSTANCE.setTimeToProceedQueries(500L);
        TestUtils.openEditor(testFile);
        long beginOpenOutline = System.currentTimeMillis();
        outline.partOpened((IWorkbenchPart)outline);
        long endOpenOutline = System.currentTimeMillis();
        long durationOpenOutline = endOpenOutline - beginOpenOutline;
        Assert.assertTrue((String)String.format("Open outline took longer than 50ms: %d", durationOpenOutline), (durationOpenOutline <= 50L ? 1 : 0) != 0);
        DisplayHelper.sleep((Display)Display.getCurrent(), (long)1000L);
        String pageClassName = outline.getCurrentPage().getClass().getCanonicalName();
        Assert.assertTrue((String)("Outline page class is not as expected: " + pageClassName), (boolean)pageClassName.contains("lsp4e"));
    }
}

