/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.lsp4mp.commons.metadata.ItemHint;
import org.eclipse.lsp4mp.commons.metadata.ItemMetadata;
import org.eclipse.lsp4mp.jdt.core.IPropertiesCollector;
import org.eclipse.lsp4mp.jdt.core.IPropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public abstract class AbstractPropertiesProvider
implements IPropertiesProvider {
    protected abstract String[] getPatterns();

    @Override
    public SearchPattern createSearchPattern() {
        SearchPattern leftPattern = null;
        String[] patterns = this.getPatterns();
        if (patterns == null) {
            return null;
        }
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (leftPattern == null) {
                leftPattern = this.createSearchPattern(pattern);
            } else {
                SearchPattern rightPattern = this.createSearchPattern(pattern);
                if (rightPattern != null) {
                    leftPattern = SearchPattern.createOrPattern((SearchPattern)leftPattern, (SearchPattern)rightPattern);
                }
            }
            ++n2;
        }
        return leftPattern;
    }

    protected abstract SearchPattern createSearchPattern(String var1);

    protected static SearchPattern createAnnotationTypeReferenceSearchPattern(String annotationName) {
        return SearchPattern.createPattern((String)annotationName, (int)8, (int)65536, (int)0);
    }

    protected static SearchPattern createAnnotationTypeDeclarationSearchPattern(String annotationName) {
        return SearchPattern.createPattern((String)annotationName, (int)8, (int)0, (int)0);
    }

    protected ItemMetadata addItemMetadata(IPropertiesCollector collector, String name, String type, String description, String sourceType, String sourceField, String sourceMethod, String defaultValue, String extensionName, boolean binary, int phase) {
        return collector.addItemMetadata(name, type, description, sourceType, sourceField, sourceMethod, defaultValue, extensionName, binary, phase);
    }

    protected ItemMetadata addItemMetadata(IPropertiesCollector collector, String name, String type, String description, String sourceType, String sourceField, String sourceMethod, String defaultValue, String extensionName, boolean binary) {
        return this.addItemMetadata(collector, name, type, description, sourceType, sourceField, sourceMethod, defaultValue, extensionName, binary, 0);
    }

    protected String updateHint(IPropertiesCollector collector, IType type) throws JavaModelException {
        if (type == null) {
            return null;
        }
        if (type.isEnum()) {
            String hint = JDTTypeUtils.getPropertyType(type, null);
            if (!collector.hasItemHint(hint)) {
                IJavaElement[] children;
                ItemHint itemHint = collector.getItemHint(hint);
                itemHint.setSourceType(hint);
                if (!type.isBinary()) {
                    itemHint.setSource(Boolean.TRUE);
                }
                IJavaElement[] iJavaElementArray = children = type.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElement c = iJavaElementArray[n2];
                    if (c.getElementType() == 8 && ((IField)c).isEnumConstant()) {
                        String enumName = ((IField)c).getElementName();
                        ItemHint.ValueHint value = new ItemHint.ValueHint();
                        value.setValue(enumName);
                        itemHint.getValues().add(value);
                    }
                    ++n2;
                }
            }
            return hint;
        }
        return null;
    }
}

