/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.lsp4mp.commons.ClasspathKind;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfo;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.jdt.core.PropertiesManager;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.core.JavaUtils;
import org.eclipse.lsp4mp.jdt.internal.core.JobHelpers;
import org.eclipse.lsp4mp.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class BasePropertiesManagerTest {
    private static final Logger LOGGER = Logger.getLogger(BasePropertiesManagerTest.class.getSimpleName());
    private static Level oldLevel;
    protected static IJDTUtils JDT_UTILS;

    static {
        JDT_UTILS = JDTUtilsLSImpl.getInstance();
    }

    @BeforeClass
    public static void setUp() {
        oldLevel = LOGGER.getLevel();
        LOGGER.setLevel(Level.INFO);
    }

    @AfterClass
    public static void tearDown() {
        LOGGER.setLevel(oldLevel);
    }

    protected static void setJDTUtils(IJDTUtils newUtils) {
        JDT_UTILS = newUtils;
    }

    protected static MicroProfileProjectInfo getMicroProfileProjectInfoFromMavenProject(MavenProjectName mavenProject) throws CoreException, Exception, JavaModelException {
        return BasePropertiesManagerTest.getMicroProfileProjectInfoFromMavenProject(mavenProject, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
    }

    protected static MicroProfileProjectInfo getMicroProfileProjectInfoFromMavenProject(MavenProjectName mavenProject, List<MicroProfilePropertiesScope> scopes) throws CoreException, Exception, JavaModelException {
        IJavaProject javaProject = BasePropertiesManagerTest.loadMavenProject(mavenProject);
        return PropertiesManager.getInstance().getMicroProfileProjectInfo(javaProject, scopes, ClasspathKind.SRC, JDT_UTILS, DocumentFormat.Markdown, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IJavaProject loadMavenProject(MavenProjectName mavenProject) throws CoreException, Exception {
        return BasePropertiesManagerTest.loadJavaProject(mavenProject.getName(), "maven");
    }

    public static IJavaProject loadGradleProject(GradleProjectName gradleProject) throws CoreException, Exception {
        return BasePropertiesManagerTest.loadJavaProject(gradleProject.getName(), "gradle");
    }

    public static IJavaProject loadMavenProjectFromSubFolder(MavenProjectName mavenProject, String subFolder) throws Exception {
        return BasePropertiesManagerTest.loadJavaProject(mavenProject.getName(), Paths.get("maven", subFolder).toString());
    }

    private static IJavaProject loadJavaProject(String projectName, String parentDirName) throws CoreException, Exception {
        File projectFolder = BasePropertiesManagerTest.copyProjectToWorkingDirectory(projectName, parentDirName);
        Path path = new Path(new File(projectFolder, "/.project").getAbsolutePath());
        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        if (!project.exists()) {
            project.create(description, null);
            project.open(null);
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    monitor.done();
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            JavaCore.run((IWorkspaceRunnable)runnable, null, (IProgressMonitor)monitor);
            BasePropertiesManagerTest.waitForBackgroundJobs((IProgressMonitor)monitor);
        }
        IJavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(description.getName());
        return javaProject;
    }

    private static File copyProjectToWorkingDirectory(String projectName, String parentDirName) throws IOException {
        File from = new File("projects/" + parentDirName + "/" + projectName);
        File to = new File(JavaUtils.getWorkingProjectDirectory(), Paths.get(parentDirName, projectName).toString());
        if (to.exists()) {
            FileUtils.forceDelete((File)to);
        }
        if (from.isDirectory()) {
            FileUtils.copyDirectory((File)from, (File)to);
        } else {
            FileUtils.copyFile((File)from, (File)to);
        }
        return to;
    }

    private static void waitForBackgroundJobs(IProgressMonitor monitor) throws Exception {
        JobHelpers.waitForJobsToComplete(monitor);
    }

    protected static void createFile(File file, String content) throws IOException {
        Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
        Files.write(file.toPath(), content.getBytes(), new OpenOption[0]);
    }

    protected static void updateFile(File file, String content) throws IOException {
        try {
            Thread.sleep(1050L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        BasePropertiesManagerTest.createFile(file, content);
    }

    protected static void saveFile(String configFileName, String content, IJavaProject javaProject) throws JavaModelException, IOException {
        IPath output = javaProject.getOutputLocation();
        File file = javaProject.getProject().getLocation().append(output.removeFirstSegments(1)).append(configFileName).toFile();
        BasePropertiesManagerTest.updateFile(file, content);
    }

    protected static void deleteFile(String configFileName, IJavaProject javaProject) throws JavaModelException, IOException {
        IPath output = javaProject.getOutputLocation();
        File file = javaProject.getProject().getLocation().append(output.removeFirstSegments(1)).append(configFileName).toFile();
        file.delete();
    }

    public static enum GradleProjectName {
        empty_gradle_project("empty-gradle-project"),
        quarkus_gradle_project("quarkus-gradle-project"),
        renamed_quarkus_gradle_project("renamed-gradle");

        private final String name;

        private GradleProjectName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum MavenProjectName {
        all_quarkus_extensions("all-quarkus-extensions"),
        config_hover("config-hover"),
        config_properties("config-properties"),
        config_quickstart("config-quickstart"),
        config_quickstart_test("config-quickstart-test"),
        empty_maven_project("empty-maven-project"),
        other_empty_maven_project("empty-maven-project"),
        folder_name_different_maven("folder-name-different-maven"),
        hibernate_orm_resteasy("hibernate-orm-resteasy"),
        hibernate_orm_resteasy_yaml("hibernate-orm-resteasy-yaml"),
        kubernetes("kubernetes"),
        microprofile_fault_tolerance("microprofile-fault-tolerance"),
        microprofile_health_quickstart("microprofile-health-quickstart"),
        microprofile_lra("microprofile-lra"),
        microprofile_context_propagation("microprofile-context-propagation"),
        microprofile_metrics("microprofile-metrics"),
        microprofile_opentracing("microprofile-opentracing"),
        microprofile_openapi("microprofile-openapi"),
        microprofile_reactive_messaging("microprofile-reactive-messaging"),
        microprofile_graphql("microprofile-graphql"),
        microprofile_jwt_quickstart("microprofile-jwt-quickstart"),
        quarkus_container_images("quarkus-container-images"),
        rest_client_quickstart("rest-client-quickstart"),
        using_vertx("using-vertx");

        private final String name;

        private MavenProjectName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

