/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.metrics.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4mp.jdt.internal.metrics.java.MicroProfileMetricsErrorCode;

public class MicroProfileMetricsDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.metrics.MetricID") != null;
    }

    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        IJavaElement[] elements = typeRoot.getChildren();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        MicroProfileMetricsDiagnosticsParticipant.collectDiagnostics(elements, diagnostics, context, monitor);
        return diagnostics;
    }

    private static void collectDiagnostics(IJavaElement[] elements, List<Diagnostic> diagnostics, JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IType type;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (element.getElementType() == 7 && !(type = (IType)element).isInterface()) {
                MicroProfileMetricsDiagnosticsParticipant.validateClassType(type, diagnostics, context, monitor);
            }
            ++n2;
        }
    }

    private static void validateClassType(IType classType, List<Diagnostic> diagnostics, JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        boolean hasInvalidScopeAnnotation;
        context.getUri();
        context.getUtils();
        context.getDocumentFormat();
        boolean bl = hasInvalidScopeAnnotation = AnnotationUtils.hasAnnotation((IAnnotatable)classType, "javax.enterprise.context.RequestScoped") || AnnotationUtils.hasAnnotation((IAnnotatable)classType, "javax.enterprise.context.SessionScoped") || AnnotationUtils.hasAnnotation((IAnnotatable)classType, "javax.enterprise.context.Dependent") || AnnotationUtils.hasAnnotation((IAnnotatable)classType, "jakarta.enterprise.context.RequestScoped") || AnnotationUtils.hasAnnotation((IAnnotatable)classType, "jakarta.enterprise.context.SessionScoped") || AnnotationUtils.hasAnnotation((IAnnotatable)classType, "jakarta.enterprise.context.Dependent");
        if (hasInvalidScopeAnnotation) {
            IJavaElement[] iJavaElementArray = classType.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement element = iJavaElementArray[n2];
                if (monitor.isCanceled()) {
                    return;
                }
                if (element.getElementType() == 9) {
                    IMethod method = (IMethod)element;
                    MicroProfileMetricsDiagnosticsParticipant.validateMethod(classType, method, diagnostics, context);
                }
                ++n2;
            }
        }
    }

    private static void validateMethod(IType classType, IMethod method, List<Diagnostic> diagnostics, JavaDiagnosticsContext context) throws CoreException {
        String uri = context.getUri();
        DocumentFormat documentFormat = context.getDocumentFormat();
        boolean hasGaugeAnnotation = AnnotationUtils.hasAnnotation((IAnnotatable)method, "org.eclipse.microprofile.metrics.annotation.Gauge");
        if (hasGaugeAnnotation) {
            Range cdiBeanRange = PositionUtils.toNameRange(classType, context.getUtils());
            Diagnostic d = context.createDiagnostic(uri, MicroProfileMetricsDiagnosticsParticipant.createDiagnostic1Message(classType, documentFormat), cdiBeanRange, "microprofile-metrics", MicroProfileMetricsErrorCode.ApplicationScopedAnnotationMissing);
            diagnostics.add(d);
        }
    }

    private static String createDiagnostic1Message(IType classType, DocumentFormat documentFormat) {
        StringBuilder message = new StringBuilder("The class ");
        if (DocumentFormat.Markdown.equals((Object)documentFormat)) {
            message.append("`");
        }
        message.append(classType.getFullyQualifiedName());
        if (DocumentFormat.Markdown.equals((Object)documentFormat)) {
            message.append("`");
        }
        message.append(" using the @Gauge annotation should use the @ApplicationScoped annotation. The @Gauge annotation does not support multiple instances of the underlying bean to be created.");
        return message.toString();
    }
}

