/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.ls;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.lsp4mp.commons.MicroProfileJavaProjectLabelsParams;
import org.eclipse.lsp4mp.jdt.core.ProjectLabelManager;
import org.eclipse.lsp4mp.jdt.internal.core.ls.AbstractMicroProfileDelegateCommandHandler;
import org.eclipse.lsp4mp.jdt.internal.core.ls.ArgumentUtils;
import org.eclipse.lsp4mp.jdt.internal.core.ls.JDTUtilsLSImpl;

public class JavaProjectDelegateCommandHandler
extends AbstractMicroProfileDelegateCommandHandler {
    private static final String PROJECT_LABELS_COMMAND_ID = "microprofile/java/projectLabels";
    private static final String WORKSPACE_LABELS_COMMAND_ID = "microprofile/java/workspaceLabels";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor progress) throws Exception {
        switch (commandId) {
            case "microprofile/java/projectLabels": {
                return JavaProjectDelegateCommandHandler.getProjectLabelInfo(arguments, commandId, progress);
            }
            case "microprofile/java/workspaceLabels": {
                return ProjectLabelManager.getInstance().getProjectLabelInfo();
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported command '%s'!", commandId));
    }

    private static Object getProjectLabelInfo(List<Object> arguments, String commandId, IProgressMonitor monitor) {
        Map<String, Object> obj = ArgumentUtils.getFirst(arguments);
        if (obj == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with one MicroProfileJavaProjectLabelsParams argument!", commandId));
        }
        String javaFileUri = ArgumentUtils.getString(obj, "uri");
        if (javaFileUri == null) {
            throw new UnsupportedOperationException(String.format("Command '%s' must be called with required MicroProfileJavaProjectLabelsParams.uri (java file URI)!", commandId));
        }
        List<String> types = ArgumentUtils.getStringList(obj, "types");
        MicroProfileJavaProjectLabelsParams params = new MicroProfileJavaProjectLabelsParams();
        params.setUri(javaFileUri);
        params.setTypes(types);
        return ProjectLabelManager.getInstance().getProjectLabelInfo(params, JDTUtilsLSImpl.getInstance(), monitor);
    }
}

