/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.project;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4mp.jdt.core.project.MicroProfileConfigPropertyInformation;
import org.eclipse.lsp4mp.jdt.internal.core.project.IConfigSource;
import org.eclipse.lsp4mp.jdt.internal.core.project.PropertiesConfigSource;
import org.eclipse.lsp4mp.jdt.internal.core.project.YamlConfigSource;

public class JDTMicroProfileProject {
    public static final String MICROPROFILE_CONFIG_PROPERTIES_FILE = "META-INF/microprofile-config.properties";
    @Deprecated
    public static final String APPLICATION_PROPERTIES_FILE = "application.properties";
    @Deprecated
    public static final String APPLICATION_YAML_FILE = "application.yaml";
    private final List<IConfigSource> configSources = new ArrayList<IConfigSource>(3);

    public JDTMicroProfileProject(IJavaProject javaProject) {
        this.configSources.add(new YamlConfigSource(APPLICATION_YAML_FILE, javaProject));
        this.configSources.add(new PropertiesConfigSource(APPLICATION_PROPERTIES_FILE, javaProject));
        this.configSources.add(new PropertiesConfigSource(MICROPROFILE_CONFIG_PROPERTIES_FILE, javaProject));
    }

    public String getProperty(String propertyKey, String defaultValue) {
        for (IConfigSource configSource : this.configSources) {
            String propertyValue = configSource.getProperty(propertyKey);
            if (propertyValue == null) continue;
            return propertyValue;
        }
        return defaultValue;
    }

    public String getProperty(String propertyKey) {
        return this.getProperty(propertyKey, null);
    }

    public Integer getPropertyAsInteger(String key, Integer defaultValue) {
        for (IConfigSource configSource : this.configSources) {
            Integer property = configSource.getPropertyAsInt(key);
            if (property == null) continue;
            return property;
        }
        return defaultValue;
    }

    public List<MicroProfileConfigPropertyInformation> getPropertyInformations(String propertyKey) {
        HashMap<String, MicroProfileConfigPropertyInformation> propertyToInfoMap = new HashMap<String, MicroProfileConfigPropertyInformation>();
        int i = this.configSources.size() - 1;
        while (i >= 0) {
            IConfigSource configSource = this.configSources.get(i);
            propertyToInfoMap.putAll(configSource.getPropertyInformations(propertyKey));
            --i;
        }
        return propertyToInfoMap.values().stream().sorted((a, b) -> a.getPropertyNameWithProfile().compareTo(b.getPropertyNameWithProfile())).collect(Collectors.toList());
    }
}

