/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core.project;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4mp.jdt.core.project.MicroProfileConfigPropertyInformation;
import org.eclipse.lsp4mp.jdt.core.utils.YamlUtils;
import org.eclipse.lsp4mp.jdt.internal.core.project.AbstractConfigSource;
import org.yaml.snakeyaml.Yaml;

public class YamlConfigSource
extends AbstractConfigSource<Map<String, Object>> {
    public YamlConfigSource(String configFileName, IJavaProject javaProject) {
        super(configFileName, javaProject);
    }

    @Override
    protected Map<String, Object> loadConfig(InputStream input) throws IOException {
        Yaml yaml = new Yaml();
        return (Map)yaml.load(input);
    }

    @Override
    protected String getProperty(String key, Map<String, Object> config) {
        Object value;
        String[] keyArray = key.split("\\.");
        Map curr = config;
        int i = 0;
        while (i < keyArray.length - 1) {
            value = curr.get(keyArray[i]);
            if (value == null || value instanceof String) {
                return null;
            }
            curr = (Map)value;
            ++i;
        }
        value = curr.get(keyArray[keyArray.length - 1]);
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        }
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    @Override
    public Map<String, MicroProfileConfigPropertyInformation> getPropertyInformations(String propertyKey, Map<String, Object> config) {
        HashMap<String, MicroProfileConfigPropertyInformation> result = new HashMap<String, MicroProfileConfigPropertyInformation>();
        if (config == null) {
            return result;
        }
        List<String> segments = MicroProfileConfigPropertyInformation.getSegments(propertyKey);
        if (segments.size() < 1) {
            return result;
        }
        for (String key : config.keySet()) {
            String value;
            if (key.equals(segments.get(0))) {
                value = YamlUtils.getValueRecursively(segments, config);
                if (value == null) continue;
                result.put(propertyKey, new MicroProfileConfigPropertyInformation(propertyKey, value, this.getSourceConfigFileURI(), this.getConfigFileName()));
                continue;
            }
            if (key.charAt(0) != '%' || !(config.get(key) instanceof Map) || (value = YamlUtils.getValueRecursively(segments, config.get(key))) == null) continue;
            String propertyAndProfile = String.valueOf(key) + "." + propertyKey;
            result.put(propertyAndProfile, new MicroProfileConfigPropertyInformation(propertyAndProfile, value, this.getSourceConfigFileURI(), this.getConfigFileName()));
        }
        return result;
    }
}

