/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4mp.commons.JavaFileInfo;
import org.eclipse.lsp4mp.commons.MicroProfileJavaFileInfoParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.PropertiesManagerForJava;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesManagerForJavaTest
extends BasePropertiesManagerTest {
    @Test
    public void fileInfoWithPackage() throws CoreException, Exception {
        IJavaProject javaProject = PropertiesManagerForJavaTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/org/acme/config/GreetingResource.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaFileInfoParams params = new MicroProfileJavaFileInfoParams();
        params.setUri(javaFileUri);
        JavaFileInfo javaFileInfo = PropertiesManagerForJava.getInstance().fileInfo(params, JDT_UTILS, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)javaFileInfo);
        Assert.assertEquals((Object)"org.acme.config", (Object)javaFileInfo.getPackageName());
    }

    @Test
    public void fileInfoWithoutPackage() throws CoreException, Exception {
        IJavaProject javaProject = PropertiesManagerForJavaTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/NoPackage.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaFileInfoParams params = new MicroProfileJavaFileInfoParams();
        params.setUri(javaFileUri);
        JavaFileInfo javaFileInfo = PropertiesManagerForJava.getInstance().fileInfo(params, JDT_UTILS, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNotNull((Object)javaFileInfo);
        Assert.assertEquals((Object)"", (Object)javaFileInfo.getPackageName());
    }

    @Test
    public void fileInfoNull() throws CoreException, Exception {
        IJavaProject javaProject = PropertiesManagerForJavaTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.config_hover);
        IProject project = javaProject.getProject();
        IFile javaFile = project.getFile((IPath)new Path("src/main/java/BAD_JAVA_FILE.java"));
        String javaFileUri = javaFile.getLocation().toFile().toURI().toString();
        MicroProfileJavaFileInfoParams params = new MicroProfileJavaFileInfoParams();
        params.setUri(javaFileUri);
        JavaFileInfo javaFileInfo = PropertiesManagerForJava.getInstance().fileInfo(params, JDT_UTILS, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertNull((Object)javaFileInfo);
    }
}

