/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.jaxrs.java;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.jdt.core.java.codelens.IJavaCodeLensParticipant;
import org.eclipse.lsp4mp.jdt.core.java.codelens.JavaCodeLensContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class JaxRsCodeLensParticipant
implements IJavaCodeLensParticipant {
    private static final String LOCALHOST = "localhost";
    private static final int PING_TIMEOUT = 2000;

    @Override
    public boolean isAdaptedForCodeLens(JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        MicroProfileJavaCodeLensParams params = context.getParams();
        if (!params.isUrlCodeLensEnabled()) {
            return false;
        }
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "javax.ws.rs.Path") != null;
    }

    @Override
    public void beginCodeLens(JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        JaxRsContext.getJaxRsContext(context).getApplicationPath(monitor);
    }

    @Override
    public List<CodeLens> collectCodeLens(JavaCodeLensContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        IJavaElement[] elements = typeRoot.getChildren();
        JaxRsContext jaxrsContext = JaxRsContext.getJaxRsContext(context);
        IJDTUtils utils = context.getUtils();
        MicroProfileJavaCodeLensParams params = context.getParams();
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        JaxRsCodeLensParticipant.collectURLCodeLenses(elements, null, lenses, params, jaxrsContext, utils, monitor);
        return lenses;
    }

    private static void collectURLCodeLenses(IJavaElement[] elements, String rootPath, Collection<CodeLens> lenses, MicroProfileJavaCodeLensParams params, JaxRsContext jaxrsContext, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String openURICommandId;
            String baseURL;
            CodeLens lens;
            IMethod method;
            IJavaElement parentType;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (element.getElementType() == 7) {
                IType type = (IType)element;
                String pathValue = JaxRsUtils.getJaxRsPathValue((IAnnotatable)type);
                if (pathValue != null && (!params.isCheckServerAvailable() || JaxRsCodeLensParticipant.isServerAvailable(LOCALHOST, jaxrsContext.getServerPort(), 2000))) {
                    JaxRsCodeLensParticipant.collectURLCodeLenses(type.getChildren(), pathValue, lenses, params, jaxrsContext, utils, monitor);
                }
            } else if (element.getElementType() == 9 && !utils.isHiddenGeneratedElement(element) && ((parentType = element.getAncestor(7)) == null || !JDTTypeUtils.overlaps(((ISourceReference)parentType).getNameRange(), ((ISourceReference)element).getNameRange())) && rootPath != null && JaxRsUtils.isJaxRsRequestMethod(method = (IMethod)element) && Flags.isPublic((int)method.getFlags()) && (lens = JaxRsUtils.createURLCodeLens(baseURL = jaxrsContext.getLocalBaseURL(), rootPath, openURICommandId = JaxRsUtils.isClickableJaxRsRequestMethod(method) ? params.getOpenURICommand() : null, (IMethod)element, utils)) != null) {
                lenses.add(lens);
            }
            ++n2;
        }
    }

    private static boolean isServerAvailable(String host, int port, int timeout) {
        block12: {
            Throwable throwable = null;
            Object var4_5 = null;
            Socket socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(host, port), timeout);
                if (socket == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            socket.close();
        }
        return true;
    }
}

