/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.JavaSearchScope;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4mp.commons.ClasspathKind;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfo;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfoParams;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.commons.MicroProfilePropertyDefinitionParams;
import org.eclipse.lsp4mp.commons.MicroProfilePropertyDocumentationParams;
import org.eclipse.lsp4mp.jdt.core.ArtifactResolver;
import org.eclipse.lsp4mp.jdt.core.BuildingScopeContext;
import org.eclipse.lsp4mp.jdt.core.IPropertiesProvider;
import org.eclipse.lsp4mp.jdt.core.SearchContext;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTMicroProfileUtils;
import org.eclipse.lsp4mp.jdt.internal.core.FakeJavaProject;
import org.eclipse.lsp4mp.jdt.internal.core.PropertiesCollector;
import org.eclipse.lsp4mp.jdt.internal.core.PropertiesProviderRegistry;
import org.eclipse.lsp4mp.jdt.internal.core.StaticPropertyProviderRegistry;

public class PropertiesManager {
    private static final PropertiesManager INSTANCE = new PropertiesManager();
    private static final Logger LOGGER = Logger.getLogger(PropertiesManager.class.getName());

    public static PropertiesManager getInstance() {
        return INSTANCE;
    }

    private PropertiesManager() {
    }

    public MicroProfileProjectInfo getMicroProfileProjectInfo(MicroProfileProjectInfoParams params, IJDTUtils utils, IProgressMonitor progress) throws JavaModelException, CoreException {
        IFile file = utils.findFile(params.getUri());
        if (file == null || file.getProject() == null) {
            return MicroProfileProjectInfo.EMPTY_PROJECT_INFO;
        }
        if (!JavaProject.hasJavaNature((IProject)file.getProject())) {
            return PropertiesManager.createInfo(file.getProject(), ClasspathKind.NONE);
        }
        return this.getMicroProfileProjectInfo(file, params.getScopes(), utils, params.getDocumentFormat(), progress);
    }

    public MicroProfileProjectInfo getMicroProfileProjectInfo(IFile file, List<MicroProfilePropertiesScope> scopes, IJDTUtils utils, DocumentFormat documentFormat, IProgressMonitor progress) throws JavaModelException, CoreException {
        String projectName = file.getProject().getName();
        JavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
        ClasspathKind classpathKind = JDTMicroProfileUtils.getClasspathKind((IResource)file, (IJavaProject)javaProject);
        return this.getMicroProfileProjectInfo((IJavaProject)javaProject, scopes, classpathKind, utils, documentFormat, progress);
    }

    public MicroProfileProjectInfo getMicroProfileProjectInfo(IJavaProject javaProject, List<MicroProfilePropertiesScope> scopes, ClasspathKind classpathKind, IJDTUtils utils, DocumentFormat documentFormat, IProgressMonitor monitor) throws JavaModelException, CoreException {
        MicroProfileProjectInfo info = PropertiesManager.createInfo(javaProject.getProject(), classpathKind);
        if (classpathKind == ClasspathKind.NONE) {
            info.setProperties(Collections.emptyList());
            return info;
        }
        long startTime = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Start computing MicroProfile properties for '" + info.getProjectURI() + "' project.");
        }
        SubMonitor mainMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Scanning properties for '" + javaProject.getProject().getName() + "' project in '" + scopes.stream().map(Enum::name).collect(Collectors.joining("+")) + "'"), (int)100);
        try {
            boolean excludeTestCode = classpathKind == ClasspathKind.SRC;
            IJavaProject javaProjectForSearch = this.configureSearchClasspath(javaProject, excludeTestCode, scopes, (IProgressMonitor)mainMonitor.split(50));
            if (mainMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.scanJavaClasses(javaProjectForSearch, excludeTestCode, documentFormat, scopes, info, utils, mainMonitor.split(50));
            if (mainMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
        finally {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("End computing MicroProfile properties for '" + info.getProjectURI() + "' project in " + (System.currentTimeMillis() - startTime) + "ms.");
            }
            mainMonitor.done();
        }
        return info;
    }

    public IJavaProject configureSearchClasspath(IJavaProject javaProject, boolean excludeTestCode, List<MicroProfilePropertiesScope> scopes, IProgressMonitor monitor) throws JavaModelException {
        SubMonitor mainMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        mainMonitor.subTask("Configuring search classpath");
        int length = this.getPropertiesProviders().size();
        SubMonitor subMonitor = mainMonitor.setWorkRemaining(length + 1);
        subMonitor.split(1);
        try {
            IJavaProject iJavaProject = this.getJavaProject(javaProject, excludeTestCode, scopes, subMonitor);
            return iJavaProject;
        }
        finally {
            subMonitor.done();
        }
    }

    private void scanJavaClasses(IJavaProject javaProjectForSearch, boolean excludeTestCode, DocumentFormat documentFormat, List<MicroProfilePropertiesScope> scopes, MicroProfileProjectInfo info, IJDTUtils utils, SubMonitor mainMonitor) throws JavaModelException, CoreException {
        mainMonitor.subTask("Scanning Java classes");
        final SubMonitor subMonitor = mainMonitor.setWorkRemaining(100);
        try {
            subMonitor.split(5);
            SearchPattern pattern = this.createSearchPattern();
            SearchEngine engine = new SearchEngine();
            IJavaSearchScope scope = this.createSearchScope(javaProjectForSearch, scopes, excludeTestCode, (IProgressMonitor)subMonitor);
            PropertiesCollector collector = new PropertiesCollector(info, scopes);
            final SearchContext context = new SearchContext(javaProjectForSearch, collector, utils, documentFormat, scopes);
            this.beginSearch(context, (IProgressMonitor)subMonitor);
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (!match.isInsideDocComment()) {
                        PropertiesManager.this.collectProperties(match, context, (IProgressMonitor)subMonitor);
                    }
                }
            }, (IProgressMonitor)subMonitor);
            this.endSearch(context, (IProgressMonitor)subMonitor);
        }
        finally {
            subMonitor.done();
        }
    }

    private void beginSearch(SearchContext context, IProgressMonitor monitor) {
        for (IPropertiesProvider provider : this.getPropertiesProviders()) {
            provider.beginSearch(context, monitor);
        }
    }

    private void endSearch(SearchContext context, IProgressMonitor monitor) {
        for (IPropertiesProvider provider : this.getPropertiesProviders()) {
            provider.endSearch(context, monitor);
        }
    }

    private void collectProperties(SearchMatch match, SearchContext context, IProgressMonitor monitor) {
        for (IPropertiesProvider provider : this.getPropertiesProviders()) {
            provider.collectProperties(match, context, monitor);
        }
    }

    private static MicroProfileProjectInfo createInfo(IProject project, ClasspathKind classpathKind) {
        MicroProfileProjectInfo info = new MicroProfileProjectInfo();
        info.setProjectURI(JDTMicroProfileUtils.getProjectURI(project));
        info.setClasspathKind(classpathKind);
        if (classpathKind == ClasspathKind.NONE) {
            info.setProperties(Collections.emptyList());
        }
        return info;
    }

    private IJavaSearchScope createSearchScope(IJavaProject project, List<MicroProfilePropertiesScope> scopes, boolean excludeTestCode, IProgressMonitor monitor) throws JavaModelException {
        int searchScope = 0;
        for (MicroProfilePropertiesScope scope : scopes) {
            switch (scope) {
                case sources: {
                    searchScope |= 1;
                    break;
                }
                case dependencies: {
                    searchScope |= 2;
                }
            }
        }
        if (project instanceof FakeJavaProject) {
            FakeJavaProject fakeProject = (FakeJavaProject)project;
            return PropertiesManager.createJavaSearchScope((IJavaProject)fakeProject, excludeTestCode, fakeProject.getElementsToSearch(scopes), searchScope);
        }
        return BasicSearchEngine.createJavaSearchScope((boolean)excludeTestCode, (IJavaElement[])new IJavaElement[]{project}, (int)searchScope);
    }

    private IJavaProject getJavaProject(IJavaProject javaProject, boolean excludeTestCode, List<MicroProfilePropertiesScope> scopes, SubMonitor monitor) throws JavaModelException {
        if (javaProject instanceof FakeJavaProject) {
            return javaProject;
        }
        SubMonitor mainMonitor = monitor;
        BuildingScopeContext context = new BuildingScopeContext(javaProject, excludeTestCode, scopes, ArtifactResolver.DEFAULT_ARTIFACT_RESOLVER);
        this.beginBuildingScope(context, (IProgressMonitor)mainMonitor);
        this.contributeToClasspath(context, mainMonitor);
        this.endBuildingScope(context, (IProgressMonitor)mainMonitor);
        List<IClasspathEntry> searchClasspathEntries = context.getSearchClassPathEntries();
        if (!searchClasspathEntries.isEmpty()) {
            return new FakeJavaProject(javaProject, searchClasspathEntries);
        }
        return javaProject;
    }

    private void beginBuildingScope(BuildingScopeContext context, IProgressMonitor monitor) {
        for (IPropertiesProvider provider : this.getPropertiesProviders()) {
            provider.beginBuildingScope(context, monitor);
        }
    }

    private void contributeToClasspath(BuildingScopeContext context, SubMonitor mainMonitor) throws OperationCanceledException, JavaModelException {
        int length = this.getPropertiesProviders().size();
        int i = 0;
        while (i < length) {
            mainMonitor.subTask("Contributing to classpath for provider (" + (i + 1) + "/" + length + ")");
            SubMonitor subMonitor = mainMonitor.split(1);
            IPropertiesProvider provider = this.getPropertiesProviders().get(i);
            provider.contributeToClasspath(context, (IProgressMonitor)subMonitor);
            subMonitor.done();
            ++i;
        }
    }

    private void endBuildingScope(BuildingScopeContext context, IProgressMonitor monitor) {
        for (IPropertiesProvider provider : this.getPropertiesProviders()) {
            provider.endBuildingScope(context, monitor);
        }
    }

    private SearchPattern createSearchPattern() {
        SearchPattern leftPattern = null;
        for (IPropertiesProvider provider : this.getPropertiesProviders()) {
            if (leftPattern == null) {
                leftPattern = provider.createSearchPattern();
                continue;
            }
            SearchPattern rightPattern = provider.createSearchPattern();
            if (rightPattern == null) continue;
            leftPattern = SearchPattern.createOrPattern((SearchPattern)leftPattern, (SearchPattern)rightPattern);
        }
        return leftPattern;
    }

    private static IJavaSearchScope createJavaSearchScope(final IJavaProject fakeProject, boolean excludeTestCode, IJavaElement[] elements, int includeMask) {
        HashSet<void> projectsToBeAdded = new HashSet<void>(2);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            IJavaElement element = elements[i];
            if (element instanceof JavaProject var8_10) {
                projectsToBeAdded.add(javaProject);
            }
            ++i;
        }
        JavaSearchScope scope = new JavaSearchScope(excludeTestCode){

            public IPackageFragmentRoot packageFragmentRoot(String resourcePathString, int jarSeparatorIndex, String jarPath) {
                try {
                    IPackageFragmentRoot[] roots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots = fakeProject.getPackageFragmentRoots();
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                        if (resourcePathString.startsWith(root.getPath().toOSString())) {
                            return root;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException javaModelException) {}
                return super.packageFragmentRoot(resourcePathString, jarSeparatorIndex, jarPath);
            }
        };
        int i2 = 0;
        int length2 = elements.length;
        while (i2 < length2) {
            IJavaElement element = elements[i2];
            if (element != null) {
                try {
                    if (projectsToBeAdded.contains(element)) {
                        scope.add((JavaProject)element, includeMask, projectsToBeAdded);
                    } else {
                        scope.add(element);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            ++i2;
        }
        return scope;
    }

    List<IPropertiesProvider> getPropertiesProviders() {
        ArrayList<IPropertiesProvider> allProviders = new ArrayList<IPropertiesProvider>();
        allProviders.addAll(PropertiesProviderRegistry.getInstance().getProviders());
        allProviders.addAll(StaticPropertyProviderRegistry.getInstance().getProviders());
        return allProviders;
    }

    public Location findPropertyLocation(MicroProfilePropertyDefinitionParams params, IJDTUtils utils, IProgressMonitor progress) throws JavaModelException, CoreException {
        IFile file = utils.findFile(params.getUri());
        if (file == null) {
            throw new UnsupportedOperationException(String.format("Cannot find IFile for '%s'", params.getUri()));
        }
        String projectName = file.getProject().getName();
        JavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
        return this.findPropertyLocation((IJavaProject)javaProject, params.getSourceType(), params.getSourceField(), params.getSourceMethod(), utils, progress);
    }

    public IMember findProperty(IJavaProject javaProject, String sourceType, String sourceField, String sourceMethod, IJDTUtils utils, IProgressMonitor progress) throws JavaModelException, CoreException {
        IMember fieldOrMethod = this.findDeclaredProperty(javaProject, sourceType, sourceField, sourceMethod, progress);
        if (fieldOrMethod != null) {
            IClassFile classFile = fieldOrMethod.getClassFile();
            if (classFile != null && utils != null) {
                utils.discoverSource(classFile, progress);
            }
            return fieldOrMethod;
        }
        return null;
    }

    public Location findPropertyLocation(IJavaProject javaProject, String sourceType, String sourceField, String sourceMethod, IJDTUtils utils, IProgressMonitor progress) throws JavaModelException, CoreException {
        IMember fieldOrMethod = this.findProperty(javaProject, sourceType, sourceField, sourceMethod, utils, progress);
        if (fieldOrMethod != null && fieldOrMethod.exists()) {
            return utils.toLocation((IJavaElement)fieldOrMethod);
        }
        return null;
    }

    public IMember findDeclaredProperty(IJavaProject javaProject, String sourceType, String sourceField, String sourceMethod, IProgressMonitor monitor) throws JavaModelException {
        String title = PropertiesManager.getMonitorTitle(javaProject, sourceType, sourceField, sourceMethod);
        SubMonitor mainMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)title, (int)100);
        try {
            if (sourceType == null) {
                return null;
            }
            IJavaProject fakeProject = null;
            if (javaProject instanceof FakeJavaProject) {
                fakeProject = javaProject;
                javaProject = ((FakeJavaProject)fakeProject).getRootProject();
            }
            mainMonitor.subTask("Finding type with the standard classpath");
            SubMonitor subMonitor = mainMonitor.split(20).setWorkRemaining(100);
            subMonitor.split(5);
            IType type = javaProject.findType(sourceType, (IProgressMonitor)subMonitor);
            subMonitor.done();
            if (mainMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            mainMonitor.subTask("Finding type with the search classpath");
            subMonitor = mainMonitor.split(80).setWorkRemaining(100);
            subMonitor.split(5);
            if (type == null) {
                if (fakeProject == null) {
                    fakeProject = this.configureSearchClasspath(javaProject, false, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES, (IProgressMonitor)subMonitor);
                }
                if (mainMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                type = fakeProject.findType(sourceType, (IProgressMonitor)subMonitor);
            }
            subMonitor.done();
            if (mainMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (type == null) {
                return null;
            }
            if (sourceField != null) {
                IField iField = type.getField(sourceField);
                return iField;
            }
            if (sourceMethod != null) {
                int startBracketIndex = sourceMethod.indexOf(40);
                String methodName = sourceMethod.substring(0, startBracketIndex);
                int endBracketIndex = sourceMethod.indexOf(41);
                String methodSignature = sourceMethod.substring(startBracketIndex, endBracketIndex + 1);
                String[] paramTypes = methodSignature.isEmpty() ? CharOperation.NO_STRINGS : Signature.getParameterTypes((String)methodSignature);
                IMethod method = JavaModelUtil.findMethod((String)methodName, (String[])paramTypes, (boolean)false, (IType)type);
                IMethod iMethod = method != null ? method : JavaModelUtil.findMethod((String)methodName, (String[])paramTypes, (boolean)true, (IType)type);
                return iMethod;
            }
            IType iType = type;
            return iType;
        }
        finally {
            mainMonitor.done();
        }
    }

    public String collectPropertyDocumentation(MicroProfilePropertyDocumentationParams params, IJDTUtils utils, IProgressMonitor progress) throws JavaModelException, CoreException {
        IFile file = utils.findFile(params.getUri());
        if (file == null) {
            throw new UnsupportedOperationException(String.format("Cannot find IFile for '%s'", params.getUri()));
        }
        String projectName = file.getProject().getName();
        JavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
        IMember member = this.findProperty((IJavaProject)javaProject, params.getSourceType(), params.getSourceField(), params.getSourceMethod(), utils, progress);
        if (member == null) {
            return null;
        }
        return utils.getJavadoc(member, params.getDocumentFormat());
    }

    private static String getMonitorTitle(IJavaProject javaProject, String sourceType, String sourceField, String sourceMethod) {
        StringBuilder title = new StringBuilder("Finding declared property");
        if (sourceField == null && sourceMethod == null) {
            title.append(" for type '");
            title.append(sourceType);
            title.append("'");
        } else {
            if (sourceField != null) {
                title.append(" for field '");
                title.append(sourceField);
                title.append("'");
            } else {
                title.append(" for method '");
                title.append(sourceMethod);
                title.append("'");
            }
            title.append(" of the type '");
            title.append(sourceType);
            title.append("'");
        }
        title.append(" in the '");
        title.append(javaProject.getProject().getName());
        title.append("' project ");
        return title.toString();
    }
}

