/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.jaxrs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4mp.jdt.core.jaxrs.HttpMethod;
import org.eclipse.lsp4mp.jdt.core.jaxrs.IJaxRsInfoProvider;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsContext;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsMethodInfo;
import org.eclipse.lsp4mp.jdt.core.jaxrs.JaxRsUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;

public class TestJaxRsInfoProvider
implements IJaxRsInfoProvider {
    private static final String CUSTOM_JAXRS_TEST_CLASS_FQN = "org.acme.hibernate.orm.CustomJaxRsResolving";

    public boolean canProvideJaxRsMethodInfoForClass(ITypeRoot typeRoot, IProgressMonitor monitor) {
        IType fruitResourceType = JDTTypeUtils.findType((IJavaProject)typeRoot.getJavaProject(), (String)CUSTOM_JAXRS_TEST_CLASS_FQN);
        return typeRoot.equals(fruitResourceType.getTypeRoot());
    }

    public Set<ITypeRoot> getAllJaxRsClasses(IJavaProject javaProject, IProgressMonitor monitor) {
        IType fruitResourceType = JDTTypeUtils.findType((IJavaProject)javaProject, (String)CUSTOM_JAXRS_TEST_CLASS_FQN);
        if (fruitResourceType == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(fruitResourceType.getTypeRoot());
    }

    public List<JaxRsMethodInfo> getJaxRsMethodInfo(ITypeRoot typeRoot, JaxRsContext jaxrsContext, IJDTUtils utils, IProgressMonitor monitor) {
        ArrayList<JaxRsMethodInfo> methodInfos = new ArrayList<JaxRsMethodInfo>();
        try {
            TestJaxRsInfoProvider.collectJaxRsMethodInfo(typeRoot.getChildren(), null, methodInfos, jaxrsContext, utils, monitor);
        }
        catch (CoreException coreException) {}
        return methodInfos;
    }

    private static void collectJaxRsMethodInfo(IJavaElement[] elements, String rootPath, Collection<JaxRsMethodInfo> jaxRsMethodsInfo, JaxRsContext jaxrsContext, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String baseURL;
            JaxRsMethodInfo info;
            IMethod method;
            IJavaElement parentType;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (element.getElementType() == 7) {
                IType type = (IType)element;
                String pathValue = JaxRsUtils.getJaxRsPathValue((IAnnotatable)type);
                if (pathValue != null && CUSTOM_JAXRS_TEST_CLASS_FQN.equals(type.getFullyQualifiedName())) {
                    TestJaxRsInfoProvider.collectJaxRsMethodInfo(type.getChildren(), pathValue, jaxRsMethodsInfo, jaxrsContext, utils, monitor);
                }
            } else if (!(element.getElementType() != 9 || utils.isHiddenGeneratedElement(element) || (parentType = element.getAncestor(7)) != null && JDTTypeUtils.overlaps((ISourceRange)((ISourceReference)parentType).getNameRange(), (ISourceRange)((ISourceReference)element).getNameRange()) || rootPath == null || !Flags.isPublic((int)(method = (IMethod)element).getFlags()) || (info = TestJaxRsInfoProvider.createJaxRsMethodInfo(baseURL = jaxrsContext.getLocalBaseURL(), rootPath, method, utils)) == null)) {
                jaxRsMethodsInfo.add(info);
            }
            ++n2;
        }
    }

    private static JaxRsMethodInfo createJaxRsMethodInfo(String baseUrl, String rootPath, IMethod method, IJDTUtils utils) throws JavaModelException {
        IResource resource = method.getResource();
        if (resource == null) {
            return null;
        }
        String documentUri = resource.getLocationURI().toString();
        String pathValue = JaxRsUtils.getJaxRsPathValue((IAnnotatable)method);
        String url = JaxRsUtils.buildURL((String[])new String[]{baseUrl, rootPath, pathValue});
        return new JaxRsMethodInfo(url, HttpMethod.GET, method, documentUri);
    }
}

