/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoCompletionProcessor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoDocAutoIndentStrategy;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoSourceContent;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoTemplateReconcilingStrategy;
import org.eclipse.acceleo.internal.ide.ui.editors.template.color.AcceleoColor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.color.AcceleoColorManager;
import org.eclipse.acceleo.internal.ide.ui.editors.template.hover.AcceleoHover;
import org.eclipse.acceleo.internal.ide.ui.editors.template.hover.AcceleoHoverInformationControl;
import org.eclipse.acceleo.internal.ide.ui.editors.template.hover.AcceleoTextHover;
import org.eclipse.acceleo.internal.ide.ui.editors.template.quickfix.AcceleoQuickFixProcessor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AbstractAcceleoScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoBlockScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoCommentScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoDefaultScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoDocumentationScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoForScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoIfScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoLetScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoMacroScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoProtectedAreaScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoQueryScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoTemplateScanner;
import org.eclipse.acceleo.internal.ide.ui.editors.template.scanner.AcceleoToken;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class AcceleoConfiguration
extends TextSourceViewerConfiguration {
    private static final int COMPLETION_AUTO_ACTIVATION_DELAY = 1000;
    protected AcceleoEditor editor;
    private AbstractAcceleoScanner[] scanners;
    private IEclipsePreferences[] lookupOrder;

    public AcceleoConfiguration(IPreferenceStore preferenceStore) {
        super(preferenceStore);
    }

    public AcceleoConfiguration(IPreferenceStore preferenceStore, IEclipsePreferences[] lookupOrder) {
        this(preferenceStore);
        this.lookupOrder = lookupOrder;
    }

    public AcceleoConfiguration(AcceleoEditor editor, IPreferenceStore preferenceStore) {
        this(preferenceStore);
        this.editor = editor;
    }

    protected AbstractAcceleoScanner[] getScanners() {
        if (this.scanners == null) {
            ArrayList<AbstractAcceleoScanner> list = new ArrayList<AbstractAcceleoScanner>();
            list.add(new AcceleoTemplateScanner(this.lookupOrder));
            list.add(new AcceleoQueryScanner(this.lookupOrder));
            list.add(new AcceleoMacroScanner(this.lookupOrder));
            list.add(new AcceleoForScanner(this.lookupOrder));
            list.add(new AcceleoIfScanner(this.lookupOrder));
            list.add(new AcceleoLetScanner(this.lookupOrder));
            list.add(new AcceleoProtectedAreaScanner(this.lookupOrder));
            list.add(new AcceleoCommentScanner(this.lookupOrder));
            list.add(new AcceleoDocumentationScanner(this.lookupOrder));
            list.add(new AcceleoBlockScanner(this.lookupOrder));
            list.add(new AcceleoDefaultScanner(this.lookupOrder));
            this.scanners = list.toArray(new AbstractAcceleoScanner[list.size()]);
        }
        return this.scanners;
    }

    public void adaptToPreferenceChanges(IEclipsePreferences.PreferenceChangeEvent event) {
        String preferenceKey = event.getKey();
        if (preferenceKey != null && preferenceKey.endsWith(".color")) {
            AbstractAcceleoScanner[] abstractAcceleoScannerArray = this.getScanners();
            int n = abstractAcceleoScannerArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractAcceleoScanner scanner = abstractAcceleoScannerArray[n2];
                List<AcceleoToken> affectedTokens = scanner.getAffectedToken(preferenceKey);
                for (AcceleoToken token : affectedTokens) {
                    AcceleoColor color = AcceleoColor.getColor(preferenceKey);
                    Color newColor = AcceleoColorManager.getColor(color, this.lookupOrder);
                    token.update(newColor);
                }
                ++n2;
            }
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        AbstractAcceleoScanner[] acceleoScanners = this.getScanners();
        String[] result = new String[acceleoScanners.length];
        int i = 0;
        while (i < acceleoScanners.length) {
            AbstractAcceleoScanner scanner = acceleoScanners[i];
            result[i] = scanner.getConfiguredContentType();
            ++i;
        }
        return result;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new DefaultTextDoubleClickStrategy(){

            public void doubleClicked(ITextViewer part) {
                Point point;
                super.doubleClicked(part);
                if (AcceleoConfiguration.this.editor != null && (point = part.getSelectedRange()) != null) {
                    int posBegin = point.x;
                    int posEnd = point.y;
                    AcceleoConfiguration.this.editor.updateSelection(posBegin, posEnd);
                }
            }

            protected IRegion findExtendedDoubleClickSelection(IDocument document, int offset) {
                IRegion region = OpenDeclarationUtils.findIdentifierRegion(document, offset);
                return region;
            }
        };
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        AbstractAcceleoScanner[] acceleoScanners = this.getScanners();
        int i = 0;
        while (i < acceleoScanners.length) {
            AbstractAcceleoScanner scanner = acceleoScanners[i];
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
            reconciler.setDamager((IPresentationDamager)dr, scanner.getConfiguredContentType());
            reconciler.setRepairer((IPresentationRepairer)dr, scanner.getConfiguredContentType());
            ++i;
        }
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        IContentAssistProcessor processor = this.createContentAssistProcessor(sourceViewer);
        AbstractAcceleoScanner[] acceleoScanners = this.getScanners();
        int i = 0;
        while (i < acceleoScanners.length) {
            AbstractAcceleoScanner scanner = acceleoScanners[i];
            if (scanner instanceof AcceleoDefaultScanner) {
                AcceleoCompletionProcessor defaultProcessor = (AcceleoCompletionProcessor)this.createContentAssistProcessor(sourceViewer);
                if (defaultProcessor != null) {
                    defaultProcessor.disableAutoActivation();
                    assistant.setContentAssistProcessor((IContentAssistProcessor)defaultProcessor, scanner.getConfiguredContentType());
                }
            } else if (!(scanner instanceof AcceleoCommentScanner) && !(scanner instanceof AcceleoDocumentationScanner)) {
                assistant.setContentAssistProcessor(processor, scanner.getConfiguredContentType());
            }
            ++i;
        }
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(1000);
        assistant.setProposalPopupOrientation(10);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return assistant;
    }

    public IContentAssistProcessor createContentAssistProcessor(ISourceViewer sourceViewer) {
        AcceleoCompletionProcessor processor = null;
        if (this.editor != null) {
            processor = new AcceleoCompletionProcessor(this.editor.getContent());
        } else if (sourceViewer.getDocument() != null) {
            AcceleoSourceContent content = new AcceleoSourceContent();
            content.init(new StringBuffer(sourceViewer.getDocument().get()));
            processor = new AcceleoCompletionProcessor(content);
        }
        return processor;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant assistant = new QuickAssistAssistant();
        assistant.setQuickAssistProcessor((IQuickAssistProcessor)new AcceleoQuickFixProcessor());
        assistant.setInformationControlCreator(this.getQuickAssistAssistantInformationControlCreator());
        return assistant;
    }

    private IInformationControlCreator getQuickAssistAssistantInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent);
            }
        };
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.editor != null) {
            return new AcceleoHover(this.editor);
        }
        return super.getAnnotationHover(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.editor != null) {
            return new AcceleoTextHover(this.editor);
        }
        return super.getTextHover(sourceViewer, contentType);
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.editor != null) {
            return new MonoReconciler((IReconcilingStrategy)new AcceleoTemplateReconcilingStrategy(this.editor), false);
        }
        return super.getReconciler(sourceViewer);
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        if (this.editor != null) {
            Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
            targets.put("org.eclipse.acceleo.ide.ui.AcceleoTemplateSource", this.editor);
            return targets;
        }
        return super.getHyperlinkDetectorTargets(sourceViewer);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new AcceleoHoverInformationControl(parent);
            }
        };
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if ("__ACCELEO_documentation".equals(contentType)) {
            return new IAutoEditStrategy[]{new AcceleoDocAutoIndentStrategy()};
        }
        return null;
    }
}

