/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.session.analysis;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ui.tools.api.dialogs.AnalysisSelectorFilteredItemsSelectionDialog;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SmartDialogAnalysisSelector
implements DAnalysisSelector {
    protected AnalysisSelectorFilteredItemsSelectionDialog dialog;

    public DAnalysis selectSmartlyAnalysisForAddedResource(Resource resource, Collection<DAnalysis> allAnalysis) {
        return this.selectSmartlyAnalysis(allAnalysis, null);
    }

    public DAnalysis selectSmartlyAnalysisForAddedRepresentation(DRepresentation representation, Collection<DAnalysis> allAnalysis) {
        DAnalysis selectSmartlyAnalysis = this.selectSmartlyAnalysis(allAnalysis, representation);
        if (selectSmartlyAnalysis == null) {
            selectSmartlyAnalysis = allAnalysis.iterator().next();
        }
        return selectSmartlyAnalysis;
    }

    protected DAnalysis selectSmartlyAnalysis(final Collection<DAnalysis> allAnalysis, final DRepresentation representation) {
        RunnableWithResult.Impl<Object> runnable = new RunnableWithResult.Impl<Object>(){

            public void run() {
                SmartDialogAnalysisSelector.this.dialog = SmartDialogAnalysisSelector.this.createAnalysisSelectorDialog(Display.getDefault().getActiveShell(), SmartDialogAnalysisSelector.this.getDefaultDAnalysis(allAnalysis, representation), allAnalysis, new ArrayList<DAnalysis>(allAnalysis), representation);
                SmartDialogAnalysisSelector.this.dialog.setSeparatorLabel(Messages.SmartDialogAnalysisSelector_otherFragments);
                String representationName = representation.getName();
                if (representationName != null && !representationName.isEmpty()) {
                    SmartDialogAnalysisSelector.this.dialog.setTitle(MessageFormat.format(Messages.SmartDialogAnalysisSelector_titleWithRepresentationName, representationName));
                    SmartDialogAnalysisSelector.this.dialog.setMessage(MessageFormat.format(Messages.SmartDialogAnalysisSelector_messageWithRepresentationName, representationName));
                } else {
                    SmartDialogAnalysisSelector.this.dialog.setTitle(Messages.SmartDialogAnalysisSelector_titleWithoutRepresentationName);
                    SmartDialogAnalysisSelector.this.dialog.setMessage(Messages.SmartDialogAnalysisSelector_messageWithoutRepresentationName);
                }
                SmartDialogAnalysisSelector.this.dialog.setMoveRepresentation(representation.eResource() != null);
                if (SmartDialogAnalysisSelector.this.dialog.open() == 0) {
                    if (SmartDialogAnalysisSelector.this.dialog.getFirstResult() != null) {
                        this.setResult(SmartDialogAnalysisSelector.this.dialog.getFirstResult());
                    }
                } else {
                    this.setResult(null);
                }
            }
        };
        EclipseUIUtil.displaySyncExec((Runnable)runnable);
        return (DAnalysis)runnable.getResult();
    }

    protected DAnalysis getDefaultDAnalysis(Collection<DAnalysis> allAnalysis, DRepresentation representation) {
        DAnalysis defaultDAnalysis = null;
        if (allAnalysis.size() > 0) {
            EObject targetElement = ((DSemanticDecorator)representation).getTarget();
            Resource targetResource = targetElement.eResource();
            for (DAnalysis candidateAnalysis : allAnalysis) {
                for (EObject semanticElement : candidateAnalysis.getModels()) {
                    if (!targetResource.equals(semanticElement.eResource())) continue;
                    return candidateAnalysis;
                }
            }
            defaultDAnalysis = allAnalysis.iterator().next();
        }
        return defaultDAnalysis;
    }

    protected AnalysisSelectorFilteredItemsSelectionDialog createAnalysisSelectorDialog(Shell shell, DAnalysis bestCandidate, Collection<DAnalysis> allAnalysis, List<DAnalysis> bestCandidates, DRepresentation representation) {
        return new AnalysisSelectorFilteredItemsSelectionDialog(Display.getDefault().getActiveShell(), allAnalysis.iterator().next(), allAnalysis, new ArrayList<DAnalysis>(allAnalysis), false);
    }
}

