/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class DragDropEditPolicy
extends GraphicalEditPolicy {
    private static final Color GRAY = new Color(null, 200, 200, 200);
    protected Color revertColor;
    protected boolean opacity;

    public Command getCommand(Request request) {
        if ("drag".equals(request.getType())) {
            return this.getDragCommand((ChangeBoundsRequest)request);
        }
        if ("drop".equals(request.getType())) {
            return this.getDropCommand((ChangeBoundsRequest)request);
        }
        if ("drop_objects".equals(request.getType())) {
            DropObjectsRequest dndRequest = (DropObjectsRequest)request;
            dndRequest.setRequiredDetail(this.getRequiredDragDetail(dndRequest));
            return this.getDropObjectsCommand(dndRequest);
        }
        return null;
    }

    protected Command getDragCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"orphan");
        req.setEditParts(request.getEditParts());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setResizeDirection(request.getResizeDirection());
        return this.getHost().getCommand((Request)req);
    }

    protected Command getDropCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"add children");
        req.setEditParts(request.getEditParts());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setResizeDirection(request.getResizeDirection());
        Command cmd = this.getHost().getCommand((Request)req);
        if (cmd == null || !cmd.canExecute()) {
            return this.getDropObjectsCommand(this.castToDropObjectsRequest(request));
        }
        return cmd;
    }

    protected Command getDropElementCommand(EObject element, DropObjectsRequest request) {
        return null;
    }

    protected Command getDropObjectsCommand(DropObjectsRequest request) {
        CompoundCommand cm = new CompoundCommand();
        for (Object obj : request.getObjects()) {
            Command cmd;
            if (!(obj instanceof EObject) || (cmd = this.getDropElementCommand((EObject)obj, request)) == null) continue;
            cm.add(cmd);
        }
        if (cm.isEmpty()) {
            return null;
        }
        return new ICommandProxy((ICommand)new CommandProxy(cm.unwrap()));
    }

    public EditPart getTargetEditPart(Request request) {
        return this.understandsRequest(request) ? this.getHost() : null;
    }

    public boolean understandsRequest(Request request) {
        return "move".equals(request.getType()) || "drag".equals(request.getType()) || "drop".equals(request.getType()) || "drop_objects".equals(request.getType());
    }

    public void showTargetFeedback(Request request) {
        Command c = this.getCommand(request);
        if (c != null && c.canExecute() && this.revertColor == null) {
            this.revertColor = this.getHostFigure().getBackgroundColor();
            this.opacity = this.getHostFigure().isOpaque();
            this.getHostFigure().setBackgroundColor(FigureUtilities.mixColors((Color)GRAY, (Color)this.revertColor));
            this.getHostFigure().setOpaque(true);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if (this.revertColor != null) {
            this.getHostFigure().setBackgroundColor(this.revertColor);
            this.getHostFigure().setOpaque(this.opacity);
            this.revertColor = null;
        }
    }

    protected int getRequiredDragDetail(Request request) {
        return 1;
    }

    protected EObject getHostObject() {
        return ViewUtil.resolveSemanticElement((View)((View)((IGraphicalEditPart)this.getHost()).getModel()));
    }

    protected DropObjectsRequest castToDropObjectsRequest(ChangeBoundsRequest request) {
        Iterator editParts = ToolUtilities.getSelectionWithoutDependants((List)request.getEditParts()).iterator();
        ArrayList<EObject> elements = new ArrayList<EObject>();
        while (editParts.hasNext()) {
            EObject element;
            EditPart editPart = (EditPart)editParts.next();
            if (!(editPart instanceof IGraphicalEditPart) || (element = ViewUtil.resolveSemanticElement((View)((View)((IGraphicalEditPart)editPart).getModel()))) == null) continue;
            elements.add(element);
        }
        DropObjectsRequest req = new DropObjectsRequest();
        req.setObjects(elements);
        req.setAllowedDetail(7);
        req.setLocation(request.getLocation());
        req.setRequiredDetail(this.getRequiredDragDetail((Request)request));
        return req;
    }
}

