/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.impl;

import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.ExpressionsPackage;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.impl.FeatureCallExpImpl;
import org.eclipse.ocl.expressions.operations.OperationCallExpOperations;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationCallExpImpl<C, O>
extends FeatureCallExpImpl<C>
implements OperationCallExp<C, O> {
    protected EList<OCLExpression<C>> argument;
    protected O referredOperation;
    protected static final int OPERATION_CODE_EDEFAULT = 0;
    private int operationCode = -1;

    protected OperationCallExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ExpressionsPackage.Literals.OPERATION_CALL_EXP;
    }

    @Override
    public EList<OCLExpression<C>> getArgument() {
        if (this.argument == null) {
            this.argument = new EObjectContainmentEList(OCLExpression.class, (InternalEObject)this, 6);
        }
        return this.argument;
    }

    @Override
    public O getReferredOperation() {
        if (this.referredOperation != null && ((EObject)this.referredOperation).eIsProxy()) {
            InternalEObject oldReferredOperation = (InternalEObject)this.referredOperation;
            this.referredOperation = this.eResolveProxy(oldReferredOperation);
            if (this.referredOperation != oldReferredOperation && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 7, (Object)oldReferredOperation, this.referredOperation));
            }
        }
        return this.referredOperation;
    }

    public O basicGetReferredOperation() {
        return this.referredOperation;
    }

    @Override
    public void setReferredOperation(O newReferredOperation) {
        O oldReferredOperation = this.referredOperation;
        this.referredOperation = newReferredOperation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldReferredOperation, this.referredOperation));
        }
    }

    @Override
    public int getOperationCode() {
        if (this.operationCode < 0) {
            if (this.getSource() != null && this.getReferredOperation() != null) {
                Environment env = Environment.Registry.INSTANCE.getEnvironmentFor(this.getSource());
                Object type = this.getSource().getType();
                if (env != null) {
                    String operName = env.getUMLReflection().getName(this.getReferredOperation());
                    if (type instanceof PredefinedType) {
                        this.operationCode = OCLStandardLibraryUtil.getOperationCode(operName);
                    } else if (TypeUtil.isOclAnyOperation(env, this.getReferredOperation())) {
                        this.operationCode = OCLStandardLibraryUtil.getOclAnyOperationCode(operName);
                    }
                }
            } else {
                this.operationCode = 0;
            }
        }
        return this.operationCode;
    }

    @Override
    public void setOperationCode(int newOperationCode) {
        this.operationCode = newOperationCode;
    }

    @Override
    public boolean checkArgumentsConform(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return OperationCallExpOperations.checkArgumentsConform(this, diagnostics, context);
    }

    @Override
    public boolean checkArgumentCount(DiagnosticChain diagnostics, Map<Object, Object> context) {
        return OperationCallExpOperations.checkArgumentCount(this, diagnostics, context);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getArgument()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getArgument();
            }
            case 7: {
                if (resolve) {
                    return this.getReferredOperation();
                }
                return this.basicGetReferredOperation();
            }
            case 8: {
                return this.getOperationCode();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.getArgument().clear();
                this.getArgument().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.setReferredOperation(newValue);
                return;
            }
            case 8: {
                this.setOperationCode((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.getArgument().clear();
                return;
            }
            case 7: {
                this.setReferredOperation(null);
                return;
            }
            case 8: {
                this.setOperationCode(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.argument != null && !this.argument.isEmpty();
            }
            case 7: {
                return this.referredOperation != null;
            }
            case 8: {
                return this.getOperationCode() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public <T, U extends Visitor<T, ?, ?, ?, ?, ?, ?, ?, ?, ?>> T accept(U v) {
        return v.visitOperationCallExp(this);
    }
}

