/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.dialogs;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.SessionLabelProvider;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;

public class AnalysisSelectorFilteredItemsSelectionDialog
extends FilteredItemsSelectionDialog {
    public static final String DIALOG_SETTINGS_ID = "MoveRepresentations";
    protected String helpMessage = Messages.AnalysisSelectorFilteredItemsSelectionDialog_helpMessage;
    protected boolean allowCancel;
    private final DAnalysis bestCandidate;
    private final Collection<DAnalysis> allAnalysis;
    private final List<DAnalysis> bestCandidates;
    private final ILabelProvider labelProvider;

    public AnalysisSelectorFilteredItemsSelectionDialog(Shell shell, DAnalysis bestCandidate, Collection<DAnalysis> allAnalysis, List<DAnalysis> bestCandidates, boolean allowCancel) {
        super(shell);
        this.bestCandidate = bestCandidate;
        this.allAnalysis = allAnalysis;
        this.bestCandidates = bestCandidates;
        this.labelProvider = this.getLocationLabelProvider();
        this.setHelpAvailable(true);
        this.setDetailsLabelProvider(this.labelProvider);
        this.setListLabelProvider(this.labelProvider);
        this.setInitialSelections(new Object[]{bestCandidate});
        this.allowCancel = allowCancel;
    }

    protected ILabelProvider getLocationLabelProvider() {
        return new SessionLabelProvider(ViewHelper.INSTANCE.createAdapterFactory()){

            @Override
            public String getText(Object object) {
                String result;
                if (object instanceof DAnalysis) {
                    DAnalysis dAnalysis = (DAnalysis)object;
                    String decodedURIPath = URI.decode((String)dAnalysis.eResource().getURI().path());
                    result = dAnalysis.eResource().getURI().isPlatformResource() ? MessageFormat.format(Messages.AnalysisSelectorFilteredItemsSelectionDialog_labelProviderLocal, decodedURIPath.replace("/resource/", "/")) : String.valueOf(Messages.AnalysisSelectorFilteredItemsSelectionDialog_labelProviderDefault) + decodedURIPath;
                } else {
                    result = super.getText(object);
                }
                return result;
            }
        };
    }

    protected Control createContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        Composite composite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)layout)).layoutData((Object)new GridData(1808))).create((Widget)parent);
        this.createHeaderMessagePart(composite);
        AnalysisSelectorFilteredItemsSelectionDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        this.dialogArea = this.createDialogArea(composite);
        this.buttonBar = this.createButtonBar(composite);
        parent.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                String title = "Help: Move representation";
                MessageDialog dialog = new MessageDialog(activeShell, title, null, AnalysisSelectorFilteredItemsSelectionDialog.this.getHelpMessage(), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        });
        return parent;
    }

    protected void createHeaderMessagePart(Composite parent) {
    }

    protected String getHelpMessage() {
        return this.helpMessage;
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.allowCancel) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = SiriusEditPlugin.getPlugin().getDialogSettings();
        if ((settings = settings.getSection(DIALOG_SETTINGS_ID)) == null) {
            settings = SiriusEditPlugin.getPlugin().getDialogSettings().addNewSection(DIALOG_SETTINGS_ID);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new FilteredItemsSelectionDialog.ItemsFilter(this){

            public String getPattern() {
                String pattern = super.getPattern();
                if (pattern == null || pattern.length() == 0) {
                    return "*";
                }
                return pattern;
            }

            public boolean matchItem(Object item) {
                URI fileUri;
                DAnalysis analysis;
                Resource resource;
                boolean result = false;
                if (this.patternMatcher.matches(AnalysisSelectorFilteredItemsSelectionDialog.this.labelProvider.getText(item))) {
                    result = true;
                }
                if (!result && item instanceof DAnalysis && (resource = (analysis = (DAnalysis)item).eResource()) != null && resource.getURI() != null && (fileUri = resource.getURI()).lastSegment() != null && this.patternMatcher.matches(fileUri.lastSegment())) {
                    result = true;
                }
                return result;
            }

            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    protected Comparator<Object> getItemsComparator() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1.equals(AnalysisSelectorFilteredItemsSelectionDialog.this.bestCandidate)) {
                    return -2;
                }
                return o2.equals(AnalysisSelectorFilteredItemsSelectionDialog.this.bestCandidate) ? 2 : AnalysisSelectorFilteredItemsSelectionDialog.this.labelProvider.getText(o1).compareTo(AnalysisSelectorFilteredItemsSelectionDialog.this.labelProvider.getText(o2));
            }
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        for (DAnalysis element : this.allAnalysis) {
            contentProvider.add((Object)element, itemsFilter);
        }
    }

    protected void storeDialog(IDialogSettings settings) {
        super.storeDialog(settings);
    }

    protected void restoreDialog(IDialogSettings settings) {
        this.setSelectionHistory(new FilteredItemsSelectionDialog.SelectionHistory(){

            protected Object restoreItemFromMemento(IMemento memento) {
                return null;
            }

            protected void storeItemToMemento(Object item, IMemento memento) {
            }
        });
        super.restoreDialog(settings);
        if (this.bestCandidates != null) {
            for (DAnalysis object : this.bestCandidates) {
                this.accessedHistoryItem(object);
            }
        }
    }

    public String getElementName(Object item) {
        return this.labelProvider.getText(item);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(0x10830 | AnalysisSelectorFilteredItemsSelectionDialog.getDefaultOrientation());
    }
}

