/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.CombinedFragmentResizeValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.InteractionUseResizeValidator;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.PositionsChecker;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;

public abstract class AbstractInteractionFrameValidator {
    private static final String FRAME_RESIZE_VALIDATOR = "org.eclipse.sirius.sequence.resize.frame.validator";
    protected Range expansionZone = Range.emptyRange();
    protected final AbstractFrame frame;
    protected Range finalRange;
    protected Range initialRange;
    protected int defaultFrameHeight;
    protected boolean valid = true;
    protected final Set<ISequenceEvent> movedElements = new HashSet<ISequenceEvent>();
    protected final Predicate<ISequenceEvent> unmoved = Predicates.not((Predicate)Predicates.in(this.movedElements));
    private boolean initialized;
    private final Collection<Integer> invalidPositions = new ArrayList<Integer>();
    private Predicate<Object> unMove = Predicates.instanceOf(Lifeline.class);
    private Predicate<Object> invalidParents;
    private Function<ISequenceEvent, Range> futureRangeFunction = new Function<ISequenceEvent, Range>(){

        public Range apply(ISequenceEvent from) {
            Range range = from.getVerticalRange();
            if (AbstractInteractionFrameValidator.this.frame.equals((Object)from)) {
                range = AbstractInteractionFrameValidator.this.finalRange;
            } else if (AbstractInteractionFrameValidator.this.expansionZone != null && !AbstractInteractionFrameValidator.this.expansionZone.isEmpty()) {
                if (range.includes(AbstractInteractionFrameValidator.this.expansionZone.getLowerBound())) {
                    range = new Range(range.getLowerBound(), range.getUpperBound() + AbstractInteractionFrameValidator.this.expansionZone.width());
                } else if (range.getLowerBound() >= AbstractInteractionFrameValidator.this.expansionZone.getLowerBound()) {
                    range = range.shifted(AbstractInteractionFrameValidator.this.expansionZone.width());
                }
            }
            return range;
        }
    };
    private final RequestQuery requestQuery;

    public AbstractInteractionFrameValidator(AbstractFrame frame, RequestQuery requestQuery) {
        this.frame = frame;
        this.requestQuery = requestQuery;
        this.valid = false;
        this.invalidParents = Predicates.or((Predicate)Predicates.instanceOf(AbstractFrame.class), (Predicate)Predicates.instanceOf(State.class));
    }

    public final boolean isValid() {
        if (!this.initialized) {
            this.validate();
            this.initialized = true;
        }
        return this.valid;
    }

    public Range getFinalRange() {
        return this.finalRange;
    }

    protected void validate() {
        this.valid = this.checkAndComputeRanges();
        if (this.valid) {
            Collection<ISequenceEvent> finalParents = this.getFinalParentsWithAutoExpand();
            ArrayList movableParents = Lists.newArrayList((Iterable)Iterables.filter(finalParents, (Predicate)Predicates.not(this.unMove)));
            ArrayList fixedParents = Lists.newArrayList((Iterable)Iterables.filter(finalParents, this.unMove));
            if (movableParents.isEmpty() || !this.movedElements.containsAll(movableParents)) {
                this.valid = this.valid && Iterables.isEmpty((Iterable)Iterables.filter(finalParents, this.invalidParents));
                this.valid = this.valid && (!Iterables.any(finalParents, (Predicate)Predicates.instanceOf(Operand.class)) || finalParents.size() == 1);
                this.valid = this.valid && this.checkFinalRangeStrictlyIncludedInParents(movableParents);
                this.valid = this.valid && this.checkLocalSiblings(movableParents);
            }
            this.valid = this.valid && this.checkFinalRangeStrictlyIncludedInParents(fixedParents);
            boolean bl = this.valid = this.valid && this.checkLocalSiblings(fixedParents);
        }
        if (this.getRequestQuery().isResize()) {
            this.valid = this.valid && this.checkGlobalPositions();
        }
    }

    private Collection<ISequenceEvent> getFinalParentsWithAutoExpand() {
        ArrayList<ISequenceEvent> finalParentsWithAutoExpand = new ArrayList<ISequenceEvent>();
        Collection<ISequenceEvent> finalParents = this.getFinalParents();
        Collection coveredLifelines = this.frame.computeCoveredLifelines();
        for (ISequenceEvent localParent : finalParents) {
            if (localParent == null) continue;
            if (!this.movedElements.contains(localParent) && !localParent.canChildOccupy((ISequenceEvent)this.frame, this.finalRange, new ArrayList<ISequenceEvent>(this.movedElements), coveredLifelines)) {
                this.expansionZone = this.computeExpansionZone();
            }
            finalParentsWithAutoExpand.add(localParent);
        }
        return finalParentsWithAutoExpand;
    }

    private boolean checkAndComputeRanges() {
        this.initialRange = this.frame.getVerticalRange();
        Rectangle newBounds = this.getResizedBounds(new Rectangle(0, this.initialRange.getLowerBound(), 0, this.initialRange.width()));
        if (newBounds.height < this.defaultFrameHeight) {
            this.finalRange = this.initialRange;
            return false;
        }
        this.finalRange = RangeHelper.verticalRange((Rectangle)newBounds);
        return true;
    }

    private boolean checkFinalRangeStrictlyIncludedInParents(Collection<ISequenceEvent> parentEvents) {
        boolean checked = true;
        Iterable unMovedParents = Iterables.filter(parentEvents, this.unmoved);
        Iterator iterator = unMovedParents.iterator();
        while (checked && iterator.hasNext()) {
            ISequenceEvent parent = (ISequenceEvent)iterator.next();
            Range parentRange = parent.getVerticalRange();
            if (this.expansionZone != null && !this.expansionZone.isEmpty()) {
                parentRange = new Range(parentRange.getLowerBound(), parentRange.getUpperBound() + this.expansionZone.width());
            }
            boolean interactionInRange = parentRange.includes(this.finalRange.grown(5));
            boolean bl = checked = checked && interactionInRange;
        }
        return checked;
    }

    protected abstract Collection<ISequenceEvent> getFinalParents();

    private boolean checkLocalSiblings(Collection<ISequenceEvent> finalParents) {
        boolean okForSiblings = true;
        for (ISequenceEvent localParent : finalParents) {
            for (ISequenceEvent localSibling : Iterables.filter((Iterable)localParent.getSubEvents(), this.unmoved)) {
                if (!this.frame.equals((Object)localSibling) && !(okForSiblings = this.checkSibling(localSibling))) break;
            }
            if (!okForSiblings) break;
        }
        return okForSiblings;
    }

    private boolean checkSibling(ISequenceEvent sibling) {
        Range siblingRange = sibling.getVerticalRange();
        if (this.canExpand()) {
            if (this.expansionZone != null && !this.expansionZone.isEmpty()) {
                siblingRange = this.getExpandedRange(siblingRange);
            } else if (siblingRange.intersects(this.finalRange)) {
                this.expansionZone = this.computeExpansionZone();
                siblingRange = this.getExpandedRange(siblingRange);
            }
        }
        return !siblingRange.intersects(this.finalRange);
    }

    private Range getExpandedRange(Range siblingRange) {
        if (this.expansionZone != null && !this.expansionZone.isEmpty() && siblingRange.intersects(this.expansionZone)) {
            return siblingRange.shifted(this.expansionZone.width());
        }
        return siblingRange;
    }

    private Rectangle getResizedBounds(Rectangle bounds) {
        return this.getRequestQuery().getLogicalTransformedRectangle(bounds);
    }

    public Range getExpansionZone() {
        return this.canExpand() && this.expansionZone != null ? this.expansionZone : Range.emptyRange();
    }

    protected abstract boolean canExpand();

    protected abstract Range computeExpansionZone();

    public void setMovedElements(Collection<ISequenceEvent> otherMovedElements) {
        if (otherMovedElements != null && !otherMovedElements.isEmpty()) {
            this.movedElements.addAll(otherMovedElements);
        }
    }

    public static AbstractInteractionFrameValidator getOrCreateResizeValidator(ChangeBoundsRequest cbr, AbstractFrame host) {
        RequestQuery requestQuery = new RequestQuery((Request)cbr);
        Preconditions.checkArgument((boolean)requestQuery.isResize());
        AbstractInteractionFrameValidator validator = null;
        Object object = cbr.getExtendedData().get(FRAME_RESIZE_VALIDATOR);
        if (object instanceof AbstractInteractionFrameValidator && !(validator = (AbstractInteractionFrameValidator)object).getRequestQuery().getLogicalDelta().equals((Object)requestQuery.getLogicalDelta())) {
            validator = null;
        }
        if (validator == null && requestQuery.isResize()) {
            if (host instanceof CombinedFragment) {
                validator = new CombinedFragmentResizeValidator((CombinedFragment)host, requestQuery);
            } else if (host instanceof InteractionUse) {
                validator = new InteractionUseResizeValidator((InteractionUse)host, requestQuery);
            }
            cbr.getExtendedData().put(FRAME_RESIZE_VALIDATOR, validator);
        }
        return validator;
    }

    public Collection<Integer> getInvalidPositions() {
        return this.invalidPositions;
    }

    private boolean checkGlobalPositions() {
        boolean safeMove = true;
        this.invalidPositions.addAll(new PositionsChecker(this.frame.getDiagram(), this.futureRangeFunction).getInvalidPositions());
        safeMove = this.invalidPositions.isEmpty();
        return safeMove;
    }

    public RequestQuery getRequestQuery() {
        return this.requestQuery;
    }
}

