/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.tool.groupmenu;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.editor.properties.sections.common.AbstractTextPropertySection;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class GroupMenuLocationURIPropertySection
extends AbstractTextPropertySection {
    protected CLabel help;

    @Override
    public void refresh() {
        super.refresh();
        String tooltip = this.getToolTipText();
        if (tooltip != null && this.help != null) {
            this.help.setToolTipText(this.getToolTipText());
        }
    }

    @Override
    protected String getDefaultLabelText() {
        return "LocationURI";
    }

    @Override
    protected String getLabelText() {
        String labelText = String.valueOf(super.getLabelText()) + ":";
        return labelText;
    }

    @Override
    public EAttribute getFeature() {
        return ToolPackage.eINSTANCE.getGroupMenu_LocationURI();
    }

    @Override
    protected Object getFeatureValue(String newText) {
        return newText;
    }

    @Override
    protected boolean isEqual(String newText) {
        return this.getFeatureAsText().equals(newText);
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.text.setToolTipText(this.getToolTipText());
        this.help = this.getWidgetFactory().createCLabel(this.composite, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.text, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        this.help.setLayoutData((Object)data);
        this.help.setImage(this.getHelpIcon());
        this.help.setToolTipText(this.getToolTipText());
    }

    @Override
    protected String getPropertyDescription() {
        return "A URI specification that defines the insertion point at which the group will be added. The format for the URI is comprised of two basic parts:\n* Scheme: One of \"menu\", \"tabbar\". Indicates the type of the manager used to handle the contributions.\n* Id: This is either the id of an existing menu or tabbar menu";
    }
}

