/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.SelectConnectionEndRequest;
import org.eclipse.ui.IWorkbenchPage;

public class SelectConnectionEndAction
extends DiagramAction {
    private boolean isSource = false;

    protected Request createTargetRequest() {
        return new SelectConnectionEndRequest(this.isSource);
    }

    static SelectConnectionEndAction createSelectConnectionSourceAction(IWorkbenchPage workbenchPage) {
        return new SelectConnectionEndAction(workbenchPage, true);
    }

    static SelectConnectionEndAction createSelectConnectionTargetAction(IWorkbenchPage workbenchPage) {
        return new SelectConnectionEndAction(workbenchPage, false);
    }

    public SelectConnectionEndAction(IWorkbenchPage workbenchPage, boolean source) {
        super(workbenchPage);
        this.isSource = source;
        if (this.isSource) {
            this.setText(DiagramUIActionsMessages.SelectConnectionEndAction_SelectSource_ActionLabelText);
            this.setText(DiagramUIActionsMessages.SelectConnectionEndAction_SelectSource_ActionToolTipText);
        } else {
            this.setText(DiagramUIActionsMessages.SelectConnectionEndAction_SelectTarget_ActionLabelText);
            this.setText(DiagramUIActionsMessages.SelectConnectionEndAction_SelectTarget_ActionToolTipText);
        }
    }

    protected boolean isSelectionListener() {
        return false;
    }

    protected boolean calculateEnabled() {
        List operationSet = this.getOperationSet();
        return operationSet.size() == 1;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        List operationSet = this.getOperationSet();
        if (operationSet.isEmpty()) {
            return;
        }
        ConnectionEditPart connectionEditPart = (ConnectionEditPart)operationSet.get(0);
        EditPart editPartToSelect = null;
        editPartToSelect = this.isSource ? connectionEditPart.getSource() : connectionEditPart.getTarget();
        editPartToSelect.getViewer().reveal(editPartToSelect);
        editPartToSelect.getViewer().select(editPartToSelect);
    }

    protected List getTargetEditParts(EditPart editpart) {
        return Collections.singletonList(editpart);
    }
}

