/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.PrintPiece;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.ResourcePool;
import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

class BackgroundPiece
implements PrintPiece {
    private final PrintPiece target;
    private final Device device;
    private final RGB background;

    BackgroundPiece(PrintPiece target, RGB background, Device device) {
        Util.notNull(target, background, device);
        this.target = target;
        this.device = device;
        this.background = background;
    }

    @Override
    public Point getSize() {
        return this.target.getSize();
    }

    @Override
    public void paint(GC gc, int x, int y) {
        this.paintBackground(gc, x, y);
        this.target.paint(gc, x, y);
    }

    private void paintBackground(GC gc, int x, int y) {
        Color oldBackground = gc.getBackground();
        gc.setBackground(ResourcePool.forDevice(this.device).getColor(this.background));
        Point size = this.getSize();
        gc.fillRectangle(x, y, size.x, size.y);
        gc.setBackground(oldBackground);
    }

    @Override
    public void dispose() {
        this.target.dispose();
    }
}

