/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.launching.sourcelookup.advanced;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.AdvancedSourceLookupSupport;
import org.eclipse.jdt.internal.launching.sourcelookup.advanced.IJDIHelpers;

public class AdvancedSourceLookup {
    private static final IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();

    public static boolean isSourceProject(IJavaProject project) throws JavaModelException {
        IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot fragment = iPackageFragmentRootArray[n2];
            if (fragment.getKind() == 1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Map<File, IPackageFragmentRoot> getClasspath(IJavaProject project) throws JavaModelException {
        LinkedHashMap<File, IPackageFragmentRoot> classpath = new LinkedHashMap<File, IPackageFragmentRoot>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot fragment = iPackageFragmentRootArray[n2];
            if (fragment.getKind() == 2) {
                File classpathLocation = null;
                if (fragment.isExternal()) {
                    classpathLocation = fragment.getPath().toFile();
                } else {
                    IPath location;
                    IResource resource = fragment.getResource();
                    if (resource != null && (location = resource.getLocation()) != null) {
                        classpathLocation = location.toFile();
                    }
                }
                if (classpathLocation != null) {
                    classpath.put(classpathLocation, fragment);
                }
            }
            ++n2;
        }
        return classpath;
    }

    public static Set<File> getOutputDirectories(IJavaProject project) throws JavaModelException {
        LinkedHashSet<File> locations = new LinkedHashSet<File>();
        AdvancedSourceLookup.addWorkspaceLocation(locations, project.getOutputLocation());
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            if (cpe.getEntryKind() == 3 && cpe.getOutputLocation() != null) {
                AdvancedSourceLookup.addWorkspaceLocation(locations, cpe.getOutputLocation());
            }
            ++n2;
        }
        return locations;
    }

    private static void addWorkspaceLocation(Collection<File> locations, IPath workspacePath) {
        IResource resource = root.findMember(workspacePath);
        if (resource == null) {
            return;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return;
        }
        locations.add(location.toFile());
    }

    public static String getJavaagentString() {
        return AdvancedSourceLookupSupport.getJavaagentString();
    }

    public static File getClassesLocation(Object fElement) throws DebugException {
        return IJDIHelpers.INSTANCE.getClassesLocation(fElement);
    }

    public static IPersistableSourceLocator createSourceLocator(String type, ILaunchConfiguration configuration) throws CoreException {
        return AdvancedSourceLookupSupport.createSourceLocator(type, configuration);
    }
}

