/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.refresh;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.VerticalPositionFunction;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.layout.LayoutConstants;
import org.eclipse.sirius.diagram.sequence.business.internal.operation.SetVerticalRangeOperation;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceElementQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.query.RangeComparator;
import org.eclipse.sirius.diagram.sequence.business.internal.query.SequenceDiagramQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.FixBendpointsOnCreationCommand;
import org.eclipse.sirius.diagram.sequence.business.internal.refresh.SequenceCanonicalSynchronizerAdapterScope;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class SequenceCanonicalSynchronizerAdapter
implements ModelChangeTrigger {
    public static final int SEQUENCE_CANONICAL_REFRESH_PRIORITY = 6;

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        CompoundCommand compoundCommand = new CompoundCommand();
        for (Notification notification : notifications) {
            Edge newEdge;
            Command fixBendpointsForSequenceMessageCmd;
            Object newValue = notification.getNewValue();
            if (SequenceCanonicalSynchronizerAdapterScope.isNotificationForNodeAdding(notification)) {
                Node newNode = (Node)newValue;
                this.cancelArrangeNewNodeCommandforSequenceDiagram(newNode);
                Command fixSequenceNodeLowerBoundCmd = this.getFixSequenceNodeCreationRangeCmd(newNode);
                if (fixSequenceNodeLowerBoundCmd == null) continue;
                compoundCommand.append(fixSequenceNodeLowerBoundCmd);
                continue;
            }
            if (!SequenceCanonicalSynchronizerAdapterScope.isNotificationForEdgeAdding(notification) || (fixBendpointsForSequenceMessageCmd = this.getFixBendpointsForSequenceMessageCmd(newEdge = (Edge)newValue)) == null) continue;
            compoundCommand.append(fixBendpointsForSequenceMessageCmd);
        }
        CompoundCommand cmd = compoundCommand;
        Option result = Options.newSome((Object)cmd);
        return result;
    }

    private void cancelArrangeNewNodeCommandforSequenceDiagram(Node newNode) {
        Diagram diagram = newNode.getDiagram();
        if (diagram != null && ISequenceElementAccessor.getSequenceDiagram(diagram).some()) {
            Set set2;
            Map viewToArrangeCenter = SiriusLayoutDataManager.INSTANCE.getCreatedViewWithCenterLayout();
            Map viewToArrange = SiriusLayoutDataManager.INSTANCE.getCreatedViewsToLayout();
            Set set = (Set)viewToArrange.get(diagram);
            if (set != null) {
                set.clear();
            }
            if ((set2 = (Set)viewToArrangeCenter.get(diagram)) != null) {
                set2.clear();
            }
        }
    }

    private Command getFixSequenceNodeCreationRangeCmd(Node newNode) {
        Command fixSequenceNodeLowerBoundCmd = null;
        EObject element = newNode.getElement();
        EObject eContainer = element.eContainer();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)newNode);
        if (eContainer instanceof AbstractDNode && ISequenceElementAccessor.getISequenceNode((View)newNode).some()) {
            AbstractDNode containerDNode = (AbstractDNode)eContainer;
            if (containerDNode.getOwnedBorderedNodes().contains((Object)element) && element instanceof AbstractDNode) {
                AbstractDNode borderedDNode = (AbstractDNode)element;
                LayoutData layoutData = null;
                SiriusLayoutDataManager.INSTANCE.setIgnoreConsumeState(true);
                try {
                    layoutData = SiriusLayoutDataManager.INSTANCE.getData(borderedDNode, true);
                }
                finally {
                    SiriusLayoutDataManager.INSTANCE.setIgnoreConsumeState(false);
                }
                if (layoutData != null) {
                    Point location = layoutData.getLocation();
                    int y = location.y;
                    fixSequenceNodeLowerBoundCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.LOCATION__Y, (Object)y);
                    Dimension size = layoutData.getSize();
                    if (size != null && newNode.getLayoutConstraint() instanceof Size) {
                        fixSequenceNodeLowerBoundCmd = this.addSetSizeCmd(fixSequenceNodeLowerBoundCmd, domain, size, newNode);
                    }
                    this.expandSimpleExecution(newNode, fixSequenceNodeLowerBoundCmd, domain, y);
                } else {
                    fixSequenceNodeLowerBoundCmd = this.getFlaggedRangeApplicationCommand((View)newNode, domain);
                }
            } else {
                Option<Operand> operandOption = ISequenceElementAccessor.getOperand((View)newNode);
                if (operandOption.some()) {
                    Command resetOperandHeightCmd;
                    fixSequenceNodeLowerBoundCmd = resetOperandHeightCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.SIZE__HEIGHT, (Object)-1);
                    Command resetOperandWidthCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.SIZE__WIDTH, (Object)-1);
                    fixSequenceNodeLowerBoundCmd = fixSequenceNodeLowerBoundCmd.chain(resetOperandWidthCmd);
                }
            }
        } else {
            Option<CombinedFragment> combinedFragmentOption = ISequenceElementAccessor.getCombinedFragment((View)newNode);
            if (combinedFragmentOption.some() && ((Bounds)newNode.getLayoutConstraint()).getHeight() == 90) {
                Command resetCombinedFragmentHeightCmd;
                fixSequenceNodeLowerBoundCmd = resetCombinedFragmentHeightCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.SIZE__HEIGHT, (Object)-1);
                Command resetCombinedFragmentWidthCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.SIZE__WIDTH, (Object)-1);
                fixSequenceNodeLowerBoundCmd = fixSequenceNodeLowerBoundCmd.chain(resetCombinedFragmentWidthCmd);
            } else {
                Option<InteractionUse> interactionUseOption = ISequenceElementAccessor.getInteractionUse((View)newNode);
                if (interactionUseOption.some() && ((Bounds)newNode.getLayoutConstraint()).getHeight() == 50) {
                    Command resetInteractionUseHeightCmd;
                    fixSequenceNodeLowerBoundCmd = resetInteractionUseHeightCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.SIZE__HEIGHT, (Object)-1);
                    Command resetInteractionUseWidthCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.SIZE__WIDTH, (Object)-1);
                    fixSequenceNodeLowerBoundCmd = fixSequenceNodeLowerBoundCmd.chain(resetInteractionUseWidthCmd);
                }
            }
        }
        return fixSequenceNodeLowerBoundCmd;
    }

    private Command addSetSizeCmd(Command globalCmd, TransactionalEditingDomain domain, Dimension size, Node newNode) {
        Command result = null;
        LayoutConstraint createdNodeLayoutConstraint = newNode.getLayoutConstraint();
        if (createdNodeLayoutConstraint instanceof Size) {
            int width = size.width;
            int height = size.height;
            if (newNode.getElement() instanceof DDiagramElement && new DDiagramElementQuery((DDiagramElement)newNode.getElement()).isCollapsed()) {
                DDiagramElement dde = (DDiagramElement)newNode.getElement();
                CollapseFilter filter = (CollapseFilter)Iterables.filter((Iterable)dde.getGraphicalFilters(), CollapseFilter.class).iterator().next();
                Command setFilterHeightCmd = SetCommand.create((EditingDomain)domain, (Object)filter, (Object)DiagramPackage.Literals.COLLAPSE_FILTER__HEIGHT, (Object)height);
                Command setHeightCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.SIZE__HEIGHT, (Object)height);
                result = globalCmd.chain(setFilterHeightCmd);
                result = result.chain(setHeightCmd);
            } else {
                Command setWidthCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.SIZE__WIDTH, (Object)width);
                Command setHeightCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.SIZE__HEIGHT, (Object)height);
                result = globalCmd.chain(setWidthCmd);
                result = result.chain(setHeightCmd);
            }
        }
        return result;
    }

    private Command getFlaggedRangeApplicationCommand(View newView, TransactionalEditingDomain domain) {
        RecordingCommand flagCommand = null;
        Option<ISequenceEvent> ise = ISequenceElementAccessor.getISequenceEvent(newView);
        if (ise.some()) {
            Rectangle flag = new ISequenceElementQuery((ISequenceElement)ise.get()).getFlaggedAbsoluteBounds();
            if (flag.x == LayoutConstants.EXTERNAL_CHANGE_FLAG.x) {
                LayoutConstraint newViewLC;
                Range flaggedRange = new Range(flag.y, flag.bottom());
                flagCommand = CommandFactory.createRecordingCommand((TransactionalEditingDomain)domain, (AbstractModelChangeOperation)new SetVerticalRangeOperation((ISequenceEvent)ise.get(), flaggedRange));
                if (newView instanceof Node && (newViewLC = ((Node)newView).getLayoutConstraint()) instanceof Size) {
                    Command setWidthCmd = SetCommand.create((EditingDomain)domain, (Object)newViewLC, (Object)NotationPackage.Literals.SIZE__WIDTH, (Object)flag.width);
                    flagCommand = flagCommand.chain(setWidthCmd);
                }
            }
        }
        return flagCommand;
    }

    private void expandSimpleExecution(Node newNode, Command fixSequenceNodeLowerBoundCmd, TransactionalEditingDomain domain, int y) {
        Option<Execution> execOption = ISequenceElementAccessor.getExecution((View)newNode);
        if (execOption.some() && newNode.getSourceEdges().isEmpty() && newNode.getTargetEdges().isEmpty()) {
            int lowerBoundOfNextEventEnd;
            int newUpperRange;
            Execution execution = (Execution)execOption.get();
            View parentView = (View)newNode.eContainer();
            Option<ISequenceEvent> parentSequenceEvent = ISequenceElementAccessor.getISequenceEvent(parentView);
            Range parentEventRange = null;
            if (parentSequenceEvent.some()) {
                parentEventRange = ((ISequenceEvent)parentSequenceEvent.get()).getVerticalRange();
            }
            int finalHeight = 30;
            int lowerRange = y;
            if (parentEventRange != null) {
                lowerRange += parentEventRange.getLowerBound();
            }
            int upperRange = lowerRange + execution.getProperLogicalBounds().height;
            if (this.hasEventEndsAfterUpperRange(execution, lowerRange, Collections.singleton(execution)) && (newUpperRange = (lowerBoundOfNextEventEnd = this.getRangeLimitOfNextEventEndOf(execution, lowerRange, Collections.singleton(execution))) - 5) > upperRange) {
                finalHeight = newUpperRange - lowerRange;
                Command setExecHeightCmd = SetCommand.create((EditingDomain)domain, (Object)newNode.getLayoutConstraint(), (Object)NotationPackage.Literals.SIZE__HEIGHT, (Object)finalHeight);
                fixSequenceNodeLowerBoundCmd.chain(setExecHeightCmd);
            }
        }
    }

    private int getRangeLimitOfNextEventEndOf(Execution execution, int upperRange, Set<ISequenceEvent> sequenceEventToIgnores) {
        SequenceDiagram sequenceDiagram = execution.getDiagram();
        SequenceDDiagram sequenceDDiagram = sequenceDiagram.getSequenceDDiagram();
        int rangeLimitOfNextEventEnd = 0;
        EventEnd eventEndAfter = null;
        VerticalPositionFunction vpf = new VerticalPositionFunction(sequenceDDiagram);
        for (EventEnd end : sequenceDDiagram.getGraphicalOrdering().getEventEnds()) {
            int pos = vpf.apply(end);
            if (pos == Integer.MAX_VALUE || pos <= upperRange) continue;
            eventEndAfter = end;
            break;
        }
        int parentBottomMargin = 5;
        rangeLimitOfNextEventEnd = eventEndAfter != null ? new VerticalPositionFunction(sequenceDDiagram).apply(eventEndAfter) : upperRange + 30 + parentBottomMargin;
        return rangeLimitOfNextEventEnd;
    }

    private boolean hasEventEndsAfterUpperRange(Execution execution, int upperRange, Set<ISequenceEvent> sequenceEventToIgnores) {
        SequenceDiagram sequenceDiagram = execution.getDiagram();
        Lifeline lifeline = (Lifeline)execution.getLifeline().get();
        Set<ISequenceEvent> eventEndsAfterUpperRange = this.getEventEndsAfterUpperRange(sequenceDiagram, lifeline, upperRange, sequenceEventToIgnores);
        Set<ISequenceEvent> eventEndsOnUpperRange = this.getEventEndsOnUpperRange(sequenceDiagram, lifeline, upperRange, sequenceEventToIgnores);
        return !eventEndsAfterUpperRange.isEmpty() || !eventEndsOnUpperRange.isEmpty();
    }

    private Set<ISequenceEvent> getEventEndsAfterUpperRange(SequenceDiagram sequenceDiagram, Lifeline lifeline, int upperRange, Set<ISequenceEvent> sequenceEventToIgnores) {
        TreeSet<ISequenceElement> eventEndsAfterUpperRange = new TreeSet<ISequenceElement>(new RangeComparator());
        Set<ISequenceEvent> allSequenceEventsInUpperRange = new SequenceDiagramQuery(sequenceDiagram).getAllSequenceEventsUpperThan(upperRange);
        allSequenceEventsInUpperRange.removeAll(sequenceEventToIgnores);
        eventEndsAfterUpperRange.addAll(Sets.filter(allSequenceEventsInUpperRange, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Lifeline.class))));
        return eventEndsAfterUpperRange;
    }

    private Set<ISequenceEvent> getEventEndsOnUpperRange(SequenceDiagram sequenceDiagram, Lifeline lifeline, int upperRange, Set<ISequenceEvent> sequenceEventToIgnores) {
        TreeSet<ISequenceElement> eventEndsOnUpperRange = new TreeSet<ISequenceElement>(new RangeComparator());
        Set<ISequenceEvent> allSequenceEventsOnRange = new SequenceDiagramQuery(sequenceDiagram).getAllSequenceEventsOn(upperRange);
        allSequenceEventsOnRange.removeAll(sequenceEventToIgnores);
        eventEndsOnUpperRange.addAll(Sets.filter(allSequenceEventsOnRange, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(Lifeline.class))));
        return eventEndsOnUpperRange;
    }

    private Command getFixBendpointsForSequenceMessageCmd(Edge newEdge) {
        FixBendpointsOnCreationCommand changeBendpointsCmd = null;
        if (newEdge != null && ISequenceElementAccessor.getMessage((View)newEdge).some()) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)newEdge);
            changeBendpointsCmd = new FixBendpointsOnCreationCommand(domain, newEdge);
            changeBendpointsCmd = changeBendpointsCmd.chain(this.getFlaggedRangeApplicationCommand((View)newEdge, domain));
        }
        return changeBendpointsCmd;
    }

    public int priority() {
        return 6;
    }
}

