/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.tools.common.utils;

import adaptorinterface.DomainSpecification;
import adaptorinterface.Resource;
import adaptorinterface.ResourceProperty;
import adaptorinterface.ResourcePropertyOccurs;
import adaptorinterface.ResourcePropertyValueType;
import java.net.URI;
import javax.xml.namespace.QName;
import org.eclipse.lyo.oslc4j.core.model.Occurs;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ValueType;
import org.eclipse.lyo.tools.common.utils.DomainSpecificationVocabulary;
import vocabulary.Vocabulary;

public class ResourcePropertyShapeVocabulary {
    public QName deducePropertyDefinition(ResourceProperty self) {
        if (self.getPropertyDefinition() != null) {
            Vocabulary v = (Vocabulary)self.getPropertyDefinition().eContainer();
            return new QName(v.getNamespaceURI(), self.getPropertyDefinition().getName(), v.getPreferredNamespacePrefix());
        }
        DomainSpecification ds = (DomainSpecification)self.eContainer();
        DomainSpecificationVocabulary vocab = new DomainSpecificationVocabulary();
        QName deducedVocabulary = vocab.deduceVocabulary(ds);
        return new QName(deducedVocabulary.getNamespaceURI(), self.getName(), deducedVocabulary.getPrefix());
    }

    public String deducePropertyDefinition_namespaceURI(ResourceProperty self) {
        return this.deducePropertyDefinition(self).getNamespaceURI();
    }

    public String deducePropertyDefinition_localPart(ResourceProperty self) {
        return this.deducePropertyDefinition(self).getLocalPart();
    }

    public String deducePropertyDefinition_prefix(ResourceProperty self) {
        return this.deducePropertyDefinition(self).getPrefix();
    }

    public String deducePropertyDefinitionComment(ResourceProperty self) {
        if (self.getPropertyDefinition() != null) {
            return self.getPropertyDefinition().getComment();
        }
        return self.getVocabularyComment();
    }

    public URI deducePropertyDefinition_URI(ResourceProperty self) {
        return URI.create(String.valueOf(this.deducePropertyDefinition_namespaceURI(self)) + this.deducePropertyDefinition_localPart(self));
    }

    public URI getPropertyShapeURI(ResourceProperty self) {
        return URI.create(String.valueOf(((DomainSpecification)self.eContainer()).getNamespaceURI()) + self.getName());
    }

    public boolean isLiteral(ResourceProperty self) {
        return self.getValueType().compareTo((Enum)ResourcePropertyValueType.LOCAL_RESOURCE) != 0 && self.getValueType().compareTo((Enum)ResourcePropertyValueType.RESOURCE) != 0;
    }

    public boolean isCardinalityMany(ResourceProperty self) {
        return self.getOccurs().compareTo((Enum)ResourcePropertyOccurs.EXACTLY_ONE) != 0 && self.getOccurs().compareTo((Enum)ResourcePropertyOccurs.ZERO_OR_ONE) != 0;
    }

    public Occurs oslcCardinality(ResourceProperty self) {
        switch (self.getOccurs()) {
            case EXACTLY_ONE: {
                return Occurs.ExactlyOne;
            }
            case ONE_OR_MANY: {
                return Occurs.OneOrMany;
            }
            case ZERO_OR_MANY: {
                return Occurs.ZeroOrMany;
            }
            case ZERO_OR_ONE: {
                return Occurs.ZeroOrOne;
            }
        }
        return Occurs.ExactlyOne;
    }

    public ValueType oslcValueType(ResourceProperty self) {
        switch (self.getValueType()) {
            case BOOLEAN: {
                return ValueType.Boolean;
            }
            case DATE_TIME: {
                return ValueType.DateTime;
            }
            case DOUBLE: {
                return ValueType.Double;
            }
            case FLOAT: {
                return ValueType.Float;
            }
            case INTEGER: {
                return ValueType.Integer;
            }
            case LOCAL_RESOURCE: {
                return ValueType.LocalResource;
            }
            case RESOURCE: {
                return ValueType.Resource;
            }
            case STRING: {
                return ValueType.String;
            }
            case URI: {
                return ValueType.Resource;
            }
            case XML_LITERAL: {
                return ValueType.XMLLiteral;
            }
        }
        return ValueType.String;
    }

    public Representation oslcRepresentation(ResourceProperty self) {
        switch (self.getRepresentation()) {
            case REFERENCE: {
                return Representation.Reference;
            }
            case INLINE: {
                return Representation.Inline;
            }
            case EITHER: {
                return null;
            }
            case NA: {
                return null;
            }
        }
        return Representation.Reference;
    }

    public String cardinalityRepresentation(ResourceProperty self, Boolean numeric) {
        if (numeric.booleanValue()) {
            switch (self.getOccurs()) {
                case EXACTLY_ONE: {
                    return "[1]";
                }
                case ZERO_OR_ONE: {
                    return "[0..1]";
                }
                case ZERO_OR_MANY: {
                    return "[0..*]";
                }
                case ONE_OR_MANY: {
                    return "[1..*]";
                }
            }
            return "[*..*]";
        }
        return this.oslcCardinality(self).name();
    }

    public String toString(ResourceProperty self, Boolean withShapeLabel, Boolean withPrefix, Boolean withConstraints) {
        String s = "";
        if (withShapeLabel.booleanValue()) {
            DomainSpecification ds = (DomainSpecification)self.eContainer();
            s = String.valueOf(s) + (withPrefix != false ? String.valueOf(ds.getNamespacePrefix().getName()) + ":" : "");
            s = String.valueOf(s) + self.getName();
        } else {
            s = String.valueOf(s) + (withPrefix != false ? String.valueOf(this.deducePropertyDefinition(self).getPrefix()) + ":" : "");
            s = String.valueOf(s) + this.deducePropertyDefinition(self).getLocalPart();
        }
        if (withConstraints.booleanValue()) {
            s = String.valueOf(s) + " : ";
            s = this.isLiteral(self) ? String.valueOf(s) + self.getValueType().getName() : (self.getRange().size() == 0 ? String.valueOf(s) + "Resource" : String.valueOf(s) + ((Resource)self.getRange().get(0)).getName() + (self.getRange().size() > 1 ? "++" : ""));
            if (this.isCardinalityMany(self)) {
                s = String.valueOf(s) + "[]";
            }
        }
        return s;
    }
}

