/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.instructions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.eval.RemoteEvaluator;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.CompoundInstruction;
import org.eclipse.jdt.internal.debug.eval.ast.instructions.InstructionsEvaluationMessages;

public class RemoteOperator
extends CompoundInstruction {
    private RemoteEvaluator fEvaluator;
    private String fSignature;

    public RemoteOperator(String body, int start, RemoteEvaluator evaluator) {
        super(start);
        this.fSignature = body;
        this.fEvaluator = evaluator;
    }

    @Override
    public void execute() throws CoreException {
        int variableCount = this.fEvaluator.getVariableCount();
        IJavaValue[] args = new IJavaValue[variableCount];
        int i = variableCount - 1;
        while (i >= 0) {
            args[i] = this.popValue();
            --i;
        }
        IJavaValue result = this.fEvaluator.evaluate(this.getContext().getThread(), args);
        this.push(result);
    }

    public String toString() {
        return String.valueOf(InstructionsEvaluationMessages.Run_Remote_1) + this.fSignature;
    }
}

